/*
 * Decompiled with CFR 0.152.
 */
package com.sun.star.lib.uno.helper;

import com.sun.star.lang.IllegalArgumentException;
import com.sun.star.lang.XInitialization;
import com.sun.star.lang.XServiceInfo;
import com.sun.star.lang.XSingleComponentFactory;
import com.sun.star.lib.uno.helper.ComponentBase;
import com.sun.star.registry.InvalidRegistryException;
import com.sun.star.registry.XRegistryKey;
import com.sun.star.uno.DeploymentException;
import com.sun.star.uno.RuntimeException;
import com.sun.star.uno.UnoRuntime;
import com.sun.star.uno.XComponentContext;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;

public class Factory
extends ComponentBase
implements XSingleComponentFactory,
XServiceInfo {
    private static final boolean DEBUG = false;
    private final String m_impl_name;
    private final String[] m_supported_services;
    private final Class<?> m_impl_class;
    private final Method m_method;
    private final Constructor m_ctor;

    public static XSingleComponentFactory createComponentFactory(Class impl_class, String impl_name, String[] supported_services) throws RuntimeException {
        return new Factory(impl_class, impl_name, supported_services);
    }

    public static XSingleComponentFactory createComponentFactory(Class impl_class, String[] supported_services) throws RuntimeException {
        return Factory.createComponentFactory(impl_class, impl_class.getName(), supported_services);
    }

    public static boolean writeRegistryServiceInfo(String impl_name, String[] supported_services, XRegistryKey xKey) {
        try {
            XRegistryKey xNewKey = xKey.createKey("/" + impl_name + "/UNO/SERVICES");
            for (int nPos = 0; nPos < supported_services.length; ++nPos) {
                xNewKey.createKey(supported_services[nPos]);
            }
            return true;
        }
        catch (InvalidRegistryException invalidRegistryException) {
            return false;
        }
    }

    private Factory(Class impl_class, String impl_name, String[] supported_services) throws DeploymentException {
        this.m_impl_name = impl_name;
        this.m_supported_services = supported_services;
        this.m_impl_class = impl_class;
        Class[] params = new Class[]{XComponentContext.class};
        if (!Modifier.isPublic(impl_class.getModifiers())) {
            throw new DeploymentException("class " + impl_class + " is not public");
        }
        Method tmpMethod = null;
        try {
            tmpMethod = this.m_impl_class.getMethod("__create", params);
            int mod = tmpMethod.getModifiers();
            if (!(tmpMethod.getReturnType().equals(Object.class) && Modifier.isStatic(mod) && Modifier.isPublic(mod))) {
                tmpMethod = null;
            }
        }
        catch (Exception mod) {
            // empty catch block
        }
        this.m_method = tmpMethod;
        Constructor<?> tmpCtor = null;
        if (null == this.m_method) {
            try {
                tmpCtor = this.m_impl_class.getConstructor(params);
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (tmpCtor != null) {
                if (!Modifier.isPublic(tmpCtor.getModifiers())) {
                    throw new DeploymentException("constructor with XComponentContext param for class  " + impl_class + " is not public");
                }
            } else {
                Constructor<?> defaultCtor;
                try {
                    defaultCtor = this.m_impl_class.getConstructor(new Class[0]);
                }
                catch (Exception exc2) {
                    throw new DeploymentException(exc2, "class " + impl_class + " has no means of creating it, cannot find a __create method or a useful constructor.");
                }
                if (!Modifier.isPublic(defaultCtor.getModifiers())) {
                    throw new DeploymentException("default constructor for class  " + impl_class + " is not public");
                }
            }
        }
        this.m_ctor = tmpCtor;
    }

    private Object instantiate(XComponentContext xContext) throws com.sun.star.uno.Exception {
        try {
            if (null != this.m_method) {
                return this.m_method.invoke(null, xContext);
            }
            if (null != this.m_ctor) {
                return this.m_ctor.newInstance(xContext);
            }
            return this.m_impl_class.newInstance();
        }
        catch (InvocationTargetException exc) {
            Throwable targetException = exc.getTargetException();
            if (targetException instanceof java.lang.RuntimeException) {
                throw (java.lang.RuntimeException)targetException;
            }
            if (targetException instanceof RuntimeException) {
                throw (RuntimeException)targetException;
            }
            if (targetException instanceof com.sun.star.uno.Exception) {
                throw (com.sun.star.uno.Exception)targetException;
            }
            throw new com.sun.star.uno.Exception(targetException, targetException.getMessage(), this);
        }
        catch (IllegalAccessException exc) {
            throw new RuntimeException(exc, exc.getMessage(), this);
        }
        catch (InstantiationException exc) {
            throw new RuntimeException(exc, exc.getMessage(), this);
        }
    }

    @Override
    public final Object createInstanceWithContext(XComponentContext xContext) throws com.sun.star.uno.Exception {
        return this.instantiate(xContext);
    }

    @Override
    public final Object createInstanceWithArgumentsAndContext(Object[] arguments, XComponentContext xContext) throws com.sun.star.uno.Exception {
        Object inst = this.instantiate(xContext);
        XInitialization xInit = UnoRuntime.queryInterface(XInitialization.class, inst);
        if (null == xInit) {
            throw new IllegalArgumentException("cannot pass arguments to component; no XInitialization implemented!", this, 0);
        }
        xInit.initialize(arguments);
        return inst;
    }

    @Override
    public final String getImplementationName() {
        return this.m_impl_name;
    }

    @Override
    public final boolean supportsService(String service_name) {
        for (int nPos = 0; nPos < this.m_supported_services.length; ++nPos) {
            if (!this.m_supported_services[nPos].equals(service_name)) continue;
            return true;
        }
        return false;
    }

    @Override
    public final String[] getSupportedServiceNames() {
        return this.m_supported_services;
    }
}

