"use strict";
var __extends = (this && this.__extends) || (function () {
    var extendStatics = Object.setPrototypeOf ||
        ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
        function (d, b) { for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p]; };
    return function (d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
Object.defineProperty(exports, "__esModule", { value: true });
var hlImpl = require("../highLevelImpl");
var jsyaml = require("../jsyaml/jsyaml2lowLevel");
var def = require("raml-definition-system");
var ramlService = def;
var defaultCalculator = require("./defaultCalculator");
var search = require("../../search/search-interface");
var universeHelpers = require("../tools/universeHelpers");
var jsonSerializer = require("../../util/jsonSerializer");
var yaml = require("yaml-ast-parser");
var BasicNodeImpl = /** @class */ (function () {
    /**
     * @hidden
     **/
    function BasicNodeImpl(_node, setAsWrapper) {
        if (setAsWrapper === void 0) { setAsWrapper = true; }
        this._node = _node;
        this._meta = new NodeMetadataImpl(false, false, universeHelpers.isMethodType(this.highLevel().definition()) && this.optional());
        if (setAsWrapper) {
            _node.setWrapperNode(this);
        }
    }
    BasicNodeImpl.isInstance = function (instance) {
        if (instance != null && instance.getClassIdentifier
            && typeof (instance.getClassIdentifier) == "function") {
            for (var _i = 0, _a = instance.getClassIdentifier(); _i < _a.length; _i++) {
                var currentIdentifier = _a[_i];
                if (currentIdentifier == BasicNodeImpl.CLASS_IDENTIFIER)
                    return true;
            }
        }
        return false;
    };
    BasicNodeImpl.prototype.getClassIdentifier = function () {
        var superIdentifiers = [];
        return superIdentifiers.concat(BasicNodeImpl.CLASS_IDENTIFIER);
    };
    /**
     * @hidden
     **/
    BasicNodeImpl.prototype.wrapperClassName = function () {
        return 'BasicNodeImpl';
    };
    BasicNodeImpl.prototype.kind = function () {
        return 'BasicNode';
    };
    /**
     * Returns all kinds of this node.
     * @returns {string[]}
     */
    BasicNodeImpl.prototype.allKinds = function () {
        return ["BasicNode"];
    };
    /**
     * Returns all of implementation class names of this node.
     * @returns {string[]}
     */
    BasicNodeImpl.prototype.allWrapperClassNames = function () {
        return ["BasicNodeImpl"];
    };
    /**
     * @return Direct ancestor in RAML hierarchy
     **/
    BasicNodeImpl.prototype.parent = function () {
        var parent = this._node.parent();
        return parent ? parent.wrapperNode() : null;
    };
    /**
     * @hidden
     * @return Underlying node of the High Level model
     **/
    BasicNodeImpl.prototype.highLevel = function () {
        return this._node;
    };
    /**
     * @hidden
     * Replace underlying high level node
     **/
    BasicNodeImpl.prototype.patchNode = function (node) {
        this._node = node;
    };
    /**
     * @hidden
     **/
    BasicNodeImpl.prototype.attributes = function (name, constr) {
        var attrs = this._node.attributes(name);
        if (!attrs || attrs.length == 0) {
            var defaultValue = this.getDefaultsCalculator().
                attributeDefaultIfEnabled(this._node, this._node.definition().property(name));
            if (defaultValue == null)
                return [];
            return Array.isArray(defaultValue) ? defaultValue : [defaultValue];
        }
        //TODO not sure if we want to artificially create missing attributes having
        //default values
        return attributesToValues(attrs, constr);
    };
    /**
     * @hidden
     **/
    BasicNodeImpl.prototype.attribute = function (name, constr) {
        var attr = this._node.attr(name);
        if (constr && !(constr == this.toString ||
            constr == this.toBoolean ||
            constr == this.toNumber ||
            constr == this.toAny)) {
            //we're not putting values directly inside anything, besides the default
            //convertors for default types we support
            if (attr == null)
                return null;
            return constr(attr);
        }
        var attributeValue = attr ? attr.value() : null;
        if (attributeValue == null) {
            attributeValue = this.getDefaultsCalculator().
                attributeDefaultIfEnabled(this._node, this._node.definition().property(name));
        }
        if (attributeValue == null)
            return null;
        if (constr) {
            return constr(attributeValue);
        }
        else {
            return attributeValue;
        }
    };
    /**
     * @hidden
     **/
    BasicNodeImpl.prototype.elements = function (name) {
        var elements = this._node.elementsOfKind(name);
        if (!elements) {
            return null;
        }
        return elements.map(function (x) { return x.wrapperNode(); });
    };
    /**
     * @hidden
     **/
    BasicNodeImpl.prototype.element = function (name) {
        var element = this._node.element(name);
        if (!element) {
            return null;
        }
        return element.wrapperNode();
    };
    /**
     * Append node as child
     * @param node node to be appended
     **/
    BasicNodeImpl.prototype.add = function (node) {
        this.highLevel().add(node.highLevel());
    };
    /**
     * Append node as property value
     * @param node node to be set as property value
     * @param prop name of property to set value for
     **/
    BasicNodeImpl.prototype.addToProp = function (node, prop) {
        var hl = node.highLevel();
        var pr = this.highLevel().definition().property(prop);
        hl._prop = pr;
        this.highLevel().add(hl);
    };
    /**
     * Remove node from children set
     * @param node node to be removed
     **/
    BasicNodeImpl.prototype.remove = function (node) {
        this.highLevel().remove(node.highLevel());
    };
    /**
     * @return YAML string representing the node
     **/
    BasicNodeImpl.prototype.dump = function () {
        return this.highLevel().dump("yaml");
    };
    BasicNodeImpl.prototype.toString = function (arg) {
        var obj;
        //kind of instanceof for hl.IAttribute without actually calling instanceof
        if (arg && arg.lowLevel && arg.property) {
            obj = arg.value();
        }
        else {
            obj = arg;
        }
        return obj != null ? obj.toString() : obj;
    };
    BasicNodeImpl.prototype.toAny = function (arg) {
        var obj;
        //kind of instanceof for hl.IAttribute without actually calling instanceof
        if (arg.lowLevel && arg.property) {
            var attr = arg;
            var value = attr.value();
            if (value) {
                obj = value;
            }
            else {
                obj = new TypeInstanceImpl(attr.lowLevel());
            }
        }
        else {
            obj = arg;
        }
        if (hlImpl.StructuredValue.isInstance(obj)) {
            obj = new TypeInstanceImpl(obj.lowLevel().parent());
        }
        return obj;
    };
    BasicNodeImpl.prototype.toBoolean = function (arg) {
        var obj;
        //kind of instanceof for hl.IAttribute without actually calling instanceof
        if (arg.lowLevel && arg.property) {
            obj = arg.value();
        }
        else {
            obj = arg;
        }
        return obj != null ? obj.toString() == 'true' : obj;
    };
    BasicNodeImpl.prototype.toNumber = function (arg) {
        var obj;
        //kind of instanceof for hl.IAttribute without actually calling instanceof
        if (arg.lowLevel && arg.property) {
            obj = arg.value();
        }
        else {
            obj = arg;
        }
        if (!obj) {
            return obj;
        }
        try {
            var nValue = parseFloat(obj.toString());
            return nValue;
        }
        catch (e) { }
        return Number.MAX_VALUE;
    };
    /**
     * @return Array of errors
     **/
    BasicNodeImpl.prototype.errors = function () {
        return errors(this._node);
    };
    /**
     * @return object representing class of the node
     **/
    BasicNodeImpl.prototype.definition = function () {
        return this.highLevel().definition();
    };
    /**
     * @return for user class instances returns object representing actual user class
     **/
    BasicNodeImpl.prototype.runtimeDefinition = function () {
        if (universeHelpers.isTypeDeclarationSibling(this.highLevel().definition())) {
            return this.highLevel().localType();
        }
        return null;
    };
    BasicNodeImpl.prototype.toJSON = function (serializeOptions) {
        var oldDefaults = defaultAttributeDefaultsValue;
        defaultAttributeDefaultsValue = this.attributeDefaults();
        try {
            return new jsonSerializer.JsonSerializer(serializeOptions).dump(this);
        }
        finally {
            defaultAttributeDefaultsValue = oldDefaults;
        }
    };
    /**
     * @return Whether the element is an optional sibling of trait or resource type
     **/
    BasicNodeImpl.prototype.optional = function () {
        var highLevel = this.highLevel();
        return highLevel != null ? highLevel.optional() : false;
    };
    /**
     * @return For siblings of traits or resource types returns an array of optional properties names.
     **/
    BasicNodeImpl.prototype.optionalProperties = function () {
        if (!this.highLevel()) {
            return [];
        }
        return this.highLevel().optionalProperties();
    };
    /**
     * @hidden
     **/
    BasicNodeImpl.prototype.getDefaultsCalculator = function () {
        if (this.defaultsCalculator) {
            return this.defaultsCalculator;
        }
        if (this.parent()) {
            this.defaultsCalculator = this.parent().getDefaultsCalculator();
        }
        if (!this.defaultsCalculator) {
            this.defaultsCalculator = new defaultCalculator.AttributeDefaultsCalculator(defaultAttributeDefaultsValue);
        }
        return this.defaultsCalculator;
    };
    /**
     * @hidden
     **/
    BasicNodeImpl.prototype.setAttributeDefaults = function (attributeDefaults) {
        this.defaultsCalculator = new defaultCalculator.AttributeDefaultsCalculator(attributeDefaults);
    };
    BasicNodeImpl.prototype.attributeDefaults = function () {
        return this.getDefaultsCalculator() && this.getDefaultsCalculator().isEnabled();
    };
    BasicNodeImpl.prototype.meta = function () {
        return fillElementMeta(this);
    };
    BasicNodeImpl.prototype.RAMLVersion = function () {
        return this.highLevel().definition().universe().version();
    };
    BasicNodeImpl.CLASS_IDENTIFIER = "parserCore.BasicNodeImpl";
    return BasicNodeImpl;
}());
exports.BasicNodeImpl = BasicNodeImpl;
var defaultAttributeDefaultsValue = true;
var AttributeNodeImpl = /** @class */ (function () {
    function AttributeNodeImpl(attr) {
        this._meta = new ValueMetadataImpl();
        this.attr = attr;
    }
    AttributeNodeImpl.isInstance = function (instance) {
        if (instance != null && instance.getClassIdentifier
            && typeof (instance.getClassIdentifier) == "function") {
            for (var _i = 0, _a = instance.getClassIdentifier(); _i < _a.length; _i++) {
                var currentIdentifier = _a[_i];
                if (currentIdentifier == AttributeNodeImpl.CLASS_IDENTIFIER)
                    return true;
            }
        }
        return false;
    };
    AttributeNodeImpl.prototype.getClassIdentifier = function () {
        var superIdentifiers = [];
        return superIdentifiers.concat(AttributeNodeImpl.CLASS_IDENTIFIER);
    };
    /**
     * @return Underlying High Level attribute node
     **/
    AttributeNodeImpl.prototype.highLevel = function () { return this.attr; };
    /**
     * @hidden
     **/
    AttributeNodeImpl.prototype.wrapperClassName = function () {
        return 'AttributeNodeImpl';
    };
    AttributeNodeImpl.prototype.kind = function () {
        return 'AttributeNode';
    };
    /**
     * Returns all kinds of this node.
     * @returns {string[]}
     */
    AttributeNodeImpl.prototype.allKinds = function () {
        return ["AttributeNode"];
    };
    /**
     * Returns all of implementation class names of this node.
     * @returns {string[]}
     */
    AttributeNodeImpl.prototype.allWrapperClassNames = function () {
        return ["AttributeNodeImpl"];
    };
    /**
     * @return Whether the element is an optional sibling of trait or resource type
     **/
    AttributeNodeImpl.prototype.optional = function () {
        var highLevel = this.highLevel();
        return highLevel != null ? highLevel.optional() : false;
    };
    AttributeNodeImpl.prototype.meta = function () {
        return this._meta;
    };
    AttributeNodeImpl.prototype.RAMLVersion = function () {
        return this.highLevel().definition().universe().version();
    };
    AttributeNodeImpl.prototype.parent = function () {
        var parent = this.attr.parent();
        return parent ? parent.wrapperNode() : null;
    };
    AttributeNodeImpl.prototype.toJSON = function (serializeOptions) {
        return new jsonSerializer.JsonSerializer(serializeOptions).dump(this);
    };
    AttributeNodeImpl.CLASS_IDENTIFIER = "parserCore.AttributeNodeImpl";
    return AttributeNodeImpl;
}());
exports.AttributeNodeImpl = AttributeNodeImpl;
/**
 * @hidden
 **/
function toStructuredValue(node) {
    var value = node.value();
    if (typeof value === 'string' || value == null) {
        var mockNode = jsyaml.createNode(value, null, node.lowLevel().unit());
        mockNode._actualNode().startPosition = node.lowLevel().valueStart();
        mockNode._actualNode().endPosition = node.lowLevel().valueEnd();
        var stv = new hlImpl.StructuredValue(mockNode, node.parent(), node.property());
        return stv;
    }
    else {
        return value;
    }
}
exports.toStructuredValue = toStructuredValue;
var TypeInstanceImpl = /** @class */ (function () {
    function TypeInstanceImpl(nodes, type) {
        this.type = type;
        if (!Array.isArray(nodes)) {
            this.node = nodes;
        }
        else {
            this.children = nodes;
        }
    }
    TypeInstanceImpl.isInstance = function (instance) {
        if (instance != null && instance.getClassIdentifier
            && typeof (instance.getClassIdentifier) == "function") {
            for (var _i = 0, _a = instance.getClassIdentifier(); _i < _a.length; _i++) {
                var currentIdentifier = _a[_i];
                if (currentIdentifier == TypeInstanceImpl.CLASS_IDENTIFIER)
                    return true;
            }
        }
        return false;
    };
    TypeInstanceImpl.prototype.getClassIdentifier = function () {
        var superIdentifiers = [];
        return superIdentifiers.concat(TypeInstanceImpl.CLASS_IDENTIFIER);
    };
    TypeInstanceImpl.prototype.properties = function () {
        return this.isArray() ? [] : this.getChildren().map(function (x) { return new TypeInstancePropertyImpl(x); });
    };
    TypeInstanceImpl.prototype.getChildren = function () {
        return (this.node && this.node.children()) || this.children;
    };
    TypeInstanceImpl.prototype.value = function () {
        return this.node && this.node.value();
    };
    TypeInstanceImpl.prototype.isScalar = function () {
        if (!this.node) {
            return false;
        }
        if (this.node.children().length != 0) {
            return false;
        }
        if (this.type) {
            return isScalarLike(this.type);
        }
        return true;
    };
    TypeInstanceImpl.prototype.toJSON = function () {
        return new jsonSerializer.JsonSerializer().serializeTypeInstance(this);
    };
    TypeInstanceImpl.prototype.isArray = function () {
        if (!this.node) {
            return false;
        }
        if (this.type) {
            return this.type.isArray();
        }
        return this.node && this.node.valueKind() == yaml.Kind.SEQ;
    };
    TypeInstanceImpl.prototype.items = function () {
        return this.isArray() ? this.node.children().map(function (x) { return new TypeInstanceImpl(x); }) : null;
    };
    TypeInstanceImpl.CLASS_IDENTIFIER = "parserCore.TypeInstanceImpl";
    return TypeInstanceImpl;
}());
exports.TypeInstanceImpl = TypeInstanceImpl;
var TypeInstancePropertyImpl = /** @class */ (function () {
    function TypeInstancePropertyImpl(node) {
        this.node = node;
    }
    TypeInstancePropertyImpl.isInstance = function (instance) {
        if (instance != null && instance.getClassIdentifier
            && typeof (instance.getClassIdentifier) == "function") {
            for (var _i = 0, _a = instance.getClassIdentifier(); _i < _a.length; _i++) {
                var currentIdentifier = _a[_i];
                if (currentIdentifier == TypeInstancePropertyImpl.CLASS_IDENTIFIER)
                    return true;
            }
        }
        return false;
    };
    TypeInstancePropertyImpl.prototype.getClassIdentifier = function () {
        var superIdentifiers = [];
        return superIdentifiers.concat(TypeInstancePropertyImpl.CLASS_IDENTIFIER);
    };
    TypeInstancePropertyImpl.prototype.name = function () {
        return this.node.optional() ? this.node.key() + "?" : this.node.key();
    };
    TypeInstancePropertyImpl.prototype.value = function () {
        if (this.isArray()) {
            var children = this.node.children();
            return children.length > 0 ? new TypeInstanceImpl(children[0]) : null;
        }
        else {
            return new TypeInstanceImpl(this.node);
        }
    };
    TypeInstancePropertyImpl.prototype.values = function () {
        return this.isArray()
            ? this.node.children().map(function (x) { return new TypeInstanceImpl(x); })
            : [new TypeInstanceImpl(this.node)];
    };
    TypeInstancePropertyImpl.prototype.isArray = function () {
        var children = this.node.children();
        if (children.length > 0 && children[0].key() == null) {
            return true;
        }
        var hl = this.node.highLevelNode();
        if (hl) {
            var prop = hl.property();
            if (prop) {
                var range = prop.range();
                if (range) {
                    return range.isArray();
                }
            }
        }
        return this.node.valueKind() == yaml.Kind.SEQ;
    };
    TypeInstancePropertyImpl.CLASS_IDENTIFIER = "parserCore.TypeInstancePropertyImpl";
    return TypeInstancePropertyImpl;
}());
exports.TypeInstancePropertyImpl = TypeInstancePropertyImpl;
var ValueMetadataImpl = /** @class */ (function () {
    function ValueMetadataImpl(_insertedAsDefault, _calculated, _optional) {
        if (_insertedAsDefault === void 0) { _insertedAsDefault = false; }
        if (_calculated === void 0) { _calculated = false; }
        if (_optional === void 0) { _optional = false; }
        this._insertedAsDefault = _insertedAsDefault;
        this._calculated = _calculated;
        this._optional = _optional;
    }
    ValueMetadataImpl.prototype.calculated = function () { return this._calculated; };
    ValueMetadataImpl.prototype.insertedAsDefault = function () { return this._insertedAsDefault; };
    ValueMetadataImpl.prototype.setCalculated = function () {
        this._calculated = true;
    };
    ValueMetadataImpl.prototype.setInsertedAsDefault = function () {
        this._insertedAsDefault = true;
    };
    ValueMetadataImpl.prototype.setOptional = function () {
        this._optional = true;
    };
    ValueMetadataImpl.prototype.optional = function () {
        return this._optional;
    };
    ValueMetadataImpl.prototype.isDefault = function () {
        return !(this._insertedAsDefault || this._calculated || this._optional);
    };
    ValueMetadataImpl.prototype.toJSON = function () {
        var obj = {};
        if (this._calculated) {
            obj['calculated'] = true;
        }
        if (this._insertedAsDefault) {
            obj['insertedAsDefault'] = true;
        }
        if (this._optional) {
            obj['optional'] = true;
        }
        return obj;
    };
    return ValueMetadataImpl;
}());
exports.ValueMetadataImpl = ValueMetadataImpl;
var NodeMetadataImpl = /** @class */ (function (_super) {
    __extends(NodeMetadataImpl, _super);
    function NodeMetadataImpl() {
        var _this = _super !== null && _super.apply(this, arguments) || this;
        _this.valuesMeta = {};
        return _this;
    }
    NodeMetadataImpl.prototype.primitiveValuesMeta = function () { return this.valuesMeta; };
    NodeMetadataImpl.prototype.registerInsertedAsDefaultValue = function (propName) {
        var pMeta = this.valuesMeta[propName];
        if (pMeta == null) {
            this.valuesMeta[propName] = new ValueMetadataImpl(true);
        }
        else {
            pMeta.setInsertedAsDefault();
        }
    };
    NodeMetadataImpl.prototype.registerCalculatedValue = function (propName) {
        var pMeta = this.valuesMeta[propName];
        if (pMeta == null) {
            this.valuesMeta[propName] = new ValueMetadataImpl(false, true);
        }
        else {
            pMeta.setCalculated();
        }
    };
    NodeMetadataImpl.prototype.registerOptionalValue = function (propName) {
        var pMeta = this.valuesMeta[propName];
        if (pMeta == null) {
            this.valuesMeta[propName] = new ValueMetadataImpl(false, false, true);
        }
        else {
            pMeta.setOptional();
        }
    };
    NodeMetadataImpl.prototype.resetPrimitiveValuesMeta = function () {
        this.valuesMeta = {};
    };
    NodeMetadataImpl.prototype.isDefault = function () {
        if (!_super.prototype.isDefault.call(this)) {
            return false;
        }
        return Object.keys(this.valuesMeta).length == 0;
    };
    NodeMetadataImpl.prototype.toJSON = function () {
        var _this = this;
        var obj = _super.prototype.toJSON.call(this);
        var valuesObj = {};
        var propKeys = Object.keys(this.valuesMeta);
        if (propKeys.length > 0) {
            propKeys.forEach(function (x) {
                var childMeta = _this.valuesMeta[x].toJSON();
                if (Object.keys(childMeta).length > 0) {
                    valuesObj[x] = childMeta;
                }
            });
            obj['primitiveValuesMeta'] = valuesObj;
        }
        return obj;
    };
    return NodeMetadataImpl;
}(ValueMetadataImpl));
exports.NodeMetadataImpl = NodeMetadataImpl;
function fillElementMeta(node) {
    var meta = node._meta;
    meta.resetPrimitiveValuesMeta();
    var highLevelNode = node.highLevel();
    highLevelNode.definition().allProperties().forEach(function (p) {
        var name = p.nameId();
        var attrs = highLevelNode.attributes(name);
        var gotValue = false;
        var optional = false;
        attrs.forEach(function (a) {
            gotValue = gotValue || a.value() != null;
            optional = optional || a.optional();
        });
        if (!gotValue) {
            var calculator = node.getDefaultsCalculator();
            var defVal = calculator.attributeDefaultIfEnabled(highLevelNode, p);
            if (defVal != null) {
                var insertionKind = calculator.insertionKind(highLevelNode, p);
                if (insertionKind == defaultCalculator.InsertionKind.CALCULATED) {
                    meta.registerCalculatedValue(name);
                }
                else if (insertionKind == defaultCalculator.InsertionKind.BY_DEFAULT) {
                    meta.registerInsertedAsDefaultValue(name);
                }
            }
        }
    });
    return meta;
}
exports.fillElementMeta = fillElementMeta;
function attributesToValues(attrs, constr) {
    if (constr) {
        return attrs.map(function (x) { return constr(x); });
    }
    else {
        return attrs.map(function (x) { return x.value(); });
    }
}
exports.attributesToValues = attributesToValues;
/**
 * @hidden
 */
function errors(_node) {
    var issues = [];
    var highLevelErrors = _node.errors();
    if (highLevelErrors != null) {
        issues = issues.concat(highLevelErrors);
    }
    var rawResult = issues.map(function (x) { return basicError(_node, x); });
    var result = filterErrors(rawResult);
    return result;
}
exports.errors = errors;
/**
 * @hidden
 */
function filterErrors(rawErrors) {
    var result = [];
    var errorsMap = {};
    rawErrors.map(function (x) { errorsMap[JSON.stringify(x)] = x; });
    var keys = Object.keys(errorsMap);
    for (var i = 0; i < keys.length; i++) {
        result.push(errorsMap[keys[i]]);
    }
    return result;
}
exports.filterErrors = filterErrors;
/**
 * @hidden
 */
function basicError(_node, x) {
    var unit;
    if (x.unit) {
        unit = x.unit;
    }
    else if (x.node) {
        unit = x.node.lowLevel().unit();
    }
    else {
        unit = search.declRoot(_node).lowLevel().unit();
    }
    var lineMapper = (unit && unit.lineMapper()) || _node.lowLevel().unit().lineMapper();
    var startPoint = null;
    try {
        startPoint = lineMapper.position(x.start);
    }
    catch (e) {
        console.warn(e);
    }
    var endPoint = null;
    try {
        endPoint = lineMapper.position(x.end);
    }
    catch (e) {
        console.warn(e);
    }
    var path = x.path || (unit && unit.path());
    var eObj = {
        code: x.code,
        message: x.message,
        path: path,
        range: {
            start: startPoint,
            end: endPoint
        },
        isWarning: x.isWarning
    };
    if (x.extras && x.extras.length > 0) {
        eObj.trace = x.extras.map(function (y) { return basicError(_node, y); });
    }
    return eObj;
}
exports.basicError = basicError;
function isScalarLike(t) {
    if (t.isScalar()) {
        return true;
    }
    var unionSupertypes = t.allSuperTypes().filter(function (x) { return x.isUnion() || x.isIntersection(); });
    for (var _i = 0, unionSupertypes_1 = unionSupertypes; _i < unionSupertypes_1.length; _i++) {
        var ust = unionSupertypes_1[_i];
        var isScalar = true;
        for (var _a = 0, _b = ust.allOptions(); _a < _b.length; _a++) {
            var opt = _b[_a];
            isScalar = isScalar || isScalarLike(opt);
            if (!isScalar) {
                break;
            }
        }
        if (isScalar) {
            return true;
        }
    }
    return false;
}
//# sourceMappingURL=parserCore.js.map