/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.sql.expression.function.scalar.string;

import java.io.IOException;
import java.util.Arrays;
import java.util.Locale;
import java.util.function.Function;
import org.apache.lucene.util.UnicodeUtil;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.xpack.sql.SqlIllegalArgumentException;
import org.elasticsearch.xpack.sql.expression.function.scalar.processor.runtime.Processor;
import org.elasticsearch.xpack.sql.expression.function.scalar.string.StringFunctionUtils;

public class StringProcessor
implements Processor {
    public static final String NAME = "s";
    private final StringOperation processor;

    public StringProcessor(StringOperation processor) {
        this.processor = processor;
    }

    public StringProcessor(StreamInput in) throws IOException {
        this.processor = (StringOperation)in.readEnum(StringOperation.class);
    }

    public void writeTo(StreamOutput out) throws IOException {
        out.writeEnum((Enum)this.processor);
    }

    public String getWriteableName() {
        return NAME;
    }

    @Override
    public Object process(Object input) {
        return this.processor.apply(input);
    }

    StringOperation processor() {
        return this.processor;
    }

    public boolean equals(Object obj) {
        if (obj == null || obj.getClass() != this.getClass()) {
            return false;
        }
        StringProcessor other = (StringProcessor)obj;
        return this.processor == other.processor;
    }

    public int hashCode() {
        return this.processor.hashCode();
    }

    public String toString() {
        return this.processor.toString();
    }

    public static enum StringOperation {
        ASCII(s -> s.length() == 0 ? null : Integer.valueOf(s.charAt(0))),
        CHAR(n -> {
            int i = n.intValue();
            return i < 0 || i > 255 ? null : String.valueOf((char)i);
        }),
        LCASE(s -> s.toLowerCase(Locale.ROOT)),
        UCASE(s -> s.toUpperCase(Locale.ROOT)),
        LENGTH(s -> StringFunctionUtils.trimTrailingWhitespaces(s).length()),
        RTRIM(s -> StringFunctionUtils.trimTrailingWhitespaces(s)),
        LTRIM(s -> StringFunctionUtils.trimLeadingWhitespaces(s)),
        SPACE(n -> {
            int i = n.intValue();
            if (i < 0) {
                return null;
            }
            char[] spaces = new char[i];
            char whitespace = ' ';
            Arrays.fill(spaces, whitespace);
            return new String(spaces);
        }),
        BIT_LENGTH(s -> UnicodeUtil.calcUTF16toUTF8Length((CharSequence)s, (int)0, (int)s.length()) * 8),
        CHAR_LENGTH(String::length);

        private final Function<Object, Object> apply;

        private StringOperation(StringFunction<Object> apply) {
            this.apply = l -> l == null ? null : apply.apply(l);
        }

        private StringOperation(NumericFunction<Object> apply) {
            this.apply = l -> l == null ? null : apply.apply(l);
        }

        private StringOperation(Function<Object, Object> apply) {
            this(apply, false);
        }

        private StringOperation(Function<Object, Object> apply, boolean nullAware) {
            this.apply = nullAware ? apply : l -> l == null ? null : apply.apply(l);
        }

        public final Object apply(Object l) {
            return this.apply.apply(l);
        }

        public String toString() {
            return this == CHAR ? "character" : super.toString();
        }
    }

    private static interface NumericFunction<R> {
        default public R apply(Object o) {
            if (!(o instanceof Number)) {
                throw new SqlIllegalArgumentException("A number is required; received [{}]", o);
            }
            return this.doApply((Number)o);
        }

        public R doApply(Number var1);
    }

    private static interface StringFunction<R> {
        default public R apply(Object o) {
            if (!(o instanceof String) && !(o instanceof Character)) {
                throw new SqlIllegalArgumentException("A string/char is required; received [{}]", o);
            }
            return this.doApply(o.toString());
        }

        public R doApply(String var1);
    }
}

