/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.rollup.action;

import java.io.IOException;
import java.util.List;
import java.util.function.Consumer;
import org.elasticsearch.ExceptionsHelper;
import org.elasticsearch.ResourceNotFoundException;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.FailedNodeException;
import org.elasticsearch.action.TaskOperationFailure;
import org.elasticsearch.action.support.ActionFilters;
import org.elasticsearch.action.support.tasks.BaseTasksRequest;
import org.elasticsearch.action.support.tasks.TransportTasksAction;
import org.elasticsearch.cluster.metadata.IndexNameExpressionResolver;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.tasks.Task;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.TransportService;
import org.elasticsearch.xpack.core.rollup.action.StopRollupJobAction;
import org.elasticsearch.xpack.rollup.action.TransportTaskHelper;
import org.elasticsearch.xpack.rollup.job.RollupJobTask;

public class TransportStopRollupAction
extends TransportTasksAction<RollupJobTask, StopRollupJobAction.Request, StopRollupJobAction.Response, StopRollupJobAction.Response> {
    @Inject
    public TransportStopRollupAction(Settings settings, TransportService transportService, ThreadPool threadPool, ActionFilters actionFilters, IndexNameExpressionResolver indexNameExpressionResolver, ClusterService clusterService) {
        super(settings, "cluster:admin/xpack/rollup/stop", threadPool, clusterService, transportService, actionFilters, indexNameExpressionResolver, StopRollupJobAction.Request::new, StopRollupJobAction.Response::new, "same");
    }

    protected void processTasks(StopRollupJobAction.Request request, Consumer<RollupJobTask> operation) {
        TransportTaskHelper.doProcessTasks(request.getId(), operation, this.taskManager);
    }

    protected void doExecute(Task task, StopRollupJobAction.Request request, ActionListener<StopRollupJobAction.Response> listener) {
        super.doExecute(task, (BaseTasksRequest)request, listener);
    }

    protected void taskOperation(StopRollupJobAction.Request request, RollupJobTask jobTask, ActionListener<StopRollupJobAction.Response> listener) {
        if (jobTask.getConfig().getId().equals(request.getId())) {
            jobTask.stop(listener);
        } else {
            listener.onFailure((Exception)new RuntimeException("ID of rollup task [" + jobTask.getConfig().getId() + "] does not match request's ID [" + request.getId() + "]"));
        }
    }

    protected StopRollupJobAction.Response newResponse(StopRollupJobAction.Request request, List<StopRollupJobAction.Response> tasks, List<TaskOperationFailure> taskOperationFailures, List<FailedNodeException> failedNodeExceptions) {
        if (!taskOperationFailures.isEmpty()) {
            throw ExceptionsHelper.convertToElastic((Exception)taskOperationFailures.get(0).getCause());
        }
        if (!failedNodeExceptions.isEmpty()) {
            throw ExceptionsHelper.convertToElastic((Exception)((Exception)failedNodeExceptions.get(0)));
        }
        if (tasks.size() == 0) {
            throw new ResourceNotFoundException("Task for Rollup Job [" + request.getId() + "] not found", new Object[0]);
        }
        assert (tasks.size() == 1);
        boolean allStopped = tasks.stream().allMatch(StopRollupJobAction.Response::isStopped);
        return new StopRollupJobAction.Response(allStopped);
    }

    protected StopRollupJobAction.Response readTaskResponse(StreamInput in) throws IOException {
        return new StopRollupJobAction.Response(in);
    }
}

