/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.ml;

import org.elasticsearch.client.Client;
import org.elasticsearch.cluster.ClusterChangedEvent;
import org.elasticsearch.cluster.ClusterStateListener;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.component.AbstractComponent;
import org.elasticsearch.common.component.LifecycleListener;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.gateway.GatewayService;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.xpack.ml.MlDailyMaintenanceService;

class MlInitializationService
extends AbstractComponent
implements ClusterStateListener {
    private final ThreadPool threadPool;
    private final ClusterService clusterService;
    private final Client client;
    private volatile MlDailyMaintenanceService mlDailyMaintenanceService;

    MlInitializationService(Settings settings, ThreadPool threadPool, ClusterService clusterService, Client client) {
        super(settings);
        this.threadPool = threadPool;
        this.clusterService = clusterService;
        this.client = client;
        clusterService.addListener((ClusterStateListener)this);
    }

    public void clusterChanged(ClusterChangedEvent event) {
        if (event.state().blocks().hasGlobalBlock(GatewayService.STATE_NOT_RECOVERED_BLOCK)) {
            return;
        }
        if (event.localNodeMaster()) {
            this.installDailyMaintenanceService();
        } else {
            this.uninstallDailyMaintenanceService();
        }
    }

    private void installDailyMaintenanceService() {
        if (this.mlDailyMaintenanceService == null) {
            this.mlDailyMaintenanceService = new MlDailyMaintenanceService(this.clusterService.getClusterName(), this.threadPool, this.client);
            this.mlDailyMaintenanceService.start();
            this.clusterService.addLifecycleListener(new LifecycleListener(){

                public void beforeStop() {
                    MlInitializationService.this.uninstallDailyMaintenanceService();
                }
            });
        }
    }

    private void uninstallDailyMaintenanceService() {
        if (this.mlDailyMaintenanceService != null) {
            this.mlDailyMaintenanceService.stop();
            this.mlDailyMaintenanceService = null;
        }
    }

    MlDailyMaintenanceService getDailyMaintenanceService() {
        return this.mlDailyMaintenanceService;
    }

    void setDailyMaintenanceService(MlDailyMaintenanceService service) {
        this.mlDailyMaintenanceService = service;
    }
}

