/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.client.gui.panel;

import java.awt.Component;
import java.awt.Font;
import javax.swing.JButton;
import javax.swing.JPanel;
import net.miginfocom.swing.MigLayout;
import net.sf.freecol.client.FreeColClient;
import net.sf.freecol.client.gui.Canvas;
import net.sf.freecol.client.gui.FontLibrary;
import net.sf.freecol.client.gui.action.ActionManager;
import net.sf.freecol.client.gui.panel.MapControls;
import net.sf.freecol.client.gui.panel.MigPanel;
import net.sf.freecol.client.gui.panel.UnitButton;
import net.sf.freecol.common.resources.ResourceManager;

public final class ClassicMapControls
extends MapControls {
    private final JPanel panel;
    private final Font arrowFont;
    private final ActionManager am;

    public ClassicMapControls(FreeColClient freeColClient) {
        super(freeColClient, false);
        this.am = freeColClient.getActionManager();
        this.arrowFont = FontLibrary.createFont(FontLibrary.FontType.SIMPLE, FontLibrary.FontSize.SMALL, 1);
        this.panel = new MigPanel();
        this.panel.setLayout(new MigLayout("wrap 3"));
        this.panel.add((Component)this.miniMap, "span, width 220, height 128");
        this.panel.add((Component)this.miniMapZoomInButton, "newline 10");
        this.panel.add((Component)this.miniMapZoomOutButton, "skip");
        this.panel.add((Component)this.makeButton("NW", ResourceManager.getString("arrow.NW")), "newline 20");
        this.panel.add(this.makeButton("N", ResourceManager.getString("arrow.N")));
        this.panel.add(this.makeButton("NE", ResourceManager.getString("arrow.NE")));
        this.panel.add(this.makeButton("W", ResourceManager.getString("arrow.W")));
        this.panel.add((Component)this.makeButton("E", ResourceManager.getString("arrow.E")), "skip");
        this.panel.add(this.makeButton("SW", ResourceManager.getString("arrow.SW")));
        this.panel.add(this.makeButton("S", ResourceManager.getString("arrow.S")));
        this.panel.add((Component)this.makeButton("SE", ResourceManager.getString("arrow.SE")), "wrap 20");
        for (UnitButton button : this.unitButtons) {
            this.panel.add(button);
        }
        this.panel.add((Component)this.infoPanel, "newline push, span, width " + this.infoPanel.getWidth() + ", height " + this.infoPanel.getHeight());
    }

    @Override
    public void addToComponent(Canvas component) {
        if (this.freeColClient.getGame() == null || this.freeColClient.getGame().getMap() == null) {
            return;
        }
        int width = (int)this.panel.getPreferredSize().getWidth();
        this.panel.setSize(width, component.getHeight());
        this.panel.setLocation(component.getWidth() - width, 0);
        component.add((Component)this.panel, CONTROLS_LAYER);
    }

    @Override
    public boolean isShowing() {
        return this.panel.getParent() != null;
    }

    @Override
    public void removeFromComponent(Canvas canvas) {
        canvas.removeFromCanvas(this.panel);
    }

    @Override
    public void repaint() {
        this.panel.repaint();
    }

    private JButton makeButton(String direction, String arrow) {
        JButton button = new JButton(this.am.getFreeColAction("moveAction." + direction));
        button.setFont(this.arrowFont);
        button.setText(arrow);
        return button;
    }
}

