/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.parsing;

import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.com.intellij.lang.PsiBuilder;
import org.jetbrains.kotlin.com.intellij.lang.impl.PsiBuilderAdapter;
import org.jetbrains.kotlin.com.intellij.lang.impl.PsiBuilderImpl;
import org.jetbrains.kotlin.com.intellij.psi.TokenType;
import org.jetbrains.kotlin.com.intellij.psi.tree.IElementType;
import org.jetbrains.kotlin.com.intellij.psi.tree.TokenSet;
import org.jetbrains.kotlin.com.intellij.util.containers.Stack;
import org.jetbrains.kotlin.lexer.KtTokens;
import org.jetbrains.kotlin.parsing.SemanticWhitespaceAwarePsiBuilder;

public class SemanticWhitespaceAwarePsiBuilderImpl
extends PsiBuilderAdapter
implements SemanticWhitespaceAwarePsiBuilder {
    private final TokenSet complexTokens = TokenSet.create(KtTokens.SAFE_ACCESS, KtTokens.ELVIS, KtTokens.EXCLEXCL);
    private final Stack<Boolean> joinComplexTokens = new Stack();
    private final Stack<Boolean> newlinesEnabled = new Stack();
    private final PsiBuilderImpl delegateImpl;

    public SemanticWhitespaceAwarePsiBuilderImpl(PsiBuilder delegate2) {
        super(delegate2);
        this.newlinesEnabled.push(true);
        this.joinComplexTokens.push(true);
        this.delegateImpl = SemanticWhitespaceAwarePsiBuilderImpl.findPsiBuilderImpl(delegate2);
    }

    @Nullable
    private static PsiBuilderImpl findPsiBuilderImpl(PsiBuilder builder) {
        while (!(builder instanceof PsiBuilderImpl)) {
            if (!(builder instanceof PsiBuilderAdapter)) {
                return null;
            }
            builder = ((PsiBuilderAdapter)builder).getDelegate();
        }
        return (PsiBuilderImpl)builder;
    }

    @Override
    public boolean isWhitespaceOrComment(@NotNull IElementType elementType) {
        assert (this.delegateImpl != null) : "PsiBuilderImpl not found";
        return this.delegateImpl.whitespaceOrComment(elementType);
    }

    @Override
    public boolean newlineBeforeCurrentToken() {
        if (!this.newlinesEnabled.peek().booleanValue()) {
            return false;
        }
        if (this.eof()) {
            return true;
        }
        for (int i = 1; i <= this.getCurrentOffset(); ++i) {
            IElementType previousToken = this.rawLookup(-i);
            if (previousToken == KtTokens.BLOCK_COMMENT || previousToken == KtTokens.DOC_COMMENT || previousToken == KtTokens.EOL_COMMENT || previousToken == KtTokens.SHEBANG_COMMENT) continue;
            if (previousToken != TokenType.WHITE_SPACE) break;
            int previousTokenStart = this.rawTokenTypeStart(-i);
            int previousTokenEnd = this.rawTokenTypeStart(-i + 1);
            assert (previousTokenStart >= 0);
            assert (previousTokenEnd < this.getOriginalText().length());
            for (int j = previousTokenStart; j < previousTokenEnd; ++j) {
                if (this.getOriginalText().charAt(j) != '\n') continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public void disableNewlines() {
        this.newlinesEnabled.push(false);
    }

    @Override
    public void enableNewlines() {
        this.newlinesEnabled.push(true);
    }

    @Override
    public void restoreNewlinesState() {
        assert (this.newlinesEnabled.size() > 1);
        this.newlinesEnabled.pop();
    }

    private boolean joinComplexTokens() {
        return this.joinComplexTokens.peek();
    }

    @Override
    public void restoreJoiningComplexTokensState() {
        this.joinComplexTokens.pop();
    }

    @Override
    public void enableJoiningComplexTokens() {
        this.joinComplexTokens.push(true);
    }

    @Override
    public void disableJoiningComplexTokens() {
        this.joinComplexTokens.push(false);
    }

    @Override
    public IElementType getTokenType() {
        if (!this.joinComplexTokens()) {
            return super.getTokenType();
        }
        return this.getJoinedTokenType(super.getTokenType(), 1);
    }

    private IElementType getJoinedTokenType(IElementType rawTokenType, int rawLookupSteps) {
        IElementType nextRawToken;
        if (rawTokenType == KtTokens.QUEST) {
            IElementType nextRawToken2 = this.rawLookup(rawLookupSteps);
            if (nextRawToken2 == KtTokens.DOT) {
                return KtTokens.SAFE_ACCESS;
            }
            if (nextRawToken2 == KtTokens.COLON) {
                return KtTokens.ELVIS;
            }
        } else if (rawTokenType == KtTokens.EXCL && (nextRawToken = this.rawLookup(rawLookupSteps)) == KtTokens.EXCL) {
            return KtTokens.EXCLEXCL;
        }
        return rawTokenType;
    }

    @Override
    public void advanceLexer() {
        if (!this.joinComplexTokens()) {
            super.advanceLexer();
            return;
        }
        IElementType tokenType = this.getTokenType();
        if (this.complexTokens.contains(tokenType)) {
            PsiBuilder.Marker mark = this.mark();
            super.advanceLexer();
            super.advanceLexer();
            mark.collapse(tokenType);
        } else {
            super.advanceLexer();
        }
    }

    @Override
    public String getTokenText() {
        if (!this.joinComplexTokens()) {
            return super.getTokenText();
        }
        IElementType tokenType = this.getTokenType();
        if (this.complexTokens.contains(tokenType)) {
            if (tokenType == KtTokens.ELVIS) {
                return "?:";
            }
            if (tokenType == KtTokens.SAFE_ACCESS) {
                return "?.";
            }
        }
        return super.getTokenText();
    }

    @Override
    public IElementType lookAhead(int steps) {
        if (!this.joinComplexTokens()) {
            return super.lookAhead(steps);
        }
        if (this.complexTokens.contains(this.getTokenType())) {
            return super.lookAhead(steps + 1);
        }
        return this.getJoinedTokenType(super.lookAhead(steps), 2);
    }
}

