/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal;

import groovy.lang.Closure;
import javax.annotation.Nullable;
import org.gradle.api.Action;
import org.gradle.api.InvalidUserDataException;
import org.gradle.api.Named;
import org.gradle.api.NamedDomainObjectContainer;
import org.gradle.api.NamedDomainObjectProvider;
import org.gradle.api.Namer;
import org.gradle.api.internal.DefaultNamedDomainObjectCollection;
import org.gradle.api.internal.DefaultNamedDomainObjectSet;
import org.gradle.api.internal.NamedDomainObjectContainerConfigureDelegate;
import org.gradle.api.reflect.HasPublicType;
import org.gradle.api.reflect.TypeOf;
import org.gradle.internal.Actions;
import org.gradle.internal.Cast;
import org.gradle.internal.ImmutableActionSet;
import org.gradle.internal.metaobject.ConfigureDelegate;
import org.gradle.internal.reflect.Instantiator;
import org.gradle.util.ConfigureUtil;

public abstract class AbstractNamedDomainObjectContainer<T>
extends DefaultNamedDomainObjectSet<T>
implements NamedDomainObjectContainer<T>,
HasPublicType {
    protected AbstractNamedDomainObjectContainer(Class<T> type, Instantiator instantiator, Namer<? super T> namer) {
        super(type, instantiator, namer);
    }

    protected AbstractNamedDomainObjectContainer(Class<T> type, Instantiator instantiator) {
        super(type, instantiator, Named.Namer.forType(type));
    }

    protected abstract T doCreate(String var1);

    public T create(String name) {
        return this.create(name, Actions.doNothing());
    }

    public T maybeCreate(String name) {
        Object item = this.findByName(name);
        if (item != null) {
            return item;
        }
        return this.create(name);
    }

    public T create(String name, Closure configureClosure) {
        return this.create(name, ConfigureUtil.configureUsing(configureClosure));
    }

    public T create(String name, Action<? super T> configureAction) throws InvalidUserDataException {
        this.assertCanAdd(name);
        T object = this.doCreate(name);
        this.add(object);
        configureAction.execute(object);
        return object;
    }

    protected ConfigureDelegate createConfigureDelegate(Closure configureClosure) {
        return new NamedDomainObjectContainerConfigureDelegate(configureClosure, this);
    }

    public AbstractNamedDomainObjectContainer<T> configure(Closure configureClosure) {
        ConfigureDelegate delegate = this.createConfigureDelegate(configureClosure);
        ConfigureUtil.configureSelf(configureClosure, this, delegate);
        return this;
    }

    @Override
    public String getDisplayName() {
        return this.getTypeDisplayName() + " container";
    }

    public TypeOf<?> getPublicType() {
        return TypeOf.parameterizedTypeOf((TypeOf)new TypeOf<NamedDomainObjectContainer<?>>(){}, (TypeOf[])new TypeOf[]{TypeOf.typeOf(this.getType())});
    }

    public NamedDomainObjectProvider<T> register(String name) throws InvalidUserDataException {
        return this.createDomainObjectProvider(name, null);
    }

    public NamedDomainObjectProvider<T> register(String name, Action<? super T> configurationAction) throws InvalidUserDataException {
        return this.createDomainObjectProvider(name, configurationAction);
    }

    protected NamedDomainObjectProvider<T> createDomainObjectProvider(String name, @Nullable Action<? super T> configurationAction) {
        this.assertCanAdd(name);
        NamedDomainObjectProvider provider = (NamedDomainObjectProvider)Cast.uncheckedCast((Object)this.getInstantiator().newInstance(NamedDomainObjectCreatingProvider.class, new Object[]{this, name, configurationAction}));
        this.addLater(provider);
        return provider;
    }

    public class NamedDomainObjectCreatingProvider<I extends T>
    extends DefaultNamedDomainObjectCollection.AbstractNamedDomainObjectProvider<I> {
        private I object;
        private Throwable cause;
        private ImmutableActionSet<I> onCreate;

        public NamedDomainObjectCreatingProvider(@Nullable String name, Action<? super I> configureAction) {
            super(AbstractNamedDomainObjectContainer.this, name);
            this.onCreate = ImmutableActionSet.empty().mergeFrom(AbstractNamedDomainObjectContainer.this.getEventRegister().getAddActions());
            if (configureAction != null) {
                this.configure(configureAction);
            }
        }

        @Override
        public boolean isPresent() {
            return AbstractNamedDomainObjectContainer.this.findDomainObject(this.getName()) != null;
        }

        public void configure(Action<? super I> action) {
            if (this.object != null) {
                action.execute(this.object);
                return;
            }
            this.onCreate = this.onCreate.mergeFrom(AbstractNamedDomainObjectContainer.this.getEventRegister().getAddActions()).add(action);
        }

        public I getOrNull() {
            if (this.cause != null) {
                throw this.createIllegalStateException();
            }
            if (this.object == null) {
                this.object = this.getType().cast(AbstractNamedDomainObjectContainer.this.findByNameWithoutRules(this.getName()));
                if (this.object == null) {
                    try {
                        this.onCreate = this.onCreate.mergeFrom(AbstractNamedDomainObjectContainer.this.getEventRegister().getAddActions());
                        this.object = AbstractNamedDomainObjectContainer.this.doCreate(this.getName());
                        AbstractNamedDomainObjectContainer.this.add(this.object, this.onCreate);
                    }
                    catch (RuntimeException ex) {
                        this.cause = ex;
                        throw this.createIllegalStateException();
                    }
                    finally {
                        this.onCreate = ImmutableActionSet.empty();
                    }
                }
            }
            return this.object;
        }

        private IllegalStateException createIllegalStateException() {
            return new IllegalStateException(String.format("Could not create domain object '%s' (%s)", this.getName(), this.getType().getSimpleName()), this.cause);
        }
    }
}

