/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.tasks;

import com.google.common.collect.Lists;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import javax.annotation.Nullable;
import org.gradle.api.Describable;
import org.gradle.api.NonNullApi;
import org.gradle.api.file.FileCollection;
import org.gradle.api.internal.FilePropertyContainer;
import org.gradle.api.internal.TaskInputsInternal;
import org.gradle.api.internal.TaskInternal;
import org.gradle.api.internal.file.CompositeFileCollection;
import org.gradle.api.internal.file.collections.FileCollectionResolveContext;
import org.gradle.api.internal.tasks.DeclaredTaskInputFileProperty;
import org.gradle.api.internal.tasks.DeclaredTaskInputProperty;
import org.gradle.api.internal.tasks.DefaultTaskInputPropertySpec;
import org.gradle.api.internal.tasks.LenientTaskInputsDeprecationSupport;
import org.gradle.api.internal.tasks.PropertySpecFactory;
import org.gradle.api.internal.tasks.StaticValue;
import org.gradle.api.internal.tasks.TaskInputFilePropertyBuilderInternal;
import org.gradle.api.internal.tasks.TaskInputFilePropertySpec;
import org.gradle.api.internal.tasks.TaskInputPropertySpec;
import org.gradle.api.internal.tasks.TaskMutator;
import org.gradle.api.internal.tasks.TaskPropertyUtils;
import org.gradle.api.internal.tasks.TaskValidationContext;
import org.gradle.api.internal.tasks.ValidationAction;
import org.gradle.api.internal.tasks.ValidationActions;
import org.gradle.api.internal.tasks.properties.GetInputFilesVisitor;
import org.gradle.api.internal.tasks.properties.GetInputPropertiesVisitor;
import org.gradle.api.internal.tasks.properties.PropertyVisitor;
import org.gradle.api.internal.tasks.properties.PropertyWalker;
import org.gradle.api.tasks.TaskInputPropertyBuilder;
import org.gradle.api.tasks.TaskInputs;
import org.gradle.internal.typeconversion.UnsupportedNotationException;
import org.gradle.util.DeprecationLogger;

@NonNullApi
public class DefaultTaskInputs
implements TaskInputsInternal {
    private final FileCollection allInputFiles;
    private final FileCollection allSourceFiles;
    private final TaskInternal task;
    private final TaskMutator taskMutator;
    private final PropertyWalker propertyWalker;
    private final List<DeclaredTaskInputProperty> registeredProperties = Lists.newArrayList();
    private final FilePropertyContainer<DeclaredTaskInputFileProperty> registeredFileProperties = FilePropertyContainer.create();
    private final TaskInputs deprecatedThis;
    private final PropertySpecFactory specFactory;
    private static final ValidationAction RUNTIME_INPUT_FILE_VALIDATOR = DefaultTaskInputs.wrapRuntimeApiValidator("file", ValidationActions.INPUT_FILE_VALIDATOR);
    private static final ValidationAction RUNTIME_INPUT_DIRECTORY_VALIDATOR = DefaultTaskInputs.wrapRuntimeApiValidator("dir", ValidationActions.INPUT_DIRECTORY_VALIDATOR);

    public DefaultTaskInputs(TaskInternal task, TaskMutator taskMutator, PropertyWalker propertyWalker, PropertySpecFactory specFactory) {
        this.task = task;
        this.taskMutator = taskMutator;
        this.propertyWalker = propertyWalker;
        String taskName = task.getName();
        this.allInputFiles = new TaskInputUnionFileCollection(taskName, "input", false, task, propertyWalker);
        this.allSourceFiles = new TaskInputUnionFileCollection(taskName, "source", true, task, propertyWalker);
        this.deprecatedThis = new LenientTaskInputsDeprecationSupport(this);
        this.specFactory = specFactory;
    }

    public boolean getHasInputs() {
        HasInputsVisitor visitor = new HasInputsVisitor();
        TaskPropertyUtils.visitProperties(this.propertyWalker, this.task, visitor);
        return visitor.hasInputs();
    }

    @Override
    public void visitRegisteredProperties(PropertyVisitor visitor) {
        for (DeclaredTaskInputFileProperty fileProperty : this.registeredFileProperties) {
            visitor.visitInputFileProperty(fileProperty);
        }
        for (DeclaredTaskInputProperty inputProperty : this.registeredProperties) {
            visitor.visitInputProperty(inputProperty);
        }
    }

    public FileCollection getFiles() {
        return this.allInputFiles;
    }

    public TaskInputFilePropertyBuilderInternal files(final Object ... paths) {
        return this.taskMutator.mutate("TaskInputs.files(Object...)", new Callable<TaskInputFilePropertyBuilderInternal>(){

            @Override
            public TaskInputFilePropertyBuilderInternal call() {
                StaticValue value = new StaticValue(DefaultTaskInputs.unpackVarargs(paths));
                DeclaredTaskInputFileProperty fileSpec = DefaultTaskInputs.this.specFactory.createInputFileSpec(value, ValidationActions.NO_OP);
                DefaultTaskInputs.this.registeredFileProperties.add(fileSpec);
                return fileSpec;
            }
        });
    }

    private static Object unpackVarargs(Object[] args) {
        if (args.length == 1) {
            return args[0];
        }
        return args;
    }

    public TaskInputFilePropertyBuilderInternal file(final Object path) {
        return this.taskMutator.mutate("TaskInputs.file(Object)", new Callable<TaskInputFilePropertyBuilderInternal>(){

            @Override
            public TaskInputFilePropertyBuilderInternal call() {
                StaticValue value = new StaticValue(path);
                DeclaredTaskInputFileProperty fileSpec = DefaultTaskInputs.this.specFactory.createInputFileSpec(value, RUNTIME_INPUT_FILE_VALIDATOR);
                DefaultTaskInputs.this.registeredFileProperties.add(fileSpec);
                return fileSpec;
            }
        });
    }

    public TaskInputFilePropertyBuilderInternal dir(final Object dirPath) {
        return this.taskMutator.mutate("TaskInputs.dir(Object)", new Callable<TaskInputFilePropertyBuilderInternal>(){

            @Override
            public TaskInputFilePropertyBuilderInternal call() {
                StaticValue value = new StaticValue(dirPath);
                DeclaredTaskInputFileProperty dirSpec = DefaultTaskInputs.this.specFactory.createInputDirSpec(value, RUNTIME_INPUT_DIRECTORY_VALIDATOR);
                DefaultTaskInputs.this.registeredFileProperties.add(dirSpec);
                return dirSpec;
            }
        });
    }

    public boolean getHasSourceFiles() {
        GetInputFilesVisitor visitor = new GetInputFilesVisitor();
        TaskPropertyUtils.visitProperties(this.propertyWalker, this.task, visitor);
        return visitor.hasSourceFiles();
    }

    public FileCollection getSourceFiles() {
        return this.allSourceFiles;
    }

    public Map<String, Object> getProperties() {
        GetInputPropertiesVisitor visitor = new GetInputPropertiesVisitor(this.task.getName());
        TaskPropertyUtils.visitProperties(this.propertyWalker, this.task, visitor);
        return (Map)visitor.getPropertyValuesFactory().create();
    }

    public TaskInputPropertyBuilder property(final String name, final @Nullable Object value) {
        return this.taskMutator.mutate("TaskInputs.property(String, Object)", new Callable<TaskInputPropertyBuilder>(){

            @Override
            public TaskInputPropertyBuilder call() {
                StaticValue staticValue = new StaticValue(value);
                DefaultTaskInputPropertySpec inputPropertySpec = DefaultTaskInputs.this.specFactory.createInputPropertySpec(name, staticValue);
                DefaultTaskInputs.this.registeredProperties.add(inputPropertySpec);
                return inputPropertySpec;
            }
        });
    }

    public TaskInputs properties(final Map<String, ?> newProps) {
        this.taskMutator.mutate("TaskInputs.properties(Map)", new Runnable(){

            @Override
            public void run() {
                for (Map.Entry entry : newProps.entrySet()) {
                    StaticValue staticValue = new StaticValue(entry.getValue());
                    String name = (String)entry.getKey();
                    DefaultTaskInputs.this.registeredProperties.add(DefaultTaskInputs.this.specFactory.createInputPropertySpec(name, staticValue));
                }
            }
        });
        return this.deprecatedThis;
    }

    private static ValidationAction wrapRuntimeApiValidator(final String method, final ValidationAction validator) {
        return new ValidationAction(){

            @Override
            public void validate(String propertyName, Object value, TaskValidationContext context, TaskValidationContext.Severity severity) {
                try {
                    validator.validate(propertyName, value, context, severity);
                }
                catch (UnsupportedNotationException ex) {
                    DeprecationLogger.nagUserWithDeprecatedIndirectUserCodeCause((String)("Using TaskInputs." + method + "() with something that doesn't resolve to a File object"), (String)"Use TaskInputs.files() instead.");
                }
            }
        };
    }

    private static class HasInputsVisitor
    extends PropertyVisitor.Adapter {
        private boolean hasInputs;

        private HasInputsVisitor() {
        }

        public boolean hasInputs() {
            return this.hasInputs;
        }

        @Override
        public void visitInputFileProperty(TaskInputFilePropertySpec inputFileProperty) {
            this.hasInputs = true;
        }

        @Override
        public void visitInputProperty(TaskInputPropertySpec inputProperty) {
            this.hasInputs = true;
        }
    }

    private static class TaskInputUnionFileCollection
    extends CompositeFileCollection
    implements Describable {
        private final boolean skipWhenEmptyOnly;
        private final String taskName;
        private final String type;
        private final TaskInternal task;
        private final PropertyWalker propertyWalker;

        public TaskInputUnionFileCollection(String taskName, String type, boolean skipWhenEmptyOnly, TaskInternal task, PropertyWalker propertyWalker) {
            this.taskName = taskName;
            this.type = type;
            this.skipWhenEmptyOnly = skipWhenEmptyOnly;
            this.task = task;
            this.propertyWalker = propertyWalker;
        }

        @Override
        public String getDisplayName() {
            return "task '" + this.taskName + "' " + this.type + " files";
        }

        @Override
        public void visitContents(final FileCollectionResolveContext context) {
            TaskPropertyUtils.visitProperties(this.propertyWalker, this.task, new PropertyVisitor.Adapter(){

                @Override
                public void visitInputFileProperty(TaskInputFilePropertySpec fileProperty) {
                    if (!TaskInputUnionFileCollection.this.skipWhenEmptyOnly || fileProperty.isSkipWhenEmpty()) {
                        context.add(fileProperty.getPropertyFiles());
                    }
                }
            });
        }
    }
}

