#!/bin/sh
export PATH='/usr/lib/distcc/bin:/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
echo 'name: graphviz
version: 2999.20.0.2
id: graphviz-2999.20.0.2-HUNDPkOlOgI9MDQM0WabK
key: graphviz-2999.20.0.2-HUNDPkOlOgI9MDQM0WabK
license: BSD-3-Clause
copyright: Matthew Sackman, Ivan Lazar Miljenovic
maintainer: Ivan.Miljenovic@gmail.com
author: Matthew Sackman, Ivan Lazar Miljenovic
stability: Beta
homepage: http://projects.haskell.org/graphviz/
synopsis: Bindings to Graphviz for graph visualisation.
description:
    This library provides bindings for the Dot language used by the
    Graphviz (<http://graphviz.org/>) suite of programs for visualising
    graphs, as well as functions to call those programs.
    .
    Main features of the graphviz library include:
    .
    * Almost complete coverage of all Graphviz attributes and syntax.
    .
    * Support for specifying clusters.
    .
    * The ability to use a custom node type.
    .
    * Functions for running a Graphviz layout tool with all specified
    output types.
    .
    * The ability to not only generate but also parse Dot code with two
    options: strict and liberal (in terms of ordering of statements).
    .
    * Functions to convert FGL graphs and other graph-like data structures
    to Dot code - including support to group them into clusters - with a
    high degree of customisation by specifying which attributes to use
    and limited support for the inverse operation.
    .
    * Round-trip support for passing an FGL graph through Graphviz to
    augment node and edge labels with positional information, etc.
category: Graphs, Graphics
abi: afc6617b974f1f3b6cd32d323325ff97
exposed: True
exposed-modules:
    Data.GraphViz Data.GraphViz.Algorithms Data.GraphViz.Attributes
    Data.GraphViz.Attributes.Colors
    Data.GraphViz.Attributes.Colors.Brewer
    Data.GraphViz.Attributes.Colors.SVG
    Data.GraphViz.Attributes.Colors.X11
    Data.GraphViz.Attributes.Complete Data.GraphViz.Attributes.HTML
    Data.GraphViz.Attributes.Internal Data.GraphViz.Commands
    Data.GraphViz.Commands.IO Data.GraphViz.Exception
    Data.GraphViz.Internal.State Data.GraphViz.Internal.Util
    Data.GraphViz.Parsing Data.GraphViz.PreProcessing
    Data.GraphViz.Printing Data.GraphViz.Types
    Data.GraphViz.Types.Canonical Data.GraphViz.Types.Generalised
    Data.GraphViz.Types.Graph Data.GraphViz.Types.Internal.Common
    Data.GraphViz.Types.Monadic
hidden-modules: Data.GraphViz.Algorithms.Clustering
                Data.GraphViz.Attributes.Arrows
                Data.GraphViz.Attributes.ColorScheme Data.GraphViz.Attributes.Same
                Data.GraphViz.Attributes.Values Data.GraphViz.Commands.Available
                Data.GraphViz.Types.State
import-dirs: /usr/lib/ghc-8.4.3/site-local/graphviz-2999.20.0.2
library-dirs: /usr/lib/ghc-8.4.3/site-local/graphviz-2999.20.0.2
dynamic-library-dirs: /usr/lib
data-dir: /usr/share/arm-linux-ghc-8.4.3/graphviz-2999.20.0.2
hs-libraries: HSgraphviz-2999.20.0.2-HUNDPkOlOgI9MDQM0WabK
depends:
    base-4.11.1.0 containers-0.5.11.0 process-1.6.3.0 directory-1.3.1.5
    temporary-1.3-9oQzo4JVNP7CXkKVrv2cKm
    fgl-5.6.0.0-IGmeQfkpQmd48thU3Ee01i filepath-1.4.2
    polyparse-1.12-AafkYPRdYin98WnFInxf9 bytestring-0.10.8.2
    colour-2.3.4-C3PVIHDZkyCIpOJGl3M0hE mtl-2.2.2 text-1.2.3.0
    wl-pprint-text-1.2.0.0-CY4tTlrSvXA5WAM0uk0Uk1
    dlist-0.8.0.4-CrGJIvQnsM82JxkEwejrYD
abi-depends: base-4.11.1.0=a3fb1645bafaa89172454c2eea8dfdc9
             containers-0.5.11.0=94bb4831ae701bd40855b2dc2d65cf7c
             process-1.6.3.0=b58285e21ceee9f67d7be28ddb8b2627
             directory-1.3.1.5=f5fa3aef63d61d9b32ef25d211ef137f
             temporary-1.3-9oQzo4JVNP7CXkKVrv2cKm=ea3af39ce8ca8ee514ec8c391cc2de11
             fgl-5.6.0.0-IGmeQfkpQmd48thU3Ee01i=1a2555e0a79bd8ac00a7d9ff8714fb7c
             filepath-1.4.2=2408ba322304c0a06810db2d7363214a
             polyparse-1.12-AafkYPRdYin98WnFInxf9=7e5d0171fc440591b1b276b0070bb090
             bytestring-0.10.8.2=9faa89cf4769cbd12751f8644ca9e618
             colour-2.3.4-C3PVIHDZkyCIpOJGl3M0hE=a833f5ee389bbe28de815ccdd9dc961e
             mtl-2.2.2=0b3b35c3b96c7607606ed10087c4aa4a
             text-1.2.3.0=9752fd647a108be49a4cb0c2a4456f2b
             wl-pprint-text-1.2.0.0-CY4tTlrSvXA5WAM0uk0Uk1=07bd6baa6ebf161b190981e09cdc9094
             dlist-0.8.0.4-CrGJIvQnsM82JxkEwejrYD=f79b3ead594e04b4f22b6b2afc0a8656
haddock-interfaces: /usr/share/doc/haskell-graphviz/html/graphviz.haddock
haddock-html: /usr/share/doc/haskell-graphviz/html
' | '/usr/bin/ghc-pkg' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

