#!/bin/sh
export PATH='/usr/lib/distcc/bin:/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
echo 'name: hxt
version: 9.3.1.16
id: hxt-9.3.1.16-Lr69hF4oLUy8lzl1tKCl5P
key: hxt-9.3.1.16-Lr69hF4oLUy8lzl1tKCl5P
license: MIT
copyright: Copyright (c) 2005-20161 Uwe Schmidt
maintainer: Uwe Schmidt <uwe@fh-wedel.de>
author: Uwe Schmidt, Martin Schmidt, Torben Kuseler
stability: Stable
homepage: https://github.com/UweSchmidt/hxt
synopsis: A collection of tools for processing XML with Haskell.
description:
    The Haskell XML Toolbox bases on the ideas of HaXml and HXML,
    but introduces a more general approach for processing XML with Haskell.
    The Haskell XML Toolbox uses a generic data model for representing XML documents,
    including the DTD subset and the document subset, in Haskell.
    It contains a validating XML parser, a HTML parser, namespace support,
    an XPath expression evaluator, an XSLT library, a RelaxNG schema validator
    and funtions for serialization and deserialization of user defined data.
    The library makes extensive use of the arrow approach for processing XML.
    Since version 9 the toolbox is partitioned into various (sub-)packages.
    This package contains the core functionality,
    hxt-curl, hxt-tagsoup, hxt-relaxng, hxt-xpath, hxt-xslt,
    hxt-regex-xmlschema contain the extensions.
    hxt-unicode contains encoding and decoding functions,
    hxt-charproperties char properties for unicode and XML.
    .
    Changes from 9.3.1.15: Bug in quoting PI instructions in showXmlTrees fixed
    .
    Changes from 9.3.1.14: For ghc-7.10 network-uri is automatically selected
    .
    Changes from 9.3.1.13: ghc-7.10 compatibility
    .
    Changes from 9.3.1.12: Bug when unpickling an empty attribute value removed
    .
    Changes from 9.3.1.11: Bug fix in haddock comments
    .
    Changes from 9.3.1.10: Bug in DTD validation, space and time leak in delta removed
    .
    Changes from 9.3.1.9: lower bound of mtl dependency lowered to 2.0.1
    .
    Changes from 9.3.1.8: Bug in hread removed
    .
    Changes from 9.3.1.7: Foldable and Traversable instances for NTree added
    Control.Except used instead of deprecated Control.Error
    .
    Changes from 9.3.1.6: canonicalize added in hread and hreadDoc
    .
    Changes from 9.3.1.4: conditionally (no default)
    dependency from networt changed to network-uri with flag "network-uri"
    .
    Changes from 9.3.1.3: warnings from ghc-7.8.1 removed
    .
    Changes from 9.3.1.2: https as protocol added
    .
    Changes from 9.3.1.1: new parser xreadDoc
    .
    Changes from 9.3.1.0: in readString all input decoding switched off
    .
    Changes from 9.3.0.1: lower bound for network set to be >= 2.4
    .
    Changes from 9.3.0: upper bound for network set to be < 2.4
    (URI signatures changed in 2.4)
    .
    Changes from 9.2.2: XMLSchema validation integrated
    .
    Changes from 9.2.1: user defined mime type handlers added
    .
    Changes from 9.2.0: New warnings from ghc-7.4 removed
category: XML
abi: be88e93269229a8af3cc92dec8098755
exposed: True
exposed-modules:
    Control.Arrow.ArrowExc Control.Arrow.ArrowIO Control.Arrow.ArrowIf
    Control.Arrow.ArrowList Control.Arrow.ArrowNF
    Control.Arrow.ArrowNavigatableTree Control.Arrow.ArrowState
    Control.Arrow.ArrowTree Control.Arrow.IOListArrow
    Control.Arrow.IOStateListArrow Control.Arrow.ListArrow
    Control.Arrow.ListArrows Control.Arrow.NTreeEdit
    Control.Arrow.StateListArrow Control.FlatSeq Data.AssocList
    Data.Atom Data.Function.Selector Data.Tree.Class
    Data.Tree.NTree.Edit Data.Tree.NTree.TypeDefs
    Data.Tree.NTree.Zipper.TypeDefs Data.Tree.NavigatableTree.Class
    Data.Tree.NavigatableTree.XPathAxis Text.XML.HXT.Arrow.Binary
    Text.XML.HXT.Arrow.DTDProcessing Text.XML.HXT.Arrow.DocumentInput
    Text.XML.HXT.Arrow.DocumentOutput Text.XML.HXT.Arrow.Edit
    Text.XML.HXT.Arrow.GeneralEntitySubstitution
    Text.XML.HXT.Arrow.Namespace Text.XML.HXT.Arrow.ParserInterface
    Text.XML.HXT.Arrow.Pickle Text.XML.HXT.Arrow.Pickle.DTD
    Text.XML.HXT.Arrow.Pickle.Schema Text.XML.HXT.Arrow.Pickle.Xml
    Text.XML.HXT.Arrow.ProcessDocument Text.XML.HXT.Arrow.ReadDocument
    Text.XML.HXT.Arrow.WriteDocument Text.XML.HXT.Arrow.XmlArrow
    Text.XML.HXT.Arrow.XmlOptions Text.XML.HXT.Arrow.XmlRegex
    Text.XML.HXT.Arrow.XmlState
    Text.XML.HXT.Arrow.XmlState.ErrorHandling
    Text.XML.HXT.Arrow.XmlState.MimeTypeTable
    Text.XML.HXT.Arrow.XmlState.RunIOStateArrow
    Text.XML.HXT.Arrow.XmlState.SystemConfig
    Text.XML.HXT.Arrow.XmlState.TraceHandling
    Text.XML.HXT.Arrow.XmlState.TypeDefs
    Text.XML.HXT.Arrow.XmlState.URIHandling Text.XML.HXT.Core
    Text.XML.HXT.DOM.FormatXmlTree Text.XML.HXT.DOM.Interface
    Text.XML.HXT.DOM.MimeTypeDefaults Text.XML.HXT.DOM.MimeTypes
    Text.XML.HXT.DOM.QualifiedName Text.XML.HXT.DOM.ShowXml
    Text.XML.HXT.DOM.TypeDefs Text.XML.HXT.DOM.Util
    Text.XML.HXT.DOM.XmlKeywords Text.XML.HXT.DOM.XmlNode
    Text.XML.HXT.DTDValidation.AttributeValueValidation
    Text.XML.HXT.DTDValidation.DTDValidation
    Text.XML.HXT.DTDValidation.DocTransformation
    Text.XML.HXT.DTDValidation.DocValidation
    Text.XML.HXT.DTDValidation.IdValidation
    Text.XML.HXT.DTDValidation.RE Text.XML.HXT.DTDValidation.TypeDefs
    Text.XML.HXT.DTDValidation.Validation
    Text.XML.HXT.DTDValidation.XmlRE Text.XML.HXT.IO.GetFILE
    Text.XML.HXT.Parser.HtmlParsec
    Text.XML.HXT.Parser.ProtocolHandlerUtil
    Text.XML.HXT.Parser.XhtmlEntities Text.XML.HXT.Parser.XmlCharParser
    Text.XML.HXT.Parser.XmlDTDParser
    Text.XML.HXT.Parser.XmlDTDTokenParser
    Text.XML.HXT.Parser.XmlEntities Text.XML.HXT.Parser.XmlParsec
    Text.XML.HXT.Parser.XmlTokenParser Text.XML.HXT.Version
    Text.XML.HXT.XMLSchema.DataTypeLibW3CNames
import-dirs: /usr/lib/ghc-8.4.3/site-local/hxt-9.3.1.16
library-dirs: /usr/lib/ghc-8.4.3/site-local/hxt-9.3.1.16
dynamic-library-dirs: /usr/lib
data-dir: /usr/share/arm-linux-ghc-8.4.3/hxt-9.3.1.16
hs-libraries: HShxt-9.3.1.16-Lr69hF4oLUy8lzl1tKCl5P
depends:
    base-4.11.1.0 containers-0.5.11.0 directory-1.3.1.5 filepath-1.4.2
    parsec-3.1.13.0 mtl-2.2.2 deepseq-1.4.3.0 bytestring-0.10.8.2
    binary-0.8.5.1 hxt-charproperties-9.2.0.1-DFKuHAMsc8NJwk1yc4YSyO
    hxt-unicode-9.0.2.4-2JkMFY2Xvzp4PpxFbG4N53
    hxt-regex-xmlschema-9.2.0.3-IFZJv7dtYpI7USZZhsGoJV
    network-uri-2.6.1.0-AstEwZoXrlUJQq4VkxaVo9
abi-depends: base-4.11.1.0=a3fb1645bafaa89172454c2eea8dfdc9
             containers-0.5.11.0=94bb4831ae701bd40855b2dc2d65cf7c
             directory-1.3.1.5=f5fa3aef63d61d9b32ef25d211ef137f
             filepath-1.4.2=2408ba322304c0a06810db2d7363214a
             parsec-3.1.13.0=3626e7cedd22de76a8b10339d955721a
             mtl-2.2.2=0b3b35c3b96c7607606ed10087c4aa4a
             deepseq-1.4.3.0=34da2d42d10eacba0aad99c95b538637
             bytestring-0.10.8.2=9faa89cf4769cbd12751f8644ca9e618
             binary-0.8.5.1=0c28e4e382bf1405fd468e0d2a2b58e5
             hxt-charproperties-9.2.0.1-DFKuHAMsc8NJwk1yc4YSyO=44ab63d147932ce734e2efa3c8ca00f5
             hxt-unicode-9.0.2.4-2JkMFY2Xvzp4PpxFbG4N53=900535b299bab7ea8d8023308c4977d7
             hxt-regex-xmlschema-9.2.0.3-IFZJv7dtYpI7USZZhsGoJV=c2665aec1c67db9521ceb85d3f3ad156
             network-uri-2.6.1.0-AstEwZoXrlUJQq4VkxaVo9=4ea8f0efa7a1ade0af4e9ce0cffcff8c
haddock-interfaces: /usr/share/doc/haskell-hxt/html/hxt.haddock
haddock-html: /usr/share/doc/haskell-hxt/html
' | '/usr/bin/ghc-pkg' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

