/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.adapter.smarter;

import java.util.Collections;
import java.util.Hashtable;
import java.util.Map;
import java.util.Properties;
import javajs.util.AU;
import javajs.util.BS;
import javajs.util.Lst;
import javajs.util.P3;
import javajs.util.V3;
import org.jmol.adapter.smarter.Atom;
import org.jmol.adapter.smarter.AtomSetCollectionReader;
import org.jmol.adapter.smarter.AtomSetObject;
import org.jmol.adapter.smarter.Bond;
import org.jmol.adapter.smarter.SmarterJmolAdapter;
import org.jmol.adapter.smarter.Structure;
import org.jmol.adapter.smarter.XtalSymmetry;
import org.jmol.api.Interface;
import org.jmol.api.SymmetryInterface;
import org.jmol.util.BSUtil;
import org.jmol.util.Logger;

public class AtomSetCollection {
    AtomSetCollectionReader reader;
    public BS bsAtoms;
    public String fileTypeName;
    String collectionName;
    public Map<String, Object> atomSetInfo = new Hashtable<String, Object>();
    private static final String[] globalBooleans = new String[]{"someModelsHaveFractionalCoordinates", "someModelsHaveSymmetry", "someModelsHaveUnitcells", "someModelsHaveCONECT", "isPDB", "someModelsHaveDomains", "someModelsHaveValidations"};
    public static final int GLOBAL_FRACTCOORD = 0;
    public static final int GLOBAL_SYMMETRY = 1;
    public static final int GLOBAL_UNITCELLS = 2;
    public static final int GLOBAL_CONECT = 3;
    public static final int GLOBAL_ISPDB = 4;
    public static final int GLOBAL_DOMAINS = 5;
    public static final int GLOBAL_VALIDATIONS = 6;
    public Atom[] atoms = new Atom[256];
    public int ac;
    public Bond[] bonds = new Bond[256];
    public int bondCount;
    public Structure[] structures = new Structure[16];
    public int structureCount;
    public int atomSetCount;
    public int iSet = -1;
    private int[] atomSetNumbers = new int[16];
    private int[] atomSetAtomIndexes = new int[16];
    private int[] atomSetAtomCounts = new int[16];
    private int[] atomSetBondCounts = new int[16];
    private Map<String, Object>[] atomSetAuxiliaryInfo = new Hashtable[16];
    public String errorMessage;
    public boolean coordinatesAreFractional;
    boolean isTrajectory;
    private int trajectoryStepCount = 0;
    private Lst<P3[]> trajectorySteps;
    private Lst<V3[]> vibrationSteps;
    private Lst<String> trajectoryNames;
    public boolean doFixPeriodic;
    public boolean allowMultiple;
    private Lst<AtomSetCollectionReader> readerList;
    public BS bsStructuredModels;
    public boolean haveAnisou;
    public int baseSymmetryAtomCount;
    public boolean checkLatticeOnly;
    public XtalSymmetry xtalSymmetry;
    int bondIndex0;
    public boolean checkSpecial = true;
    public Map<String, Atom> atomSymbolicMap = new Hashtable<String, Atom>();
    public boolean haveUnitCell;
    public int vibScale;

    public void setCollectionName(String collectionName) {
        if (collectionName != null && (collectionName = collectionName.trim()).length() > 0) {
            this.collectionName = collectionName;
        }
    }

    public void clearGlobalBoolean(int globalIndex) {
        this.atomSetInfo.remove(globalBooleans[globalIndex]);
    }

    public void setGlobalBoolean(int globalIndex) {
        this.setInfo(globalBooleans[globalIndex], Boolean.TRUE);
    }

    boolean getGlobalBoolean(int globalIndex) {
        return this.atomSetInfo.get(globalBooleans[globalIndex]) == Boolean.TRUE;
    }

    public AtomSetCollection(String fileTypeName, AtomSetCollectionReader reader, AtomSetCollection[] array, Lst<?> list) {
        this.fileTypeName = fileTypeName;
        this.reader = reader;
        this.allowMultiple = reader == null || reader.desiredVibrationNumber < 0;
        Properties p = new Properties();
        p.put("PATH_KEY", ".PATH");
        p.put("PATH_SEPARATOR", SmarterJmolAdapter.PATH_SEPARATOR);
        this.setInfo("properties", p);
        if (array != null) {
            int n = 0;
            this.readerList = new Lst();
            for (int i = 0; i < array.length; ++i) {
                if (array[i] == null || array[i].ac <= 0 && (array[i].reader == null || !array[i].reader.mustFinalizeModelSet)) continue;
                this.appendAtomSetCollection(n++, array[i]);
            }
            if (n > 1) {
                this.setInfo("isMultiFile", Boolean.TRUE);
            }
        } else if (list != null) {
            this.setInfo("isMultiFile", Boolean.TRUE);
            this.appendAtomSetCollectionList(list);
        }
    }

    private void appendAtomSetCollectionList(Lst<?> list) {
        int n = list.size();
        if (n == 0) {
            this.errorMessage = "No file found!";
            return;
        }
        for (int i = 0; i < n; ++i) {
            Object o = list.get(i);
            if (o instanceof Lst) {
                this.appendAtomSetCollectionList((Lst)o);
                continue;
            }
            this.appendAtomSetCollection(i, (AtomSetCollection)o);
        }
    }

    public void setTrajectory() {
        int i;
        int n;
        if (!this.isTrajectory) {
            this.trajectorySteps = new Lst();
        }
        this.isTrajectory = true;
        int n2 = n = this.bsAtoms == null ? this.ac : this.bsAtoms.cardinality();
        if (n == 0) {
            return;
        }
        P3[] trajectoryStep = new P3[n];
        boolean haveVibrations = n > 0 && this.atoms[0].vib != null && !Float.isNaN(this.atoms[0].vib.z);
        V3[] vibrationStep = haveVibrations ? new V3[n] : null;
        P3[] prevSteps = this.trajectoryStepCount == 0 ? null : (P3[])this.trajectorySteps.get(this.trajectoryStepCount - 1);
        int ii = 0;
        for (i = 0; i < this.ac; ++i) {
            if (this.bsAtoms != null && !this.bsAtoms.get(i)) continue;
            P3 pt = P3.newP(this.atoms[i]);
            if (this.doFixPeriodic && prevSteps != null) {
                pt = AtomSetCollection.fixPeriodic(pt, prevSteps[i]);
            }
            trajectoryStep[ii] = pt;
            if (haveVibrations) {
                vibrationStep[ii] = this.atoms[i].vib;
            }
            ++ii;
        }
        if (haveVibrations) {
            if (this.vibrationSteps == null) {
                this.vibrationSteps = new Lst();
                for (i = 0; i < this.trajectoryStepCount; ++i) {
                    this.vibrationSteps.addLast(null);
                }
            }
            this.vibrationSteps.addLast(vibrationStep);
        }
        this.trajectorySteps.addLast(trajectoryStep);
        ++this.trajectoryStepCount;
    }

    public void appendAtomSetCollection(int collectionIndex, AtomSetCollection collection) {
        if (collection.reader != null && collection.reader.mustFinalizeModelSet) {
            this.readerList.addLast(collection.reader);
        }
        int existingAtomsCount = this.ac;
        this.setInfo("loadState", collection.atomSetInfo.get("loadState"));
        if (collection.bsAtoms != null) {
            if (this.bsAtoms == null) {
                this.bsAtoms = new BS();
            }
            int i = collection.bsAtoms.nextSetBit(0);
            while (i >= 0) {
                this.bsAtoms.set(existingAtomsCount + i);
                i = collection.bsAtoms.nextSetBit(i + 1);
            }
        }
        int clonedAtoms = 0;
        int atomSetCount0 = this.atomSetCount;
        for (int atomSetNum = 0; atomSetNum < collection.atomSetCount; ++atomSetNum) {
            this.newAtomSet();
            Map<String, Object> info = this.atomSetAuxiliaryInfo[this.iSet] = collection.atomSetAuxiliaryInfo[atomSetNum];
            int[] atomInfo = (int[])info.get("PDB_CONECT_firstAtom_count_max");
            if (atomInfo != null) {
                atomInfo[0] = atomInfo[0] + existingAtomsCount;
            }
            this.setCurrentModelInfo("title", collection.collectionName);
            this.setAtomSetName(collection.getAtomSetName(atomSetNum));
            for (int atomNum = 0; atomNum < collection.atomSetAtomCounts[atomSetNum]; ++atomNum) {
                try {
                    if (this.bsAtoms != null) {
                        this.bsAtoms.set(this.ac);
                    }
                    this.newCloneAtom(collection.atoms[clonedAtoms]);
                }
                catch (Exception e) {
                    this.errorMessage = "appendAtomCollection error: " + e;
                }
                ++clonedAtoms;
            }
            this.atomSetNumbers[this.iSet] = collectionIndex < 0 ? this.iSet + 1 : (collectionIndex + 1) * 1000000 + collection.atomSetNumbers[atomSetNum];
        }
        for (int bondNum = 0; bondNum < collection.bondCount; ++bondNum) {
            Bond bond = collection.bonds[bondNum];
            this.addNewBondWithOrder(bond.atomIndex1 + existingAtomsCount, bond.atomIndex2 + existingAtomsCount, bond.order);
        }
        int i = globalBooleans.length;
        while (--i >= 0) {
            if (!collection.getGlobalBoolean(i)) continue;
            this.setGlobalBoolean(i);
        }
        for (i = 0; i < collection.structureCount; ++i) {
            Structure s = collection.structures[i];
            this.addStructure(s);
            s.modelStartEnd[0] = s.modelStartEnd[0] + atomSetCount0;
            s.modelStartEnd[1] = s.modelStartEnd[1] + atomSetCount0;
        }
    }

    public void setNoAutoBond() {
        this.setInfo("noAutoBond", Boolean.TRUE);
    }

    void freeze(boolean reverseModels) {
        if (this.atomSetCount == 1 && this.collectionName == null) {
            this.collectionName = (String)this.getAtomSetAuxiliaryInfoValue(0, "name");
        }
        if (reverseModels) {
            this.reverseAtomSets();
        }
        if (this.trajectoryStepCount > 1) {
            this.finalizeTrajectory();
        }
        this.getList(true);
        this.getList(false);
        for (int i = 0; i < this.atomSetCount; ++i) {
            this.setModelInfoForSet("initialAtomCount", this.atomSetAtomCounts[i], i);
            this.setModelInfoForSet("initialBondCount", this.atomSetBondCounts[i], i);
        }
    }

    private void reverseAtomSets() {
        int i;
        int i2;
        this.reverseArray(this.atomSetAtomIndexes);
        this.reverseArray(this.atomSetNumbers);
        this.reverseArray(this.atomSetAtomCounts);
        this.reverseArray(this.atomSetBondCounts);
        AtomSetCollection.reverseList(this.trajectorySteps);
        AtomSetCollection.reverseList(this.trajectoryNames);
        AtomSetCollection.reverseList(this.vibrationSteps);
        this.reverseObject(this.atomSetAuxiliaryInfo);
        for (i2 = 0; i2 < this.ac; ++i2) {
            this.atoms[i2].atomSetIndex = this.atomSetCount - 1 - this.atoms[i2].atomSetIndex;
        }
        for (i2 = 0; i2 < this.structureCount; ++i2) {
            int m = this.structures[i2].modelStartEnd[0];
            if (m < 0) continue;
            this.structures[i2].modelStartEnd[0] = this.atomSetCount - 1 - this.structures[i2].modelStartEnd[1];
            this.structures[i2].modelStartEnd[1] = this.atomSetCount - 1 - m;
        }
        for (i2 = 0; i2 < this.bondCount; ++i2) {
            this.bonds[i2].atomSetIndex = this.atomSetCount - 1 - this.atoms[this.bonds[i2].atomIndex1].atomSetIndex;
        }
        this.reverseSets(this.bonds, this.bondCount);
        Lst<type>[] lists = AU.createArrayOfArrayList(this.atomSetCount);
        for (i = 0; i < this.atomSetCount; ++i) {
            lists[i] = new Lst();
        }
        for (i = 0; i < this.ac; ++i) {
            lists[this.atoms[i].atomSetIndex].addLast(this.atoms[i]);
        }
        int[] newIndex = new int[this.ac];
        int n = this.ac;
        int i3 = this.atomSetCount;
        while (--i3 >= 0) {
            int j = lists[i3].size();
            while (--j >= 0) {
                Atom a = this.atoms[--n] = (Atom)lists[i3].get(j);
                newIndex[a.index] = n;
                a.index = n;
            }
        }
        for (i3 = 0; i3 < this.bondCount; ++i3) {
            this.bonds[i3].atomIndex1 = newIndex[this.bonds[i3].atomIndex1];
            this.bonds[i3].atomIndex2 = newIndex[this.bonds[i3].atomIndex2];
        }
        for (i3 = 0; i3 < this.atomSetCount; ++i3) {
            int[] conect = (int[])this.getAtomSetAuxiliaryInfoValue(i3, "PDB_CONECT_firstAtom_count_max");
            if (conect == null) continue;
            conect[0] = newIndex[conect[0]];
            conect[1] = this.atomSetAtomCounts[i3];
        }
    }

    private void reverseSets(AtomSetObject[] o, int n) {
        int i;
        Lst<type>[] lists = AU.createArrayOfArrayList(this.atomSetCount);
        for (i = 0; i < this.atomSetCount; ++i) {
            lists[i] = new Lst();
        }
        for (i = 0; i < n; ++i) {
            int index = o[i].atomSetIndex;
            if (index < 0) {
                return;
            }
            lists[o[i].atomSetIndex].addLast(o[i]);
        }
        i = this.atomSetCount;
        while (--i >= 0) {
            int j = lists[i].size();
            while (--j >= 0) {
                o[--n] = (AtomSetObject)lists[i].get(j);
            }
        }
    }

    private void reverseObject(Object[] o) {
        int n = this.atomSetCount;
        int i = n / 2;
        while (--i >= 0) {
            AU.swap(o, i, n - 1 - i);
        }
    }

    private static void reverseList(Lst<?> list) {
        if (list == null) {
            return;
        }
        Collections.reverse(list);
    }

    private void reverseArray(int[] a) {
        int n = this.atomSetCount;
        int i = n / 2;
        while (--i >= 0) {
            AU.swapInt(a, i, n - 1 - i);
        }
    }

    private void getList(boolean isAltLoc) {
        int i = this.ac;
        while (--i >= 0 && (this.atoms[i] == null || (isAltLoc ? this.atoms[i].altLoc : this.atoms[i].insertionCode) == '\u0000')) {
        }
        if (i < 0) {
            return;
        }
        String[] lists = new String[this.atomSetCount];
        for (i = 0; i < this.atomSetCount; ++i) {
            lists[i] = "";
        }
        for (i = 0; i < this.ac; ++i) {
            int pt;
            char id;
            if (this.atoms[i] == null) continue;
            char c = id = isAltLoc ? this.atoms[i].altLoc : this.atoms[i].insertionCode;
            if (id == '\u0000' || lists[pt = this.atoms[i].atomSetIndex].indexOf(id) >= 0) continue;
            int n = pt;
            lists[n] = lists[n] + id;
        }
        String type = isAltLoc ? "altLocs" : "insertionCodes";
        for (i = 0; i < this.atomSetCount; ++i) {
            if (lists[i].length() <= 0) continue;
            this.setModelInfoForSet(type, lists[i], i);
        }
    }

    void finish() {
        if (this.reader != null) {
            this.reader.finalizeModelSet();
        } else if (this.readerList != null) {
            for (int i = 0; i < this.readerList.size(); ++i) {
                ((AtomSetCollectionReader)this.readerList.get(i)).finalizeModelSet();
            }
        }
        this.atoms = null;
        this.atomSetAtomCounts = new int[16];
        this.atomSetAuxiliaryInfo = new Hashtable[16];
        this.atomSetInfo = new Hashtable<String, Object>();
        this.atomSetCount = 0;
        this.atomSetNumbers = new int[16];
        this.atomSymbolicMap = new Hashtable<String, Atom>();
        this.bonds = null;
        this.iSet = -1;
        this.readerList = null;
        this.xtalSymmetry = null;
        this.structures = new Structure[16];
        this.structureCount = 0;
        this.trajectorySteps = null;
        this.vibrationSteps = null;
    }

    public void discardPreviousAtoms() {
        int i = this.ac;
        while (--i >= 0) {
            this.atoms[i] = null;
        }
        this.ac = 0;
        this.atomSymbolicMap.clear();
        this.atomSetCount = 0;
        this.iSet = -1;
        i = this.atomSetAuxiliaryInfo.length;
        while (--i >= 0) {
            this.atomSetAtomCounts[i] = 0;
            this.atomSetBondCounts[i] = 0;
            this.atomSetAuxiliaryInfo[i] = null;
        }
    }

    public void removeCurrentAtomSet() {
        if (this.iSet < 0) {
            return;
        }
        int ai = this.atomSetAtomIndexes[this.iSet];
        if (this.bsAtoms != null) {
            this.bsAtoms.clearBits(ai, this.ac);
        }
        this.ac = ai;
        this.atomSetAtomCounts[this.iSet] = 0;
        --this.iSet;
        --this.atomSetCount;
        this.reader.doCheckUnitCell = false;
    }

    public int getHydrogenAtomCount() {
        int n = 0;
        for (int i = 0; i < this.ac; ++i) {
            if (this.atoms[i].elementNumber != 1 && !this.atoms[i].elementSymbol.equals("H")) continue;
            ++n;
        }
        return n;
    }

    public Atom newCloneAtom(Atom atom) throws Exception {
        Atom clone = atom.getClone();
        this.addAtom(clone);
        return clone;
    }

    public int cloneFirstAtomSet(int atomCount) throws Exception {
        if (!this.allowMultiple) {
            return 0;
        }
        this.newAtomSet();
        if (atomCount == 0) {
            atomCount = this.atomSetAtomCounts[0];
        }
        for (int i = 0; i < atomCount; ++i) {
            this.newCloneAtom(this.atoms[i]);
        }
        return this.ac;
    }

    public void cloneAtomSetWithBonds(boolean isLast) throws Exception {
        int atomIncrement;
        int nBonds = this.atomSetBondCounts[isLast ? this.iSet : 0];
        int n = atomIncrement = isLast ? this.cloneLastAtomSet() : this.cloneFirstAtomSet(0);
        if (atomIncrement > 0) {
            for (int i = 0; i < nBonds; ++i) {
                Bond bond = this.bonds[this.bondCount - nBonds];
                this.addNewBondWithOrder(bond.atomIndex1 + atomIncrement, bond.atomIndex2 + atomIncrement, bond.order);
            }
        }
    }

    public int cloneLastAtomSet() throws Exception {
        return this.cloneLastAtomSetFromPoints(0, null);
    }

    public int cloneLastAtomSetFromPoints(int ac, P3[] pts) throws Exception {
        if (!this.allowMultiple) {
            return 0;
        }
        int count = ac > 0 ? ac : this.getLastAtomSetAtomCount();
        int atomIndex = this.getLastAtomSetAtomIndex();
        this.newAtomSet();
        for (int i = 0; i < count; ++i) {
            Atom atom = this.newCloneAtom(this.atoms[atomIndex++]);
            if (pts == null) continue;
            atom.setT(pts[i]);
        }
        return count;
    }

    public int getLastAtomSetAtomCount() {
        return this.atomSetAtomCounts[this.iSet];
    }

    public int getLastAtomSetAtomIndex() {
        if (this.ac < this.atomSetAtomCounts[this.iSet]) {
            System.out.println("???");
        }
        return this.ac - this.atomSetAtomCounts[this.iSet];
    }

    public Atom addNewAtom() {
        return this.addAtom(new Atom());
    }

    public Atom addAtom(Atom atom) {
        if (this.ac == this.atoms.length) {
            this.atoms = this.ac > 200000 ? (Atom[])AU.ensureLength(this.atoms, this.ac + 50000) : (Atom[])AU.doubleLength(this.atoms);
        }
        if (this.atomSetCount == 0) {
            this.newAtomSet();
        }
        atom.index = this.ac;
        this.atoms[this.ac++] = atom;
        atom.atomSetIndex = this.iSet;
        int n = this.iSet;
        int n2 = this.atomSetAtomCounts[n];
        this.atomSetAtomCounts[n] = n2 + 1;
        atom.atomSite = n2;
        return atom;
    }

    public void addAtomWithMappedName(Atom atom) {
        String atomName = this.addAtom((Atom)atom).atomName;
        if (atomName != null) {
            this.atomSymbolicMap.put(atomName, atom);
        }
    }

    public void addAtomWithMappedSerialNumber(Atom atom) {
        int atomSerial = this.addAtom((Atom)atom).atomSerial;
        if (atomSerial != Integer.MIN_VALUE) {
            this.atomSymbolicMap.put("" + atomSerial, atom);
        }
    }

    public Atom getAtomFromName(String atomName) {
        return this.atomSymbolicMap.get(atomName);
    }

    public int getAtomIndex(String name) {
        Atom a = this.atomSymbolicMap.get(name);
        return a == null ? -1 : a.index;
    }

    public void addNewBondWithOrder(int atomIndex1, int atomIndex2, int order) {
        if (atomIndex1 >= 0 && atomIndex1 < this.ac && atomIndex2 >= 0 && atomIndex2 < this.ac && atomIndex1 != atomIndex2) {
            this.addBond(new Bond(atomIndex1, atomIndex2, order));
        }
    }

    public void addNewBondFromNames(String atomName1, String atomName2, int order) {
        this.addNewBondWithOrderA(this.getAtomFromName(atomName1), this.getAtomFromName(atomName2), order);
    }

    public void addNewBondWithOrderA(Atom atom1, Atom atom2, int order) {
        if (atom1 != null && atom2 != null) {
            this.addNewBondWithOrder(atom1.index, atom2.index, order);
        }
    }

    public void addBond(Bond bond) {
        if (this.trajectoryStepCount > 0) {
            return;
        }
        if (bond.atomIndex1 < 0 || bond.atomIndex2 < 0 || bond.order < 0 || bond.atomIndex1 == bond.atomIndex2 || this.atoms[bond.atomIndex1].atomSetIndex != this.atoms[bond.atomIndex2].atomSetIndex) {
            if (Logger.debugging) {
                Logger.debug(">>>>>>BAD BOND:" + bond.atomIndex1 + "-" + bond.atomIndex2 + " order=" + bond.order);
            }
            return;
        }
        if (this.bondCount == this.bonds.length) {
            this.bonds = (Bond[])AU.arrayCopyObject(this.bonds, this.bondCount + 1024);
        }
        this.bonds[this.bondCount++] = bond;
        int n = this.iSet;
        this.atomSetBondCounts[n] = this.atomSetBondCounts[n] + 1;
    }

    public void finalizeStructures() {
        Structure s;
        int i;
        if (this.structureCount == 0) {
            return;
        }
        this.bsStructuredModels = new BS();
        Hashtable<String, Integer> map = new Hashtable<String, Integer>();
        for (i = 0; i < this.structureCount; ++i) {
            s = this.structures[i];
            if (s.modelStartEnd[0] == -1) {
                s.modelStartEnd[0] = 0;
                s.modelStartEnd[1] = this.atomSetCount - 1;
            }
            this.bsStructuredModels.setBits(s.modelStartEnd[0], s.modelStartEnd[1] + 1);
            if (s.strandCount == 0) continue;
            String key = s.structureID + " " + s.modelStartEnd[0];
            Integer v = (Integer)map.get(key);
            int count = (v == null ? 0 : v) + 1;
            map.put(key, count);
        }
        for (i = 0; i < this.structureCount; ++i) {
            s = this.structures[i];
            if (s.strandCount != 1) continue;
            s.strandCount = (Integer)map.get(s.structureID + " " + s.modelStartEnd[0]);
        }
    }

    public void addStructure(Structure structure) {
        if (this.structureCount == this.structures.length) {
            this.structures = (Structure[])AU.arrayCopyObject(this.structures, this.structureCount + 32);
        }
        this.structures[this.structureCount++] = structure;
    }

    public void addVibrationVectorWithSymmetry(int iatom, float vx, float vy, float vz, boolean withSymmetry) {
        if (!withSymmetry) {
            this.addVibrationVector(iatom, vx, vy, vz);
            return;
        }
        int atomSite = this.atoms[iatom].atomSite;
        int atomSetIndex = this.atoms[iatom].atomSetIndex;
        for (int i = iatom; i < this.ac && this.atoms[i].atomSetIndex == atomSetIndex; ++i) {
            if (this.atoms[i].atomSite != atomSite) continue;
            this.addVibrationVector(i, vx, vy, vz);
        }
    }

    public V3 addVibrationVector(int iatom, float x, float y, float z) {
        if (!this.allowMultiple) {
            iatom %= this.ac;
        }
        this.atoms[iatom].vib = V3.new3(x, y, z);
        return this.atoms[iatom].vib;
    }

    public void setCoordinatesAreFractional(boolean tf) {
        this.coordinatesAreFractional = tf;
        this.setCurrentModelInfo("coordinatesAreFractional", tf);
        if (tf) {
            this.setGlobalBoolean(0);
        }
    }

    public void setAnisoBorU(Atom atom, float[] data, int type) {
        this.haveAnisou = true;
        atom.anisoBorU = data;
        data[6] = type;
    }

    public void setU(Atom atom, int i, float val) {
        float[] data = atom.anisoBorU;
        if (data == null) {
            data = new float[8];
            this.setAnisoBorU(atom, data, 8);
        }
        data[i] = val;
    }

    public XtalSymmetry getXSymmetry() {
        if (this.xtalSymmetry == null) {
            this.xtalSymmetry = ((XtalSymmetry)Interface.getOption("adapter.smarter.XtalSymmetry", this.reader.vwr, "file")).set(this.reader);
        }
        return this.xtalSymmetry;
    }

    public SymmetryInterface getSymmetry() {
        return this.getXSymmetry().getSymmetry();
    }

    public SymmetryInterface setSymmetry(SymmetryInterface symmetry) {
        return symmetry == null ? null : this.getXSymmetry().setSymmetry(symmetry);
    }

    public void setTensors() {
        if (this.haveAnisou) {
            this.getXSymmetry().setTensors();
        }
    }

    public void setInfo(String key, Object value) {
        if (value == null) {
            this.atomSetInfo.remove(key);
        } else {
            this.atomSetInfo.put(key, value);
        }
    }

    public boolean setAtomSetCollectionPartialCharges(String auxKey) {
        if (!this.atomSetInfo.containsKey(auxKey)) {
            return false;
        }
        Lst atomData = (Lst)this.atomSetInfo.get(auxKey);
        int n = atomData.size();
        int i = this.ac;
        while (--i >= 0) {
            this.atoms[i].partialCharge = ((Float)atomData.get(i % n)).floatValue();
        }
        Logger.info("Setting partial charges type " + auxKey);
        return true;
    }

    public void mapPartialCharge(String atomName, float charge) {
        this.getAtomFromName((String)atomName).partialCharge = charge;
    }

    private static P3 fixPeriodic(P3 pt, P3 pt0) {
        pt.x = AtomSetCollection.fixPoint(pt.x, pt0.x);
        pt.y = AtomSetCollection.fixPoint(pt.y, pt0.y);
        pt.z = AtomSetCollection.fixPoint(pt.z, pt0.z);
        return pt;
    }

    private static float fixPoint(float x, float x0) {
        while ((double)(x - x0) > 0.9) {
            x -= 1.0f;
        }
        while ((double)(x - x0) < -0.9) {
            x += 1.0f;
        }
        return x;
    }

    public void finalizeTrajectoryAs(Lst<P3[]> trajectorySteps, Lst<V3[]> vibrationSteps) {
        this.trajectorySteps = trajectorySteps;
        this.vibrationSteps = vibrationSteps;
        this.trajectoryStepCount = trajectorySteps.size();
        this.finalizeTrajectory();
    }

    private void finalizeTrajectory() {
        int n;
        if (this.trajectoryStepCount == 0) {
            return;
        }
        P3[] trajectory = (P3[])this.trajectorySteps.get(0);
        V3[] vibrations = this.vibrationSteps == null ? null : (V3[])this.vibrationSteps.get(0);
        int n2 = n = this.bsAtoms == null ? this.ac : this.bsAtoms.cardinality();
        if (this.vibrationSteps != null && vibrations != null && vibrations.length < n || trajectory.length < n) {
            this.errorMessage = "File cannot be loaded as a trajectory";
            return;
        }
        V3 v = new V3();
        int ii = 0;
        for (int i = 0; i < this.ac; ++i) {
            if (this.bsAtoms != null && !this.bsAtoms.get(i)) continue;
            if (this.vibrationSteps != null) {
                V3 v3 = this.atoms[i].vib = vibrations == null ? v : vibrations[ii];
            }
            if (trajectory[ii] != null) {
                this.atoms[i].setT(trajectory[ii]);
            }
            ++ii;
        }
        this.setInfo("trajectorySteps", this.trajectorySteps);
        if (this.vibrationSteps != null) {
            this.setInfo("vibrationSteps", this.vibrationSteps);
        }
    }

    public void newAtomSet() {
        this.newAtomSetClear(true);
    }

    public void newAtomSetClear(boolean doClearMap) {
        if (!this.allowMultiple && this.iSet >= 0) {
            this.reader.discardPreviousAtoms();
        }
        this.bondIndex0 = this.bondCount;
        if (this.isTrajectory) {
            this.reader.discardPreviousAtoms();
        }
        this.iSet = this.atomSetCount++;
        if (this.atomSetCount > this.atomSetNumbers.length) {
            this.atomSetAtomIndexes = AU.doubleLengthI(this.atomSetAtomIndexes);
            this.atomSetAtomCounts = AU.doubleLengthI(this.atomSetAtomCounts);
            this.atomSetBondCounts = AU.doubleLengthI(this.atomSetBondCounts);
            this.atomSetAuxiliaryInfo = (Map[])AU.doubleLength(this.atomSetAuxiliaryInfo);
        }
        this.atomSetAtomIndexes[this.iSet] = this.ac;
        if (this.atomSetCount + this.trajectoryStepCount > this.atomSetNumbers.length) {
            this.atomSetNumbers = AU.doubleLengthI(this.atomSetNumbers);
        }
        if (this.isTrajectory) {
            this.atomSetNumbers[this.iSet + this.trajectoryStepCount] = this.atomSetCount + this.trajectoryStepCount;
        } else {
            this.atomSetNumbers[this.iSet] = this.atomSetCount;
        }
        if (doClearMap) {
            this.atomSymbolicMap.clear();
        }
        this.setCurrentModelInfo("title", this.collectionName);
    }

    public int getAtomSetAtomIndex(int i) {
        if (i < 0) {
            System.out.println("??");
        }
        return this.atomSetAtomIndexes[i];
    }

    public int getAtomSetAtomCount(int i) {
        return this.atomSetAtomCounts[i];
    }

    public int getAtomSetBondCount(int i) {
        return this.atomSetBondCounts[i];
    }

    public void setAtomSetName(String atomSetName) {
        if (atomSetName == null) {
            return;
        }
        if (this.isTrajectory) {
            this.setTrajectoryName(atomSetName);
            return;
        }
        String name0 = this.iSet < 0 ? null : this.getAtomSetName(this.iSet);
        this.setModelInfoForSet("name", atomSetName, this.iSet);
        if (this.reader != null && atomSetName.length() > 0 && !atomSetName.equals(name0)) {
            this.reader.appendLoadNote(atomSetName);
        }
        if (!this.allowMultiple) {
            this.setCollectionName(atomSetName);
        }
    }

    private void setTrajectoryName(String name) {
        if (this.trajectoryStepCount == 0) {
            return;
        }
        if (this.trajectoryNames == null) {
            this.trajectoryNames = new Lst();
        }
        for (int i = this.trajectoryNames.size(); i < this.trajectoryStepCount; ++i) {
            this.trajectoryNames.addLast(null);
        }
        this.trajectoryNames.set(this.trajectoryStepCount - 1, name);
    }

    public void setCurrentAtomSetNumber(int atomSetNumber) {
        this.setAtomSetNumber(this.iSet + (this.isTrajectory ? this.trajectoryStepCount : 0), atomSetNumber);
    }

    public void setAtomSetNumber(int index, int atomSetNumber) {
        this.atomSetNumbers[index] = atomSetNumber;
    }

    public void setAtomSetModelProperty(String key, String value) {
        this.setAtomSetModelPropertyForSet(key, value, this.iSet);
    }

    public void setAtomSetModelPropertyForSet(String key, String value, int atomSetIndex) {
        Properties p = (Properties)this.getAtomSetAuxiliaryInfoValue(atomSetIndex, "modelProperties");
        if (p == null) {
            p = new Properties();
            this.setModelInfoForSet("modelProperties", p, atomSetIndex);
        }
        p.put(key, value);
        if (key.startsWith(".")) {
            p.put(key.substring(1), value);
        }
    }

    public void setAtomProperties(String key, Object data, int atomSetIndex, boolean isGroup) {
        Hashtable<String, Object> p;
        if (data instanceof String && !((String)data).endsWith("\n")) {
            data = data + "\n";
        }
        if (atomSetIndex < 0) {
            atomSetIndex = this.iSet;
        }
        if ((p = (Hashtable<String, Object>)this.getAtomSetAuxiliaryInfoValue(atomSetIndex, "atomProperties")) == null) {
            p = new Hashtable<String, Object>();
            this.setModelInfoForSet("atomProperties", p, atomSetIndex);
        }
        p.put(key, data);
    }

    boolean setAtomSetPartialCharges(String auxKey) {
        if (!this.atomSetAuxiliaryInfo[this.iSet].containsKey(auxKey)) {
            return false;
        }
        Lst atomData = (Lst)this.getAtomSetAuxiliaryInfoValue(this.iSet, auxKey);
        int i = atomData.size();
        while (--i >= 0) {
            this.atoms[i].partialCharge = ((Float)atomData.get(i)).floatValue();
        }
        return true;
    }

    public Object getAtomSetAuxiliaryInfoValue(int index, String key) {
        return this.atomSetAuxiliaryInfo[index >= 0 ? index : this.iSet].get(key);
    }

    public void setCurrentModelInfo(String key, Object value) {
        this.setModelInfoForSet(key, value, this.iSet);
    }

    public void setModelInfoForSet(String key, Object value, int atomSetIndex) {
        if (atomSetIndex < 0) {
            return;
        }
        if (this.atomSetAuxiliaryInfo[atomSetIndex] == null) {
            this.atomSetAuxiliaryInfo[atomSetIndex] = new Hashtable<String, Object>();
        }
        if (value == null) {
            this.atomSetAuxiliaryInfo[atomSetIndex].remove(key);
        } else {
            this.atomSetAuxiliaryInfo[atomSetIndex].put(key, value);
        }
    }

    int getAtomSetNumber(int atomSetIndex) {
        return this.atomSetNumbers[atomSetIndex >= this.atomSetCount ? 0 : atomSetIndex];
    }

    String getAtomSetName(int atomSetIndex) {
        if (this.trajectoryNames != null && atomSetIndex < this.trajectoryNames.size()) {
            return (String)this.trajectoryNames.get(atomSetIndex);
        }
        if (atomSetIndex >= this.atomSetCount) {
            atomSetIndex = this.atomSetCount - 1;
        }
        return (String)this.getAtomSetAuxiliaryInfoValue(atomSetIndex, "name");
    }

    public Map<String, Object> getAtomSetAuxiliaryInfo(int atomSetIndex) {
        int i = atomSetIndex >= this.atomSetCount ? this.atomSetCount - 1 : atomSetIndex;
        return i < 0 ? null : this.atomSetAuxiliaryInfo[i];
    }

    public void setAtomSetEnergy(String energyString, float value) {
        if (this.iSet < 0) {
            return;
        }
        Logger.info("Energy for model " + (this.iSet + 1) + " = " + energyString);
        this.setCurrentModelInfo("EnergyString", energyString);
        this.setCurrentModelInfo("Energy", Float.valueOf(value));
        this.setAtomSetModelProperty("Energy", "" + value);
    }

    public String setAtomSetFrequency(int mode, String pathKey, String label, String freq, String units) {
        this.setAtomSetModelProperty("FreqValue", freq);
        freq = freq + " " + (units == null ? "cm^-1" : units);
        String name = (label == null ? "" : label + " ") + freq;
        this.setAtomSetName(name);
        this.setAtomSetModelProperty("Frequency", freq);
        this.setAtomSetModelProperty("Mode", "" + mode);
        this.setModelInfoForSet("vibrationalMode", mode, this.iSet);
        if (label != null) {
            this.setAtomSetModelProperty("FrequencyLabel", label);
        }
        this.setAtomSetModelProperty(".PATH", (pathKey == null ? "" : pathKey + SmarterJmolAdapter.PATH_SEPARATOR + "Frequencies") + "Frequencies");
        return name;
    }

    public String[][] getBondList() {
        String[][] info = new String[this.bondCount][];
        for (int i = 0; i < this.bondCount; ++i) {
            info[i] = new String[]{this.atoms[this.bonds[i].atomIndex1].atomName, this.atoms[this.bonds[i].atomIndex2].atomName, "" + this.bonds[i].order};
        }
        return info;
    }

    public void centralize() {
        P3 pt = new P3();
        for (int i = 0; i < this.atomSetCount; ++i) {
            int n = this.atomSetAtomCounts[i];
            int atom0 = this.atomSetAtomIndexes[i];
            pt.set(0.0f, 0.0f, 0.0f);
            int j = atom0 + n;
            while (--j >= atom0) {
                pt.add(this.atoms[j]);
            }
            pt.scale(1.0f / (float)n);
            j = atom0 + n;
            while (--j >= atom0) {
                this.atoms[j].sub(pt);
            }
        }
    }

    void mergeTrajectories(AtomSetCollection a) {
        if (!this.isTrajectory || !a.isTrajectory || this.vibrationSteps != null) {
            return;
        }
        for (int i = 0; i < a.trajectoryStepCount; ++i) {
            this.trajectorySteps.add(this.trajectoryStepCount++, a.trajectorySteps.get(i));
        }
        this.setInfo("trajectorySteps", this.trajectorySteps);
        this.setInfo("ignoreUnitCell", a.atomSetInfo.get("ignoreUnitCell"));
    }

    public void removeAtomSet(int imodel) {
        int i;
        if (this.bsAtoms == null) {
            this.bsAtoms = BSUtil.newBitSet2(0, this.ac);
        }
        int i0 = this.atomSetAtomIndexes[imodel];
        int nAtoms = this.atomSetAtomCounts[imodel];
        int i1 = i0 + nAtoms;
        this.bsAtoms.clearBits(i0, i1);
        for (i = i1; i < this.ac; ++i) {
            --this.atoms[i].atomSetIndex;
        }
        for (i = imodel + 1; i < this.atomSetCount; ++i) {
            this.atomSetAuxiliaryInfo[i - 1] = this.atomSetAuxiliaryInfo[i];
            this.atomSetAtomIndexes[i - 1] = this.atomSetAtomIndexes[i];
            this.atomSetBondCounts[i - 1] = this.atomSetBondCounts[i];
            this.atomSetAtomCounts[i - 1] = this.atomSetAtomCounts[i];
            this.atomSetNumbers[i - 1] = this.atomSetNumbers[i];
        }
        for (i = 0; i < this.bondCount; ++i) {
            this.bonds[i].atomSetIndex = this.atoms[this.bonds[i].atomIndex1].atomSetIndex;
        }
        this.atomSetAuxiliaryInfo[--this.atomSetCount] = null;
        int n = 0;
        for (int i2 = 0; i2 < this.structureCount; ++i2) {
            Structure s = this.structures[i2];
            if (s.modelStartEnd[0] != imodel || s.modelStartEnd[1] != imodel) continue;
            this.structures[i2] = null;
            ++n;
        }
        if (n > 0) {
            Structure[] ss = new Structure[this.structureCount - n];
            int pt = 0;
            for (int i3 = 0; i3 < this.structureCount; ++i3) {
                if (this.structures[i3] == null) continue;
                ss[pt++] = this.structures[i3];
            }
            this.structures = ss;
        }
    }

    public void removeLastUnselectedAtoms() {
        int n = this.ac;
        int nremoved = 0;
        int i0 = this.getLastAtomSetAtomIndex();
        int nnow = 0;
        for (int i = i0; i < n; ++i) {
            if (!this.bsAtoms.get(i)) {
                ++nremoved;
                --this.ac;
                this.atoms[i] = null;
                continue;
            }
            if (nremoved > 0) {
                this.atoms[i].index = i - nremoved;
                this.atoms[this.atoms[i].index] = this.atoms[i];
                this.atoms[i] = null;
            }
            ++nnow;
        }
        this.atomSetAtomCounts[this.iSet] = nnow;
        if (nnow == 0) {
            --this.iSet;
            --this.atomSetCount;
        } else {
            this.bsAtoms.setBits(i0, i0 + nnow);
        }
    }
}

