/*
 * Decompiled with CFR 0.152.
 */
package org.zaproxy.zap.extension.autoupdate;

import java.io.File;
import java.security.InvalidParameterException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.apache.commons.configuration.ConfigurationException;
import org.apache.commons.configuration.ConversionException;
import org.apache.log4j.Logger;
import org.parosproxy.paros.Constant;
import org.parosproxy.paros.common.AbstractParam;
import org.zaproxy.zap.extension.api.ZapApiIgnore;

public class OptionsParamCheckForUpdates
extends AbstractParam {
    public static final String CHECK_ON_START = "start.checkForUpdates";
    public static final String DAY_LAST_CHECKED = "start.dayLastChecked";
    public static final String DAY_LAST_INSTALL_WARNED = "start.dayLastInstallWarned";
    public static final String DAY_LAST_UPDATE_WARNED = "start.dayLastUpdateWarned";
    public static final String DOWNLOAD_NEW_RELEASE = "start.downloadNewRelease";
    public static final String CHECK_ADDON_UPDATES = "start.checkAddonUpdates";
    public static final String INSTALL_ADDON_UPDATES = "start.installAddonUpdates";
    public static final String INSTALL_SCANNER_RULES = "start.installScannerRules";
    public static final String REPORT_RELEASE_ADDON = "start.reportReleaseAddons";
    public static final String REPORT_BETA_ADDON = "start.reportBetaAddons";
    public static final String REPORT_ALPHA_ADDON = "start.reportAlphaAddons";
    public static final String ADDON_DIRS = "start.addonDirs";
    public static final String DOWNLOAD_DIR = "start.downloadDir";
    private static String SDF_FORMAT = "yyyy-MM-dd";
    private boolean checkOnStart;
    private boolean downloadNewRelease = false;
    private boolean checkAddonUpdates;
    private boolean installAddonUpdates = false;
    private boolean installScannerRules = false;
    private boolean reportReleaseAddons = false;
    private boolean reportBetaAddons = false;
    private boolean reportAlphaAddons = false;
    private List<File> addonDirectories = new ArrayList<File>();
    private File downloadDirectory = new File(Constant.FOLDER_LOCAL_PLUGIN);
    private String dayLastChecked = null;
    private String dayLastInstallWarned = null;
    private String dayLastUpdateWarned = null;
    private static Logger log = Logger.getLogger(OptionsParamCheckForUpdates.class);

    @Override
    protected void parse() {
        this.updateOldOptions();
        this.checkOnStart = this.getBoolean(CHECK_ON_START, true);
        this.dayLastChecked = this.getString(DAY_LAST_CHECKED, "");
        this.dayLastInstallWarned = this.getString(DAY_LAST_INSTALL_WARNED, "");
        this.dayLastUpdateWarned = this.getString(DAY_LAST_UPDATE_WARNED, "");
        this.downloadNewRelease = this.getBoolean(DOWNLOAD_NEW_RELEASE, false);
        this.checkAddonUpdates = this.getBoolean(CHECK_ADDON_UPDATES, true);
        this.installAddonUpdates = this.getBoolean(INSTALL_ADDON_UPDATES, false);
        this.installScannerRules = this.getBoolean(INSTALL_SCANNER_RULES, false);
        this.reportReleaseAddons = this.getBoolean(REPORT_RELEASE_ADDON, false);
        this.reportBetaAddons = this.getBoolean(REPORT_BETA_ADDON, false);
        this.reportAlphaAddons = this.getBoolean(REPORT_ALPHA_ADDON, false);
        for (Object dir : this.getConfig().getList(ADDON_DIRS)) {
            File f = new File(dir.toString());
            if (!f.exists()) {
                log.error((Object)("Add-on directory does not exist: " + f.getAbsolutePath()));
                continue;
            }
            if (!f.isDirectory()) {
                log.error((Object)("Add-on directory is not a directory: " + f.getAbsolutePath()));
                continue;
            }
            if (!f.canRead()) {
                log.error((Object)("Add-on directory not readable: " + f.getAbsolutePath()));
                continue;
            }
            this.addonDirectories.add(f);
        }
        this.setDownloadDirectory(new File(this.getString(DOWNLOAD_DIR, Constant.FOLDER_LOCAL_PLUGIN)), false);
    }

    private void updateOldOptions() {
        try {
            int oldValue = this.getConfig().getInt(CHECK_ON_START, 0);
            this.getConfig().setProperty(CHECK_ON_START, (Object)(oldValue != 0 ? 1 : 0));
        }
        catch (ConversionException conversionException) {
            // empty catch block
        }
    }

    public void setCheckOnStart(boolean checkOnStart) {
        this.checkOnStart = checkOnStart;
        this.getConfig().setProperty(CHECK_ON_START, (Object)checkOnStart);
        if (this.dayLastChecked.length() == 0) {
            this.dayLastChecked = "Never";
            this.getConfig().setProperty(DAY_LAST_CHECKED, (Object)this.dayLastChecked);
        }
    }

    public boolean isCheckOnStart() {
        return this.checkOnStart;
    }

    private SimpleDateFormat getSdf() {
        return new SimpleDateFormat(SDF_FORMAT);
    }

    @ZapApiIgnore
    public boolean checkOnStart() {
        if (!this.checkOnStart) {
            log.debug((Object)"isCheckForStart - false");
            return false;
        }
        String today = this.getSdf().format(new Date());
        if (today.equals(this.dayLastChecked)) {
            log.debug((Object)"isCheckForStart - already checked today");
            return false;
        }
        this.getConfig().setProperty(DAY_LAST_CHECKED, (Object)today);
        try {
            this.getConfig().save();
        }
        catch (ConfigurationException e) {
            log.error((Object)e.getMessage(), (Throwable)e);
        }
        return true;
    }

    public Date getDayLastChecked() {
        try {
            return this.getSdf().parse(this.dayLastChecked);
        }
        catch (ParseException e) {
            return null;
        }
    }

    public Date getDayLastInstallWarned() {
        try {
            return this.getSdf().parse(this.dayLastInstallWarned);
        }
        catch (ParseException e) {
            return null;
        }
    }

    public Date getDayLastUpdateWarned() {
        try {
            return this.getSdf().parse(this.dayLastUpdateWarned);
        }
        catch (ParseException e) {
            return null;
        }
    }

    public void setDayLastInstallWarned() {
        this.getConfig().setProperty(DAY_LAST_INSTALL_WARNED, (Object)this.getSdf().format(new Date()));
        try {
            this.getConfig().save();
        }
        catch (ConfigurationException e) {
            log.error((Object)e.getMessage(), (Throwable)e);
        }
    }

    public void setDayLastUpdateWarned() {
        this.getConfig().setProperty(DAY_LAST_UPDATE_WARNED, (Object)this.getSdf().format(new Date()));
        try {
            this.getConfig().save();
        }
        catch (ConfigurationException e) {
            log.error((Object)e.getMessage(), (Throwable)e);
        }
    }

    public boolean isDownloadNewRelease() {
        return this.downloadNewRelease;
    }

    public void setDownloadNewRelease(boolean downloadNewRelease) {
        this.downloadNewRelease = downloadNewRelease;
        this.getConfig().setProperty(DOWNLOAD_NEW_RELEASE, (Object)this.downloadNewRelease);
    }

    public boolean isCheckAddonUpdates() {
        return this.checkAddonUpdates;
    }

    public void setCheckAddonUpdates(boolean checkAddonUpdates) {
        this.checkAddonUpdates = checkAddonUpdates;
        this.getConfig().setProperty(CHECK_ADDON_UPDATES, (Object)checkAddonUpdates);
    }

    public boolean isInstallAddonUpdates() {
        return this.installAddonUpdates;
    }

    public void setInstallAddonUpdates(boolean installAddonUpdates) {
        this.installAddonUpdates = installAddonUpdates;
        this.getConfig().setProperty(INSTALL_ADDON_UPDATES, (Object)installAddonUpdates);
    }

    public boolean isInstallScannerRules() {
        return this.installScannerRules;
    }

    public void setInstallScannerRules(boolean installScannerRules) {
        this.installScannerRules = installScannerRules;
        this.getConfig().setProperty(INSTALL_SCANNER_RULES, (Object)installScannerRules);
    }

    public boolean isReportReleaseAddons() {
        return this.reportReleaseAddons;
    }

    public void setReportReleaseAddons(boolean reportReleaseAddons) {
        this.reportReleaseAddons = reportReleaseAddons;
        this.getConfig().setProperty(REPORT_RELEASE_ADDON, (Object)reportReleaseAddons);
    }

    public boolean isReportBetaAddons() {
        return this.reportBetaAddons;
    }

    public void setReportBetaAddons(boolean reportBetaAddons) {
        this.reportBetaAddons = reportBetaAddons;
        this.getConfig().setProperty(REPORT_BETA_ADDON, (Object)reportBetaAddons);
    }

    public boolean isReportAlphaAddons() {
        return this.reportAlphaAddons;
    }

    public void setReportAlphaAddons(boolean reportAlphaAddons) {
        this.reportAlphaAddons = reportAlphaAddons;
        this.getConfig().setProperty(REPORT_ALPHA_ADDON, (Object)reportAlphaAddons);
    }

    public List<File> getAddonDirectories() {
        return this.addonDirectories;
    }

    public void setAddonDirectories(List<File> addonDirectories) {
        this.addonDirectories = addonDirectories;
        this.getConfig().setProperty(ADDON_DIRS, addonDirectories);
    }

    public File getDownloadDirectory() {
        return this.downloadDirectory;
    }

    public void setDownloadDirectory(File downloadDirectory) throws InvalidParameterException {
        this.setDownloadDirectory(downloadDirectory, true);
    }

    private void setDownloadDirectory(File downloadDirectory, boolean save) throws InvalidParameterException {
        if (!Constant.FOLDER_LOCAL_PLUGIN.equals(downloadDirectory.getAbsolutePath())) {
            boolean found = false;
            for (File f : this.addonDirectories) {
                if (!f.equals(downloadDirectory)) continue;
                found = true;
                break;
            }
            if (!found) {
                throw new InvalidParameterException("Directory must be the default one or one of the addonDirectories " + downloadDirectory.getAbsolutePath());
            }
        }
        if (!downloadDirectory.canWrite()) {
            throw new InvalidParameterException("No write access to directory " + downloadDirectory.getAbsolutePath());
        }
        this.downloadDirectory = downloadDirectory;
        if (save) {
            this.getConfig().setProperty(DOWNLOAD_DIR, (Object)downloadDirectory.getAbsolutePath());
        }
    }
}

