#ifndef _EIO_MODEL_EO_H_
#define _EIO_MODEL_EO_H_

#ifndef _EIO_MODEL_EO_CLASS_TYPE
#define _EIO_MODEL_EO_CLASS_TYPE

typedef Eo Eio_Model;

#endif

#ifndef _EIO_MODEL_EO_TYPES
#define _EIO_MODEL_EO_TYPES

/** EflIoFilter function
 *
 * @ingroup EflIoFilter
 */
typedef int (*EflIoFilter)(void *data, Eio_Model *model, Eina_File_Direct_Info *entry);


#endif
/** Eio model class
 *
 * @ingroup Eio_Model
 */
#define EIO_MODEL_CLASS eio_model_class_get()

EWAPI const Efl_Class *eio_model_class_get(void);

/**
 * @brief Set children filter callback.
 *
 * This function sets, along with user's private data userdata, the Eio's
 * Eio_Filter_Direct_Cb which is a mid-step before receiving the real data.
 * Once in filter callback we can decide, by returning either EINA_FALSE, to
 * abort the notification or EINA_TRUE to keep it.
 *
 * See also @ref efl_model_children_slice_get.
 *
 * @param[in] obj The object.
 * @param[in] filter Filter callback
 *
 * @since 1.11
 *
 * @ingroup Eio_Model
 */
EOAPI void eio_model_children_filter_set(Eo *obj, void *filter_data, EflIoFilter filter, Eina_Free_Cb filter_free_cb);

/**
 * @brief Define the root path of a model.
 *
 * Only possible during construction.
 *
 * @param[in] obj The object.
 * @param[in] path Root path of the model.
 *
 * @since 1.11
 *
 * @ingroup Eio_Model
 */
EOAPI void eio_model_path_set(Eo *obj, const char *path);

/**
 * @brief Define the root path of a model.
 *
 * @param[in] obj The object.
 *
 * @return Root path of the model.
 *
 * @since 1.11
 *
 * @ingroup Eio_Model
 */
EOAPI const char *eio_model_path_get(const Eo *obj);

#endif
