/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.lib.profiler.ui.swing;

import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.event.ActionEvent;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.JPopupMenu;
import javax.swing.JToolBar;
import org.netbeans.lib.profiler.ui.UIUtils;
import org.netbeans.lib.profiler.ui.swing.SmallButton;
import org.netbeans.modules.profiler.api.icons.Icons;

public class PopupButton
extends SmallButton {
    private static final Icon DROPDOWN_ICON = Icons.getIcon((String)"GeneralIcons.PopupArrow");
    private static final int DROPDOWN_ICON_WIDTH = DROPDOWN_ICON.getIconWidth();
    private static final int DROPDOWN_ICON_HEIGHT = DROPDOWN_ICON.getIconHeight();
    private int iconOffset = UIUtils.isMetalLookAndFeel() ? 6 : (UIUtils.isNimbusLookAndFeel() ? 8 : 7);
    private int popupAlign = 10;

    public PopupButton() {
        this.setHorizontalAlignment(10);
    }

    public PopupButton(Icon icon) {
        super(icon);
        this.setHorizontalAlignment(10);
    }

    public PopupButton(String string) {
        super(string);
        this.setHorizontalAlignment(10);
    }

    public PopupButton(Action action) {
        super(action);
        this.setHorizontalAlignment(10);
    }

    public PopupButton(String string, Icon icon) {
        super(string, icon);
        this.setHorizontalAlignment(10);
    }

    public void setPopupAlign(int n) {
        this.popupAlign = n;
    }

    public int getPopupAlign() {
        return this.popupAlign;
    }

    @Override
    protected void fireActionPerformed(ActionEvent actionEvent) {
        super.fireActionPerformed(actionEvent);
        this.displayPopup();
    }

    protected void displayPopup() {
        JPopupMenu jPopupMenu = new JPopupMenu();
        this.populatePopup(jPopupMenu);
        if (jPopupMenu.getComponentCount() > 0) {
            int n;
            int n2;
            Dimension dimension = jPopupMenu.getPreferredSize();
            dimension.width = Math.max(dimension.width, this.getWidth());
            jPopupMenu.setPreferredSize(dimension);
            int n3 = this.getPopupAlign();
            switch (n3) {
                case 2: 
                case 3: 
                case 4: {
                    n2 = this.getWidth() - dimension.width;
                    break;
                }
                default: {
                    n2 = 0;
                }
            }
            switch (n3) {
                case 1: 
                case 2: 
                case 8: {
                    n = -dimension.height;
                    break;
                }
                default: {
                    n = this.getHeight();
                }
            }
            jPopupMenu.show(this, n2, n);
        }
    }

    protected void populatePopup(JPopupMenu jPopupMenu) {
    }

    @Override
    public Dimension getPreferredSize() {
        Dimension dimension = super.getPreferredSize();
        dimension.width = dimension.width + (DROPDOWN_ICON_WIDTH + (this.isEmpty() ? 3 : 5));
        return dimension;
    }

    @Override
    public Dimension getMinimumSize() {
        return this.getPreferredSize();
    }

    @Override
    public Dimension getMaximumSize() {
        return this.getPreferredSize();
    }

    @Override
    public void addNotify() {
        super.addNotify();
        if (UIUtils.isWindowsLookAndFeel() && this.getParent() instanceof JToolBar) {
            if (this.getIcon() == NO_ICON) {
                this.setIconTextGap(2);
            }
            this.iconOffset = 5;
        }
    }

    @Override
    protected void paintComponent(Graphics graphics) {
        super.paintComponent(graphics);
        if (this.isEmpty()) {
            DROPDOWN_ICON.paintIcon(this, graphics, (this.getWidth() - DROPDOWN_ICON_WIDTH) / 2, (this.getHeight() - DROPDOWN_ICON_HEIGHT) / 2);
        } else {
            DROPDOWN_ICON.paintIcon(this, graphics, this.getWidth() - DROPDOWN_ICON_WIDTH - this.iconOffset, (this.getHeight() - DROPDOWN_ICON_HEIGHT) / 2);
        }
    }

    private boolean isEmpty() {
        if (this.getIcon() != NO_ICON) {
            return false;
        }
        String string = this.getText();
        return string == null || string.isEmpty();
    }
}

