/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.actions;

import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import org.openstreetmap.josm.actions.JosmAction;
import org.openstreetmap.josm.command.Command;
import org.openstreetmap.josm.command.MoveCommand;
import org.openstreetmap.josm.command.SequenceCommand;
import org.openstreetmap.josm.data.UndoRedoHandler;
import org.openstreetmap.josm.data.coor.EastNorth;
import org.openstreetmap.josm.data.coor.PolarCoor;
import org.openstreetmap.josm.data.osm.DataSet;
import org.openstreetmap.josm.data.osm.Node;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.Way;
import org.openstreetmap.josm.gui.Notification;
import org.openstreetmap.josm.gui.help.HelpUtil;
import org.openstreetmap.josm.tools.Geometry;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.Shortcut;

public final class AlignInCircleAction
extends JosmAction {
    public AlignInCircleAction() {
        super(I18n.tr("Align Nodes in Circle", new Object[0]), "aligncircle", I18n.tr("Move the selected nodes into a circle.", new Object[0]), Shortcut.registerShortcut("tools:aligncircle", I18n.tr("Tool: {0}", I18n.tr("Align Nodes in Circle", new Object[0])), 79, 5003), true);
        this.putValue("help", HelpUtil.ht("/Action/AlignInCircle"));
    }

    public static MoveCommand createMoveCommand(Node n, PolarCoor coor) {
        EastNorth en = coor.toEastNorth();
        return new MoveCommand((OsmPrimitive)n, en.east() - n.getEastNorth().east(), en.north() - n.getEastNorth().north());
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        int startPosition;
        if (!this.isEnabled()) {
            return;
        }
        Collection sel = this.getLayerManager().getEditDataSet().getSelected();
        List<Node> nodes = new LinkedList<Node>();
        HashSet<Node> fixNodes = new HashSet<Node>();
        LinkedList<Way> ways = new LinkedList<Way>();
        EastNorth center = null;
        double radius = 0.0;
        for (OsmPrimitive osm : sel) {
            if (osm instanceof Node) {
                nodes.add((Node)osm);
                continue;
            }
            if (!(osm instanceof Way)) continue;
            ways.add((Way)osm);
        }
        if (ways.size() == 1 && !((Way)ways.get(0)).isClosed()) {
            Way w = (Way)ways.get(0);
            fixNodes.add(w.firstNode());
            fixNodes.add(w.lastNode());
            fixNodes.addAll(nodes);
            fixNodes.addAll(AlignInCircleAction.collectNodesWithExternReferers(ways));
            Way closedWay = new Way(w);
            closedWay.addNode(w.firstNode());
            ArrayList usedWays = new ArrayList(1);
            usedWays.add(closedWay);
            nodes = AlignInCircleAction.collectNodesAnticlockwise(usedWays);
        } else if (!ways.isEmpty() && AlignInCircleAction.checkWaysArePolygon(ways)) {
            ArrayList inside = new ArrayList();
            ArrayList<Node> outside = new ArrayList<Node>();
            for (Node n : nodes) {
                boolean isInside = false;
                for (Way w : ways) {
                    if (!w.getNodes().contains(n)) continue;
                    isInside = true;
                    break;
                }
                if (isInside) {
                    inside.add(n);
                    continue;
                }
                outside.add(n);
            }
            if (outside.size() == 1 && inside.isEmpty()) {
                center = ((Node)outside.get(0)).getEastNorth();
            } else if (outside.size() == 1 && inside.size() == 1) {
                center = ((Node)outside.get(0)).getEastNorth();
                radius = center.distance(((Node)inside.get(0)).getEastNorth());
            } else if (inside.size() == 2 && outside.isEmpty()) {
                EastNorth en0 = ((Node)inside.get(0)).getEastNorth();
                EastNorth en1 = ((Node)inside.get(1)).getEastNorth();
                center = new EastNorth((en0.east() + en1.east()) / 2.0, (en0.north() + en1.north()) / 2.0);
                radius = en0.distance(en1) / 2.0;
            }
            fixNodes.addAll(inside);
            fixNodes.addAll(AlignInCircleAction.collectNodesWithExternReferers(ways));
            nodes = AlignInCircleAction.collectNodesAnticlockwise(ways);
            if (nodes.size() < 4) {
                new Notification(I18n.tr("Not enough nodes in selected ways.", new Object[0])).setIcon(1).setDuration(Notification.TIME_SHORT).show();
                return;
            }
        } else if (ways.isEmpty() && nodes.size() > 3) {
            fixNodes.addAll(nodes);
        } else {
            new Notification(I18n.tr("Please select at least four nodes.", new Object[0])).setIcon(1).setDuration(Notification.TIME_SHORT).show();
            return;
        }
        if (center == null && (center = Geometry.getCenter(nodes)) == null) {
            new Notification(I18n.tr("Cannot determine center of selected nodes.", new Object[0])).setIcon(1).setDuration(Notification.TIME_SHORT).show();
            return;
        }
        if (radius == 0.0) {
            for (Node n : nodes) {
                radius += center.distance(n.getEastNorth());
            }
            radius /= (double)nodes.size();
        }
        if (!AlignInCircleAction.actionAllowed(nodes)) {
            return;
        }
        LinkedList<Command> cmds = new LinkedList<Command>();
        int nodeCount = nodes.size();
        for (startPosition = 0; startPosition < nodeCount && !fixNodes.contains(nodes.get(startPosition % nodeCount)); ++startPosition) {
        }
        int i = startPosition;
        while (i < startPosition + nodeCount) {
            int j;
            for (j = i + 1; j < startPosition + nodeCount && !fixNodes.contains(nodes.get(j % nodeCount)); ++j) {
            }
            Node first = nodes.get(i % nodeCount);
            PolarCoor pcFirst = new PolarCoor(radius, PolarCoor.computeAngle(first.getEastNorth(), center), center);
            cmds.add(AlignInCircleAction.createMoveCommand(first, pcFirst));
            if (j > i + 1) {
                double delta;
                if (j == i + nodeCount) {
                    delta = Math.PI * 2 / (double)nodeCount;
                } else {
                    PolarCoor pcLast = new PolarCoor(nodes.get(j % nodeCount).getEastNorth(), center);
                    delta = pcLast.angle - pcFirst.angle;
                    if (delta < 0.0) {
                        delta += Math.PI * 2;
                    }
                    delta /= (double)(j - i);
                }
                for (int k = i + 1; k < j; ++k) {
                    PolarCoor p = new PolarCoor(radius, pcFirst.angle + (double)(k - i) * delta, center);
                    cmds.add(AlignInCircleAction.createMoveCommand(nodes.get(k % nodeCount), p));
                }
            }
            i = j;
        }
        UndoRedoHandler.getInstance().add(new SequenceCommand(I18n.tr("Align Nodes in Circle", new Object[0]), cmds));
    }

    private static List<Node> collectNodesWithExternReferers(List<Way> ways) {
        ArrayList<Node> withReferrers = new ArrayList<Node>();
        for (Way w : ways) {
            for (Node n : w.getNodes()) {
                if (n.getReferrers().size() <= 1) continue;
                withReferrers.add(n);
            }
        }
        return withReferrers;
    }

    private static List<Node> collectNodesAnticlockwise(List<Way> ways) {
        int i;
        ArrayList<Node> nodes = new ArrayList<Node>();
        Node firstNode = ways.get(0).firstNode();
        Node lastNode = null;
        Way lastWay = null;
        block0: while (firstNode != lastNode) {
            if (lastNode == null) {
                lastNode = firstNode;
            }
            for (Way way : ways) {
                List<Node> wayNodes;
                if (way == lastWay) continue;
                if (way.firstNode() == lastNode) {
                    wayNodes = way.getNodes();
                    for (i = 0; i < wayNodes.size() - 1; ++i) {
                        nodes.add(wayNodes.get(i));
                    }
                    lastNode = way.lastNode();
                    lastWay = way;
                    continue block0;
                }
                if (way.lastNode() != lastNode) continue;
                wayNodes = way.getNodes();
                for (i = wayNodes.size() - 1; i > 0; --i) {
                    nodes.add(wayNodes.get(i));
                }
                lastNode = way.firstNode();
                lastWay = way;
                continue block0;
            }
        }
        int nc = nodes.size();
        double area = 0.0;
        for (i = 0; i < nc; ++i) {
            EastNorth p1 = ((Node)nodes.get(i)).getEastNorth();
            EastNorth p2 = ((Node)nodes.get((i + 1) % nc)).getEastNorth();
            area += p1.east() * p2.north() - p2.east() * p1.north();
        }
        if (area < 0.0) {
            Collections.reverse(nodes);
        }
        return nodes;
    }

    private static boolean actionAllowed(Collection<Node> nodes) {
        boolean outside = false;
        for (Node n : nodes) {
            if (!n.isOutsideDownloadArea()) continue;
            outside = true;
            break;
        }
        if (outside) {
            new Notification(I18n.tr("One or more nodes involved in this action is outside of the downloaded area.", new Object[0])).setIcon(2).setDuration(Notification.TIME_SHORT).show();
        }
        return true;
    }

    @Override
    protected void updateEnabledState() {
        DataSet ds = this.getLayerManager().getEditDataSet();
        this.setEnabled(ds != null && !ds.selectionEmpty());
    }

    @Override
    protected void updateEnabledState(Collection<? extends OsmPrimitive> selection) {
        this.updateEnabledStateOnModifiableSelection(selection);
    }

    private static boolean checkWaysArePolygon(Collection<Way> ways) {
        for (Way way : ways) {
            for (Node node : way.getNodes()) {
                if (way.isFirstLastNode(node)) continue;
                for (Way wayOther : ways) {
                    if (way == wayOther || !node.getReferrers().contains(wayOther)) continue;
                    return false;
                }
            }
        }
        Way currentWay = null;
        Node startNode = null;
        Node endNode = null;
        int used = 0;
        do {
            Way nextWay = null;
            for (Way w : ways) {
                if (w.isClosed()) {
                    return ways.size() == 1;
                }
                if (w == currentWay) continue;
                if (currentWay == null) {
                    nextWay = w;
                    startNode = w.firstNode();
                    endNode = w.lastNode();
                    break;
                }
                if (w.firstNode() == endNode) {
                    nextWay = w;
                    endNode = w.lastNode();
                    break;
                }
                if (w.lastNode() != endNode) continue;
                nextWay = w;
                endNode = w.firstNode();
                break;
            }
            if (nextWay == null) {
                return false;
            }
            ++used;
            currentWay = nextWay;
        } while (endNode != startNode);
        return used == ways.size();
    }
}

