/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bcel.classfile;

import java.io.BufferedInputStream;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.apache.bcel.classfile.Attribute;
import org.apache.bcel.classfile.ClassFormatException;
import org.apache.bcel.classfile.ConstantPool;
import org.apache.bcel.classfile.Field;
import org.apache.bcel.classfile.JavaClass;
import org.apache.bcel.classfile.Method;

public final class ClassParser {
    private DataInputStream dataInputStream;
    private final boolean fileOwned;
    private final String file_name;
    private String zip_file;
    private int class_name_index;
    private int superclass_name_index;
    private int major;
    private int minor;
    private int access_flags;
    private int[] interfaces;
    private ConstantPool constant_pool;
    private Field[] fields;
    private Method[] methods;
    private Attribute[] attributes;
    private final boolean is_zip;
    private static final int BUFSIZE = 8192;

    public ClassParser(InputStream inputStream, String file_name) {
        this.file_name = file_name;
        this.fileOwned = false;
        String clazz = inputStream.getClass().getName();
        this.is_zip = clazz.startsWith("java.util.zip.") || clazz.startsWith("java.util.jar.");
        this.dataInputStream = inputStream instanceof DataInputStream ? (DataInputStream)inputStream : new DataInputStream(new BufferedInputStream(inputStream, 8192));
    }

    public ClassParser(String file_name) {
        this.is_zip = false;
        this.file_name = file_name;
        this.fileOwned = true;
    }

    public ClassParser(String zip_file, String file_name) {
        this.is_zip = true;
        this.fileOwned = true;
        this.zip_file = zip_file;
        this.file_name = file_name;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public JavaClass parse() throws IOException, ClassFormatException {
        ZipFile zip = null;
        try {
            if (this.fileOwned) {
                if (this.is_zip) {
                    zip = new ZipFile(this.zip_file);
                    ZipEntry entry = zip.getEntry(this.file_name);
                    if (entry == null) {
                        throw new IOException("File " + this.file_name + " not found");
                    }
                    this.dataInputStream = new DataInputStream(new BufferedInputStream(zip.getInputStream(entry), 8192));
                } else {
                    this.dataInputStream = new DataInputStream(new BufferedInputStream(new FileInputStream(this.file_name), 8192));
                }
            }
            this.readID();
            this.readVersion();
            this.readConstantPool();
            this.readClassInfo();
            this.readInterfaces();
            this.readFields();
            this.readMethods();
            this.readAttributes();
        }
        finally {
            if (this.fileOwned) {
                try {
                    if (this.dataInputStream != null) {
                        this.dataInputStream.close();
                    }
                }
                catch (IOException ioe) {}
            }
            try {
                if (zip != null) {
                    zip.close();
                }
            }
            catch (IOException iOException) {}
        }
        return new JavaClass(this.class_name_index, this.superclass_name_index, this.file_name, this.major, this.minor, this.access_flags, this.constant_pool, this.interfaces, this.fields, this.methods, this.attributes, this.is_zip ? (byte)3 : 2);
    }

    private void readAttributes() throws IOException, ClassFormatException {
        int attributes_count = this.dataInputStream.readUnsignedShort();
        this.attributes = new Attribute[attributes_count];
        for (int i = 0; i < attributes_count; ++i) {
            this.attributes[i] = Attribute.readAttribute(this.dataInputStream, this.constant_pool);
        }
    }

    private void readClassInfo() throws IOException, ClassFormatException {
        this.access_flags = this.dataInputStream.readUnsignedShort();
        if ((this.access_flags & 0x200) != 0) {
            this.access_flags |= 0x400;
        }
        if ((this.access_flags & 0x400) != 0 && (this.access_flags & 0x10) != 0) {
            throw new ClassFormatException("Class " + this.file_name + " can't be both final and abstract");
        }
        this.class_name_index = this.dataInputStream.readUnsignedShort();
        this.superclass_name_index = this.dataInputStream.readUnsignedShort();
    }

    private void readConstantPool() throws IOException, ClassFormatException {
        this.constant_pool = new ConstantPool(this.dataInputStream);
    }

    private void readFields() throws IOException, ClassFormatException {
        int fields_count = this.dataInputStream.readUnsignedShort();
        this.fields = new Field[fields_count];
        for (int i = 0; i < fields_count; ++i) {
            this.fields[i] = new Field((DataInput)this.dataInputStream, this.constant_pool);
        }
    }

    private void readID() throws IOException, ClassFormatException {
        if (this.dataInputStream.readInt() != -889275714) {
            throw new ClassFormatException(this.file_name + " is not a Java .class file");
        }
    }

    private void readInterfaces() throws IOException, ClassFormatException {
        int interfaces_count = this.dataInputStream.readUnsignedShort();
        this.interfaces = new int[interfaces_count];
        for (int i = 0; i < interfaces_count; ++i) {
            this.interfaces[i] = this.dataInputStream.readUnsignedShort();
        }
    }

    private void readMethods() throws IOException, ClassFormatException {
        int methods_count = this.dataInputStream.readUnsignedShort();
        this.methods = new Method[methods_count];
        for (int i = 0; i < methods_count; ++i) {
            this.methods[i] = new Method((DataInput)this.dataInputStream, this.constant_pool);
        }
    }

    private void readVersion() throws IOException, ClassFormatException {
        this.minor = this.dataInputStream.readUnsignedShort();
        this.major = this.dataInputStream.readUnsignedShort();
    }
}

