/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.lib.profiler.ui.threads;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.image.BufferedImage;
import java.util.HashSet;
import java.util.ResourceBundle;
import java.util.Set;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.ActionMap;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JToggleButton;
import javax.swing.RowFilter;
import javax.swing.SortOrder;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import org.netbeans.lib.profiler.global.CommonConstants;
import org.netbeans.lib.profiler.results.DataManagerListener;
import org.netbeans.lib.profiler.results.threads.ThreadData;
import org.netbeans.lib.profiler.results.threads.ThreadsDataManager;
import org.netbeans.lib.profiler.ui.Formatters;
import org.netbeans.lib.profiler.ui.UIUtils;
import org.netbeans.lib.profiler.ui.components.HTMLTextArea;
import org.netbeans.lib.profiler.ui.results.DataView;
import org.netbeans.lib.profiler.ui.swing.FilterUtils;
import org.netbeans.lib.profiler.ui.swing.ProfilerTable;
import org.netbeans.lib.profiler.ui.swing.ProfilerTableContainer;
import org.netbeans.lib.profiler.ui.swing.SearchUtils;
import org.netbeans.lib.profiler.ui.swing.renderer.CheckBoxRenderer;
import org.netbeans.lib.profiler.ui.swing.renderer.NumberRenderer;
import org.netbeans.lib.profiler.ui.threads.NameStateRenderer;
import org.netbeans.lib.profiler.ui.threads.ThreadStateIcon;
import org.netbeans.lib.profiler.ui.threads.ThreadTimeRelRenderer;
import org.netbeans.lib.profiler.ui.threads.TimelineHeaderRenderer;
import org.netbeans.lib.profiler.ui.threads.TimelineRenderer;
import org.netbeans.lib.profiler.ui.threads.ViewManager;

public class ThreadsPanel
extends DataView {
    private final ThreadsDataManager dataManager;
    private final ViewManager viewManager;
    private DataManagerListener listener;
    private ProfilerTable threadsTable;
    private ProfilerTableContainer threadsTableContainer;
    private JPanel bottomPanel;
    private JPanel legendPanel;
    private Filter filter = Filter.ALL;
    private final Set<Integer> selected = new HashSet<Integer>();
    private final Set<Integer> selectedApplied = new HashSet<Integer>();
    private Component zoomInAction;
    private Component zoomOutAction;
    private Component fitAction;
    private ThreadTimeRelRenderer timeRelRenderer;
    private long lastTimestamp;

    private static ResourceBundle BUNDLE() {
        return ResourceBundle.getBundle("org.netbeans.lib.profiler.ui.threads.Bundle");
    }

    public ThreadsPanel(ThreadsDataManager threadsDataManager, Action action) {
        this.dataManager = threadsDataManager;
        this.lastTimestamp = threadsDataManager.getEndTime();
        this.viewManager = new ViewManager(2, threadsDataManager){

            @Override
            public void columnWidthChanged(int n, int n2, int n3) {
                if (n == 2 && this.isFit()) {
                    ThreadsPanel.this.threadsTable.updateColumnPreferredWidth(2);
                }
                super.columnWidthChanged(n, n2, n3);
            }

            @Override
            public void columnOffsetChanged(int n, int n2, int n3) {
                super.columnOffsetChanged(n, n2, n3);
                if (n == 2) {
                    ThreadsPanel.this.repaintTimeline();
                }
            }

            @Override
            public void zoomChanged(double d, double d2) {
                super.zoomChanged(d, d2);
                ThreadsPanel.this.repaintTimeline();
            }
        };
        this.initUI(action);
    }

    public void setFilter(Filter filter) {
        this.selectedApplied.clear();
        if (Filter.SELECTED.equals((Object)filter)) {
            this.selectedApplied.addAll(this.selected);
        }
        this.filter = filter;
        this.threadsTable.addRowFilter(new ThreadsFilter());
        this.filterSelected(filter);
    }

    public Filter getFilter() {
        return this.filter;
    }

    protected void filterSelected(Filter filter) {
    }

    public boolean hasSelectedThreads() {
        return !this.selected.isEmpty();
    }

    public void showSelectedColumn() {
        this.threadsTable.setColumnVisibility(0, true);
    }

    public void cleanup() {
        this.dataManager.removeDataListener(this.listener);
    }

    private void initUI(Action action) {
        this.setOpaque(true);
        this.setBackground(new HTMLTextArea().getBackground());
        final AbstractTableModel abstractTableModel = new AbstractTableModel(){

            @Override
            public String getColumnName(int n) {
                if (n == 0) {
                    return ThreadsPanel.BUNDLE().getString("COL_Selected");
                }
                if (n == 1) {
                    return ThreadsPanel.BUNDLE().getString("COL_Name");
                }
                if (n == 2) {
                    return ThreadsPanel.BUNDLE().getString("COL_Timeline");
                }
                if (n == 3) {
                    return CommonConstants.THREAD_STATUS_RUNNING_STRING;
                }
                if (n == 4) {
                    return CommonConstants.THREAD_STATUS_SLEEPING_STRING;
                }
                if (n == 5) {
                    return CommonConstants.THREAD_STATUS_WAIT_STRING;
                }
                if (n == 6) {
                    return CommonConstants.THREAD_STATUS_PARK_STRING;
                }
                if (n == 7) {
                    return CommonConstants.THREAD_STATUS_MONITOR_STRING;
                }
                if (n == 8) {
                    return ThreadsPanel.BUNDLE().getString("COL_Total");
                }
                return null;
            }

            @Override
            public Class<?> getColumnClass(int n) {
                if (n == 0) {
                    return Boolean.class;
                }
                if (n == 1) {
                    return ThreadData.class;
                }
                if (n == 2) {
                    return ViewManager.RowView.class;
                }
                return Long.class;
            }

            @Override
            public int getRowCount() {
                return ThreadsPanel.this.dataManager.getThreadsCount();
            }

            @Override
            public int getColumnCount() {
                return 9;
            }

            @Override
            public Object getValueAt(int n, int n2) {
                if (n2 == 0) {
                    return ThreadsPanel.this.selected.contains(n);
                }
                if (n2 == 1) {
                    return this.getData(n);
                }
                if (n2 == 2) {
                    return ThreadsPanel.this.viewManager.getRowView(n);
                }
                if (n2 == 3) {
                    return this.getData(n).getRunningTime(ThreadsPanel.this.lastTimestamp);
                }
                if (n2 == 4) {
                    return this.getData(n).getSleepingTime(ThreadsPanel.this.lastTimestamp);
                }
                if (n2 == 5) {
                    return this.getData(n).getWaitTime(ThreadsPanel.this.lastTimestamp);
                }
                if (n2 == 6) {
                    return this.getData(n).getParkTime(ThreadsPanel.this.lastTimestamp);
                }
                if (n2 == 7) {
                    return this.getData(n).getMonitorTime(ThreadsPanel.this.lastTimestamp);
                }
                if (n2 == 8) {
                    return this.getData(n).getTotalTime(ThreadsPanel.this.lastTimestamp);
                }
                return null;
            }

            @Override
            public void setValueAt(Object object, int n, int n2) {
                if (n2 == 0) {
                    if (Boolean.FALSE.equals(object)) {
                        ThreadsPanel.this.selected.remove(n);
                    } else {
                        ThreadsPanel.this.selected.add(n);
                    }
                }
            }

            @Override
            public boolean isCellEditable(int n, int n2) {
                return n2 == 0;
            }

            private ThreadData getData(int n) {
                return ThreadsPanel.this.dataManager.getThreadData(n);
            }
        };
        this.threadsTable = new ProfilerTable(abstractTableModel, true, true, new int[]{2}){

            @Override
            protected int computeColumnPreferredWidth(int n, int n2, int n3, int n4) {
                if (n != 2) {
                    return super.computeColumnPreferredWidth(n, n2, n3, n4);
                }
                ThreadsPanel.this.viewManager.update();
                if (ThreadsPanel.this.viewManager.isFit()) {
                    return this.getTableHeader().getHeaderRect((int)n2).width;
                }
                return ThreadsPanel.this.viewManager.getViewWidth();
            }

            @Override
            public Object getUserValueForRow(int n) {
                if (n == -1) {
                    return null;
                }
                if (n >= this.getModel().getRowCount()) {
                    return null;
                }
                return this.convertRowIndexToModel(n);
            }

            @Override
            protected void populatePopup(JPopupMenu jPopupMenu, Object object, Object object2) {
                if (object2 != null) {
                    final int n = (Integer)object2;
                    final boolean bl = ThreadsPanel.this.selected.contains(n);
                    jPopupMenu.add(new JMenuItem(bl ? ThreadsPanel.BUNDLE().getString("ACT_UnselectThread") : ThreadsPanel.BUNDLE().getString("ACT_SelectThread")){

                        @Override
                        protected void fireActionPerformed(ActionEvent actionEvent) {
                            if (bl) {
                                ThreadsPanel.this.selected.remove(n);
                            } else {
                                ThreadsPanel.this.selected.add(n);
                            }
                            abstractTableModel.fireTableDataChanged();
                            if (!bl) {
                                ThreadsPanel.this.showSelectedColumn();
                            }
                        }
                    });
                    jPopupMenu.addSeparator();
                }
                jPopupMenu.add(this.createCopyMenuItem());
                jPopupMenu.addSeparator();
                jPopupMenu.add(new JMenuItem(FilterUtils.ACTION_FILTER){

                    @Override
                    protected void fireActionPerformed(ActionEvent actionEvent) {
                        ThreadsPanel.this.activateFilter();
                    }
                });
                jPopupMenu.add(new JMenuItem(SearchUtils.ACTION_FIND){

                    @Override
                    protected void fireActionPerformed(ActionEvent actionEvent) {
                        ThreadsPanel.this.activateSearch();
                    }
                });
            }
        };
        this.threadsTable.setColumnVisibility(0, false);
        this.threadsTable.setMainColumn(1);
        this.threadsTable.setColumnToolTips(new String[]{ThreadsPanel.BUNDLE().getString("DESC_Selected"), ThreadsPanel.BUNDLE().getString("DESC_Name"), ThreadsPanel.BUNDLE().getString("DESC_Timeline"), ThreadsPanel.BUNDLE().getString("DESC_Running"), ThreadsPanel.BUNDLE().getString("DESC_Sleeping"), ThreadsPanel.BUNDLE().getString("DESC_Wait"), ThreadsPanel.BUNDLE().getString("DESC_Park"), ThreadsPanel.BUNDLE().getString("DESC_Monitor"), ThreadsPanel.BUNDLE().getString("DESC_Total")});
        this.threadsTable.setDefaultSortOrder(1, SortOrder.ASCENDING);
        this.threadsTable.setDefaultSortOrder(2, SortOrder.ASCENDING);
        this.threadsTable.setSecondarySortColumn(1);
        this.threadsTable.setSortColumn(2);
        this.threadsTable.setFitWidthColumn(2);
        NameStateRenderer nameStateRenderer = new NameStateRenderer();
        nameStateRenderer.setText("THREADnameTOsetupCOLUMNwidth");
        this.threadsTable.setColumnRenderer(0, new CheckBoxRenderer());
        this.threadsTable.setDefaultRenderer(ThreadData.class, nameStateRenderer);
        this.threadsTable.setDefaultRenderer(ViewManager.RowView.class, new TimelineRenderer(this.viewManager));
        int n = new JLabel((String)this.threadsTable.getColumnName((int)0)).getPreferredSize().width;
        this.threadsTable.setDefaultColumnWidth(0, n + 15);
        this.threadsTable.setDefaultColumnWidth(1, nameStateRenderer.getPreferredSize().width);
        JTableHeader jTableHeader = this.threadsTable.getTableHeader();
        TableCellRenderer tableCellRenderer = jTableHeader.getDefaultRenderer();
        jTableHeader.setDefaultRenderer(new TimelineHeaderRenderer(tableCellRenderer, 2, this.viewManager));
        Long l = new Long(1234567L);
        this.timeRelRenderer = new ThreadTimeRelRenderer(this.dataManager);
        this.timeRelRenderer.setMaxValue(l);
        this.threadsTable.setDefaultColumnWidth(this.timeRelRenderer.getNoBarWidth());
        this.threadsTable.setDefaultRenderer(Long.class, this.timeRelRenderer);
        NumberRenderer numberRenderer = new NumberRenderer(Formatters.millisecondsFormat());
        numberRenderer.setValue(l, -1);
        this.threadsTable.setDefaultColumnWidth(8, numberRenderer.getPreferredSize().width);
        this.threadsTable.setColumnRenderer(8, numberRenderer);
        this.threadsTable.setColumnVisibility(4, false);
        this.threadsTable.setColumnVisibility(5, false);
        this.threadsTable.setColumnVisibility(6, false);
        this.threadsTable.setColumnVisibility(7, false);
        this.threadsTable.providePopupMenu(true);
        this.threadsTableContainer = new ProfilerTableContainer(this.threadsTable, false, this.viewManager);
        this.legendPanel = new JPanel(new FlowLayout(4, 7, 8));
        this.legendPanel.setOpaque(false);
        ThreadStateIcon threadStateIcon = new ThreadStateIcon(1, 18, 9);
        JLabel jLabel = new JLabel(CommonConstants.THREAD_STATUS_RUNNING_STRING, threadStateIcon, 10);
        jLabel.setBorder(BorderFactory.createEmptyBorder(0, 5, 0, 0));
        this.legendPanel.add(jLabel);
        ThreadStateIcon threadStateIcon2 = new ThreadStateIcon(2, 18, 9);
        JLabel jLabel2 = new JLabel(CommonConstants.THREAD_STATUS_SLEEPING_STRING, threadStateIcon2, 10);
        jLabel2.setBorder(BorderFactory.createEmptyBorder(0, 5, 0, 0));
        this.legendPanel.add(jLabel2);
        ThreadStateIcon threadStateIcon3 = new ThreadStateIcon(4, 18, 9);
        JLabel jLabel3 = new JLabel(CommonConstants.THREAD_STATUS_WAIT_STRING, threadStateIcon3, 10);
        jLabel3.setBorder(BorderFactory.createEmptyBorder(0, 5, 0, 0));
        this.legendPanel.add(jLabel3);
        ThreadStateIcon threadStateIcon4 = new ThreadStateIcon(5, 18, 9);
        JLabel jLabel4 = new JLabel(CommonConstants.THREAD_STATUS_PARK_STRING, threadStateIcon4, 10);
        jLabel4.setBorder(BorderFactory.createEmptyBorder(0, 5, 0, 0));
        this.legendPanel.add(jLabel4);
        ThreadStateIcon threadStateIcon5 = new ThreadStateIcon(3, 18, 9);
        JLabel jLabel5 = new JLabel(CommonConstants.THREAD_STATUS_MONITOR_STRING, threadStateIcon5, 10);
        jLabel5.setBorder(BorderFactory.createEmptyBorder(0, 5, 0, 0));
        this.legendPanel.add(jLabel5);
        final Action action2 = this.viewManager.zoomInAction();
        this.zoomInAction = new JButton(action2){

            @Override
            protected void fireActionPerformed(ActionEvent actionEvent) {
                super.fireActionPerformed(actionEvent);
                Object object = action2.getValue("newOffset");
                if (object != null) {
                    int n = (Integer)object;
                    ThreadsPanel.this.threadsTable.setColumnOffset(2, n);
                }
                abstractTableModel.fireTableDataChanged();
            }

            @Override
            public boolean isEnabled() {
                return ThreadsPanel.this.threadsTable.isShowing() && super.isEnabled();
            }
        };
        final Action action3 = this.viewManager.zoomOutAction();
        this.zoomOutAction = new JButton(action3){

            @Override
            protected void fireActionPerformed(ActionEvent actionEvent) {
                super.fireActionPerformed(actionEvent);
                Object object = action3.getValue("newOffset");
                if (object != null) {
                    int n = (Integer)object;
                    ThreadsPanel.this.threadsTable.setColumnOffset(2, n);
                }
                abstractTableModel.fireTableDataChanged();
            }

            @Override
            public boolean isEnabled() {
                return ThreadsPanel.this.threadsTable.isShowing() && super.isEnabled();
            }
        };
        this.fitAction = new JToggleButton(this.viewManager.fitAction()){

            @Override
            protected void fireActionPerformed(ActionEvent actionEvent) {
                super.fireActionPerformed(actionEvent);
                abstractTableModel.fireTableDataChanged();
            }
        };
        this.fitAction.setEnabled(false);
        this.bottomPanel = new JPanel(new BorderLayout());
        this.bottomPanel.setOpaque(false);
        this.bottomPanel.add((Component)this.legendPanel, "South");
        this.setOpaque(true);
        this.setBackground(UIUtils.getProfilerResultsBackground());
        this.setLayout(new BorderLayout());
        this.add((Component)this.threadsTableContainer, "Center");
        this.add((Component)this.bottomPanel, "South");
        this.listener = new DataManagerListener(){
            private boolean firstChange = true;

            public void dataChanged() {
                ThreadsPanel.this.lastTimestamp = ThreadsPanel.this.dataManager.getEndTime();
                if (this.firstChange) {
                    this.firstChange = false;
                    ThreadsPanel.this.repaintTimeline();
                }
                abstractTableModel.fireTableDataChanged();
            }

            public void dataReset() {
                ThreadsPanel.this.viewManager.reset();
                this.firstChange = true;
                ThreadsPanel.this.timeRelRenderer.setMaxValue(0L);
                abstractTableModel.fireTableDataChanged();
            }
        };
        this.dataManager.addDataListener(this.listener);
        this.registerActions();
    }

    private void registerActions() {
        ActionMap actionMap = this.getActionMap();
        actionMap.put("filter-action-key", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ThreadsPanel.this.activateFilter();
            }
        });
        actionMap.put("find-action-key", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ThreadsPanel.this.activateSearch();
            }
        });
    }

    @Override
    protected ProfilerTable getResultsComponent() {
        return this.threadsTable;
    }

    @Override
    protected boolean hasBottomFilterFindMargin() {
        return true;
    }

    @Override
    protected void addFilterFindPanel(JComponent jComponent) {
        this.bottomPanel.add((Component)jComponent, "North");
    }

    private void repaintTimeline() {
        JTableHeader jTableHeader = this.threadsTable.getTableHeader();
        TableColumn tableColumn = jTableHeader.getDraggedColumn();
        if (tableColumn != null && tableColumn.getModelIndex() == 2) {
            jTableHeader.repaint();
        } else {
            int n = this.threadsTable.convertColumnIndexToView(2);
            jTableHeader.repaint(jTableHeader.getHeaderRect(n));
        }
    }

    public Component getToolbar() {
        return null;
    }

    public Component getZoomIn() {
        return this.zoomInAction;
    }

    public Component getZoomOut() {
        return this.zoomOutAction;
    }

    public Component getFitWidth() {
        return this.fitAction;
    }

    public BufferedImage getCurrentViewScreenshot(boolean bl) {
        return this.threadsTableContainer.createTableScreenshot(bl);
    }

    public boolean fitsVisibleArea() {
        return !this.threadsTableContainer.tableNeedsScrolling();
    }

    public boolean hasView() {
        return this.threadsTableContainer.isShowing();
    }

    public void threadsMonitoringDisabled() {
        this.fitAction.setEnabled(false);
    }

    public void threadsMonitoringEnabled() {
        this.fitAction.setEnabled(true);
    }

    public void profilingSessionStarted() {
        this.selected.clear();
        if (!this.selectedApplied.isEmpty()) {
            this.setFilter(Filter.LIVE);
        }
    }

    public void profilingSessionFinished() {
    }

    public void addThreadsMonitoringActionListener(ActionListener actionListener) {
    }

    private final class ThreadsFilter
    extends RowFilter {
        private ThreadsFilter() {
        }

        public boolean include(RowFilter.Entry entry) {
            ThreadData threadData = (ThreadData)entry.getValue(1);
            switch (ThreadsPanel.this.filter) {
                case LIVE: {
                    return ThreadData.isAliveState((int)threadData.getLastState());
                }
                case FINISHED: {
                    return !ThreadData.isAliveState((int)threadData.getLastState());
                }
                case SELECTED: {
                    return ThreadsPanel.this.selectedApplied.contains(entry.getIdentifier());
                }
            }
            return true;
        }

        public boolean equals(Object object) {
            return object instanceof ThreadsFilter;
        }

        public int hashCode() {
            return 0x7FFFFFF4;
        }
    }

    public static enum Filter {
        ALL,
        LIVE,
        FINISHED,
        SELECTED;

    }
}

