/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.codegen;

import java.io.PrintWriter;
import java.io.StringWriter;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.codegen.AbstractClassBuilder;
import org.jetbrains.kotlin.codegen.ClassBuilder;
import org.jetbrains.kotlin.codegen.ClassBuilderFactory;
import org.jetbrains.kotlin.codegen.ClassBuilderMode;
import org.jetbrains.kotlin.resolve.jvm.diagnostics.JvmDeclarationOrigin;
import org.jetbrains.org.objectweb.asm.ClassWriter;
import org.jetbrains.org.objectweb.asm.util.TraceClassVisitor;

public class ClassBuilderFactories {
    @NotNull
    public static ClassBuilderFactory THROW_EXCEPTION = new ClassBuilderFactory(){

        @Override
        @NotNull
        public ClassBuilderMode getClassBuilderMode() {
            return ClassBuilderMode.FULL;
        }

        @Override
        @NotNull
        public ClassBuilder newClassBuilder(@NotNull JvmDeclarationOrigin origin) {
            throw new IllegalStateException();
        }

        @Override
        public String asText(ClassBuilder builder) {
            throw new IllegalStateException();
        }

        @Override
        public byte[] asBytes(ClassBuilder builder) {
            throw new IllegalStateException();
        }

        @Override
        public void close() {
            throw new IllegalStateException();
        }
    };
    public static ClassBuilderFactory TEST = new TestClassBuilderFactory();
    @NotNull
    public static ClassBuilderFactory BINARIES = new ClassBuilderFactory(){

        @Override
        @NotNull
        public ClassBuilderMode getClassBuilderMode() {
            return ClassBuilderMode.FULL;
        }

        @Override
        @NotNull
        public ClassBuilder newClassBuilder(@NotNull JvmDeclarationOrigin origin) {
            return new AbstractClassBuilder.Concrete(new BinaryClassWriter());
        }

        @Override
        public String asText(ClassBuilder builder) {
            throw new UnsupportedOperationException("BINARIES generator asked for text");
        }

        @Override
        public byte[] asBytes(ClassBuilder builder) {
            ClassWriter visitor2 = (ClassWriter)builder.getVisitor();
            return visitor2.toByteArray();
        }

        @Override
        public void close() {
        }
    };

    private ClassBuilderFactories() {
    }

    private static class TraceBuilder
    extends AbstractClassBuilder.Concrete {
        public final BinaryClassWriter binary;

        public TraceBuilder(BinaryClassWriter binary) {
            super(new TraceClassVisitor(binary, new PrintWriter(new StringWriter())));
            this.binary = binary;
        }
    }

    private static class BinaryClassWriter
    extends ClassWriter {
        public BinaryClassWriter() {
            super(3);
        }

        @Override
        protected String getCommonSuperClass(@NotNull String type1, @NotNull String type2) {
            return "java/lang/Object";
        }
    }

    public static class TestClassBuilderFactory
    implements ClassBuilderFactory {
        @Override
        @NotNull
        public ClassBuilderMode getClassBuilderMode() {
            return ClassBuilderMode.FULL;
        }

        @Override
        @NotNull
        public ClassBuilder newClassBuilder(@NotNull JvmDeclarationOrigin origin) {
            return new TraceBuilder(new BinaryClassWriter());
        }

        @Override
        public String asText(ClassBuilder builder) {
            TraceClassVisitor visitor2 = (TraceClassVisitor)builder.getVisitor();
            StringWriter writer = new StringWriter();
            visitor2.p.print(new PrintWriter(writer));
            return writer.toString();
        }

        @Override
        public byte[] asBytes(ClassBuilder builder) {
            return ((TraceBuilder)builder).binary.toByteArray();
        }

        @Override
        public void close() {
        }
    }
}

