/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.tasks.compile;

import com.google.common.collect.Lists;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.gradle.api.internal.tasks.compile.DefaultJvmLanguageCompileSpec;
import org.gradle.api.internal.tasks.compile.JavaCompileSpec;
import org.gradle.api.internal.tasks.compile.MinimalJavaCompileOptions;
import org.gradle.api.internal.tasks.compile.processing.AnnotationProcessorDeclaration;
import org.gradle.api.tasks.compile.CompileOptions;

public class DefaultJavaCompileSpec
extends DefaultJvmLanguageCompileSpec
implements JavaCompileSpec {
    private MinimalJavaCompileOptions compileOptions;
    private List<File> annotationProcessorPath;
    private Set<AnnotationProcessorDeclaration> effectiveAnnotationProcessors;
    private Set<String> classes;

    @Override
    public MinimalJavaCompileOptions getCompileOptions() {
        return this.compileOptions;
    }

    public void setCompileOptions(CompileOptions compileOptions) {
        this.compileOptions = new MinimalJavaCompileOptions(compileOptions);
    }

    @Override
    public List<File> getAnnotationProcessorPath() {
        return this.annotationProcessorPath;
    }

    @Override
    public void setAnnotationProcessorPath(List<File> annotationProcessorPath) {
        this.annotationProcessorPath = annotationProcessorPath;
    }

    @Override
    public Set<AnnotationProcessorDeclaration> getEffectiveAnnotationProcessors() {
        return this.effectiveAnnotationProcessors;
    }

    @Override
    public void setEffectiveAnnotationProcessors(Set<AnnotationProcessorDeclaration> annotationProcessors) {
        this.effectiveAnnotationProcessors = annotationProcessors;
    }

    @Override
    public Set<String> getClasses() {
        return this.classes;
    }

    @Override
    public void setClasses(Set<String> classes) {
        this.classes = classes;
    }

    @Override
    public List<File> getModulePath() {
        int i = this.compileOptions.getCompilerArgs().indexOf("--module-path");
        if (i < 0) {
            return Collections.emptyList();
        }
        String[] modules = this.compileOptions.getCompilerArgs().get(i + 1).split(File.pathSeparator);
        ArrayList result = Lists.newArrayListWithCapacity((int)modules.length);
        for (String module : modules) {
            result.add(new File(module));
        }
        return result;
    }
}

