/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.cache.internal;

import java.io.File;
import javax.annotation.Nullable;
import org.gradle.cache.CacheRepository;
import org.gradle.cache.internal.CacheFactory;
import org.gradle.cache.internal.CacheKeyBuilder;
import org.gradle.cache.internal.CacheScopeMapping;
import org.gradle.cache.internal.DefaultCacheKeyBuilder;
import org.gradle.cache.internal.DefaultCacheRepository;
import org.gradle.cache.internal.DefaultCacheScopeMapping;
import org.gradle.internal.classloader.ClassLoaderHierarchyHasher;
import org.gradle.internal.classloader.ClasspathHasher;
import org.gradle.internal.hash.FileHasher;
import org.gradle.internal.hash.Hashing;
import org.gradle.util.GradleVersion;

public class CacheRepositoryServices {
    private final File gradleUserHomeDir;
    private final File projectCacheDir;

    public CacheRepositoryServices(File gradleUserHomeDir, @Nullable File projectCacheDir) {
        this.gradleUserHomeDir = gradleUserHomeDir;
        this.projectCacheDir = projectCacheDir;
    }

    protected CacheScopeMapping createCacheScopeMapping() {
        return new DefaultCacheScopeMapping(this.gradleUserHomeDir, this.projectCacheDir, GradleVersion.current());
    }

    protected CacheRepository createCacheRepository(CacheFactory factory, CacheScopeMapping scopeMapping) {
        return new DefaultCacheRepository(scopeMapping, factory);
    }

    protected CacheKeyBuilder createCacheKeyBuilder(FileHasher fileHasher, ClasspathHasher classpathHasher, ClassLoaderHierarchyHasher classLoaderHierarchyHasher) {
        return new DefaultCacheKeyBuilder(Hashing.md5(), fileHasher, classpathHasher, classLoaderHierarchyHasher);
    }
}

