/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.groovy.scripts;

import org.gradle.groovy.scripts.DelegatingScriptSource;
import org.gradle.groovy.scripts.ScriptSource;
import org.gradle.internal.resource.CachingTextResource;
import org.gradle.internal.resource.TextResource;

public class CachingScriptSource
extends DelegatingScriptSource {
    private final TextResource resource;
    private final String displayName;

    public static ScriptSource of(ScriptSource source) {
        if (source.getResource().isContentCached()) {
            return source;
        }
        return new CachingScriptSource(source);
    }

    private CachingScriptSource(ScriptSource source) {
        super(source);
        this.resource = new CachingTextResource(source.getResource());
        this.displayName = source.getDisplayName();
    }

    @Override
    public String getDisplayName() {
        return this.displayName;
    }

    @Override
    public TextResource getResource() {
        return this.resource;
    }
}

