/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.groovy.scripts.internal;

import org.gradle.api.GradleScriptException;
import org.gradle.groovy.scripts.Script;
import org.gradle.groovy.scripts.ScriptExecutionListener;
import org.gradle.groovy.scripts.ScriptRunner;
import org.gradle.groovy.scripts.ScriptSource;
import org.gradle.groovy.scripts.internal.CompiledScript;
import org.gradle.groovy.scripts.internal.ScriptRunnerFactory;
import org.gradle.internal.reflect.Instantiator;
import org.gradle.internal.service.ServiceRegistry;

public class DefaultScriptRunnerFactory
implements ScriptRunnerFactory {
    private final ScriptExecutionListener listener;
    private final Instantiator instantiator;

    public DefaultScriptRunnerFactory(ScriptExecutionListener listener, Instantiator instantiator) {
        this.listener = listener;
        this.instantiator = instantiator;
    }

    @Override
    public <T extends Script, M> ScriptRunner<T, M> create(CompiledScript<T, M> script, ScriptSource source, ClassLoader contextClassLoader) {
        return new ScriptRunnerImpl<T, M>(script, source, contextClassLoader);
    }

    private class ScriptRunnerImpl<T extends Script, M>
    implements ScriptRunner<T, M> {
        private final ScriptSource source;
        private final ClassLoader contextClassLoader;
        private T script;
        private final CompiledScript<T, M> compiledScript;

        public ScriptRunnerImpl(CompiledScript<T, M> compiledScript, ScriptSource source, ClassLoader contextClassLoader) {
            this.compiledScript = compiledScript;
            this.source = source;
            this.contextClassLoader = contextClassLoader;
        }

        @Override
        public T getScript() {
            if (this.script == null) {
                Class<T> scriptClass = this.compiledScript.loadClass();
                this.script = (Script)((Object)DefaultScriptRunnerFactory.this.instantiator.newInstance(scriptClass, new Object[0]));
                ((Script)((Object)this.script)).setScriptSource(this.source);
                ((Script)((Object)this.script)).setContextClassloader(this.contextClassLoader);
                DefaultScriptRunnerFactory.this.listener.scriptClassLoaded(this.source, scriptClass);
            }
            return this.script;
        }

        @Override
        public M getData() {
            return this.compiledScript.getData();
        }

        @Override
        public boolean getRunDoesSomething() {
            return this.compiledScript.getRunDoesSomething();
        }

        @Override
        public boolean getHasMethods() {
            return this.compiledScript.getHasMethods();
        }

        @Override
        public void run(Object target, ServiceRegistry scriptServices) throws GradleScriptException {
            if (!this.compiledScript.getRunDoesSomething()) {
                return;
            }
            ClassLoader originalLoader = Thread.currentThread().getContextClassLoader();
            T script = this.getScript();
            ((Script)((Object)script)).init(target, scriptServices);
            Thread.currentThread().setContextClassLoader(((Script)((Object)script)).getContextClassloader());
            ((Script)((Object)script)).getStandardOutputCapture().start();
            try {
                script.run();
            }
            catch (Throwable e) {
                throw new GradleScriptException(String.format("A problem occurred evaluating %s.", script), e);
            }
            finally {
                ((Script)((Object)script)).getStandardOutputCapture().stop();
                Thread.currentThread().setContextClassLoader(originalLoader);
            }
        }
    }
}

