/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.tasks.diagnostics.internal.insight;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.google.common.collect.Sets;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import org.gradle.api.Transformer;
import org.gradle.api.artifacts.result.ComponentSelectionCause;
import org.gradle.api.artifacts.result.ComponentSelectionDescriptor;
import org.gradle.api.artifacts.result.ComponentSelectionReason;
import org.gradle.api.artifacts.result.DependencyResult;
import org.gradle.api.artifacts.result.ResolvedDependencyResult;
import org.gradle.api.artifacts.result.ResolvedVariantResult;
import org.gradle.api.artifacts.result.UnresolvedDependencyResult;
import org.gradle.api.internal.artifacts.ivyservice.ivyresolve.strategy.VersionComparator;
import org.gradle.api.internal.artifacts.ivyservice.ivyresolve.strategy.VersionParser;
import org.gradle.api.internal.artifacts.ivyservice.ivyresolve.strategy.VersionSelectorScheme;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.result.ComponentSelectionDescriptorInternal;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.result.ComponentSelectionReasonInternal;
import org.gradle.api.tasks.diagnostics.internal.graph.nodes.DefaultSection;
import org.gradle.api.tasks.diagnostics.internal.graph.nodes.DependencyEdge;
import org.gradle.api.tasks.diagnostics.internal.graph.nodes.DependencyReportHeader;
import org.gradle.api.tasks.diagnostics.internal.graph.nodes.RenderableDependency;
import org.gradle.api.tasks.diagnostics.internal.graph.nodes.RequestedVersion;
import org.gradle.api.tasks.diagnostics.internal.graph.nodes.ResolvedDependencyEdge;
import org.gradle.api.tasks.diagnostics.internal.graph.nodes.Section;
import org.gradle.api.tasks.diagnostics.internal.graph.nodes.UnresolvedDependencyEdge;
import org.gradle.api.tasks.diagnostics.internal.insight.DependencyResultSorter;
import org.gradle.internal.text.TreeFormatter;
import org.gradle.util.CollectionUtils;

public class DependencyInsightReporter {
    private final VersionSelectorScheme versionSelectorScheme;
    private final VersionComparator versionComparator;
    private final VersionParser versionParser;
    private static final Transformer<DependencyEdge, DependencyResult> TO_EDGES = new Transformer<DependencyEdge, DependencyResult>(){

        public DependencyEdge transform(DependencyResult result) {
            if (result instanceof UnresolvedDependencyResult) {
                return new UnresolvedDependencyEdge((UnresolvedDependencyResult)result);
            }
            return new ResolvedDependencyEdge((ResolvedDependencyResult)result);
        }
    };

    public DependencyInsightReporter(VersionSelectorScheme versionSelectorScheme, VersionComparator versionComparator, VersionParser versionParser) {
        this.versionSelectorScheme = versionSelectorScheme;
        this.versionComparator = versionComparator;
        this.versionParser = versionParser;
    }

    public Collection<RenderableDependency> convertToRenderableItems(Collection<DependencyResult> dependencies, boolean singlePathToDependency) {
        LinkedList<RenderableDependency> out = new LinkedList<RenderableDependency>();
        Collection<DependencyEdge> sortedEdges = this.toDependencyEdges(dependencies);
        HashSet annotated = Sets.newHashSet();
        HashSet alreadyReportedErrors = Sets.newHashSet();
        RequestedVersion current = null;
        for (DependencyEdge dependency : sortedEdges) {
            if (annotated.add(dependency.getActual())) {
                DependencyReportHeader header = this.createHeaderForDependency(dependency, alreadyReportedErrors);
                out.add(header);
                current = this.newRequestedVersion(out, dependency);
            } else if (!current.getRequested().equals(dependency.getRequested())) {
                current = this.newRequestedVersion(out, dependency);
            }
            if (singlePathToDependency && !current.getChildren().isEmpty()) continue;
            current.addChild(dependency);
        }
        return out;
    }

    private DependencyReportHeader createHeaderForDependency(DependencyEdge dependency, Set<Throwable> alreadyReportedErrors) {
        ComponentSelectionReason reason = dependency.getReason();
        String reasonDescription = DependencyInsightReporter.getReasonDescription(reason);
        SelectionReasonsSection selectionReasonsSection = DependencyInsightReporter.buildSelectionReasonSection(reason);
        if (selectionReasonsSection.replacesShortDescription) {
            reasonDescription = null;
        }
        List<Section> extraDetails = DependencyInsightReporter.buildExtraDetails(!selectionReasonsSection.replacesShortDescription ? null : selectionReasonsSection, DependencyInsightReporter.buildFailureSection(dependency, alreadyReportedErrors));
        ResolvedVariantResult selectedVariant = dependency.getSelectedVariant();
        return new DependencyReportHeader(dependency, reasonDescription, selectedVariant, extraDetails);
    }

    private RequestedVersion newRequestedVersion(LinkedList<RenderableDependency> out, DependencyEdge dependency) {
        RequestedVersion current = new RequestedVersion(dependency.getRequested(), dependency.getActual(), dependency.isResolvable());
        out.add(current);
        return current;
    }

    private Collection<DependencyEdge> toDependencyEdges(Collection<DependencyResult> dependencies) {
        List edges = CollectionUtils.collect(dependencies, TO_EDGES);
        return DependencyResultSorter.sort(edges, this.versionSelectorScheme, this.versionComparator, this.versionParser);
    }

    private static Section buildFailureSection(DependencyEdge edge, Set<Throwable> alreadyReportedErrors) {
        UnresolvedDependencyEdge unresolved;
        Throwable failure;
        if (edge instanceof UnresolvedDependencyEdge && (failure = (unresolved = (UnresolvedDependencyEdge)edge).getFailure()) != null) {
            DefaultSection failures = new DefaultSection("Failures");
            String errorMessage = DependencyInsightReporter.collectErrorMessages(failure, alreadyReportedErrors);
            failures.addChild(new DefaultSection(errorMessage));
            return failures;
        }
        return null;
    }

    private static String collectErrorMessages(Throwable failure, Set<Throwable> alreadyReportedErrors) {
        TreeFormatter formatter = new TreeFormatter(false);
        DependencyInsightReporter.collectErrorMessages(failure, formatter, alreadyReportedErrors);
        return formatter.toString();
    }

    private static void collectErrorMessages(Throwable failure, TreeFormatter formatter, Set<Throwable> alreadyReportedErrors) {
        if (alreadyReportedErrors.add(failure)) {
            formatter.node(failure.getMessage());
            Throwable cause = failure.getCause();
            if (alreadyReportedErrors.contains(cause)) {
                formatter.append((CharSequence)" (already reported)");
            }
            if (cause != null && cause != failure) {
                formatter.startChildren();
                DependencyInsightReporter.collectErrorMessages(cause, formatter, alreadyReportedErrors);
                formatter.endChildren();
            }
        }
    }

    private static List<Section> buildExtraDetails(Section ... sections) {
        ImmutableList.Builder builder = new ImmutableList.Builder();
        for (Section section : sections) {
            if (section == null) continue;
            builder.add((Object)section);
        }
        return builder.build();
    }

    private static SelectionReasonsSection buildSelectionReasonSection(ComponentSelectionReason reason) {
        SelectionReasonsSection selectionReasons = new SelectionReasonsSection();
        for (ComponentSelectionDescriptor entry : reason.getDescriptions()) {
            ComponentSelectionDescriptorInternal descriptor = (ComponentSelectionDescriptorInternal)entry;
            ComponentSelectionCause cause = descriptor.getCause();
            boolean hasCustomDescription = descriptor.hasCustomDescription();
            String message = null;
            if (hasCustomDescription) {
                selectionReasons.shouldDisplay();
                message = descriptor.getDescription();
            }
            String prettyCause = DependencyInsightReporter.prettyCause(cause);
            DefaultSection item = new DefaultSection(hasCustomDescription ? prettyCause + " : " + message : prettyCause);
            selectionReasons.addChild(item);
        }
        return selectionReasons;
    }

    private static String prettyCause(ComponentSelectionCause cause) {
        switch (cause) {
            case ROOT: {
                return "Root component";
            }
            case REQUESTED: {
                return "Was requested";
            }
            case SELECTED_BY_RULE: {
                return "Selected by rule";
            }
            case FORCED: {
                return "Forced";
            }
            case CONFLICT_RESOLUTION: {
                return "By conflict resolution";
            }
            case COMPOSITE_BUILD: {
                return "By composite build";
            }
            case REJECTION: {
                return "Rejection";
            }
            case CONSTRAINT: {
                return "By constraint";
            }
        }
        return "Unknown";
    }

    private static String getReasonDescription(ComponentSelectionReason reason) {
        ComponentSelectionReasonInternal r = (ComponentSelectionReasonInternal)reason;
        String description = DependencyInsightReporter.getReasonDescription(r);
        if (reason.isConstrained()) {
            if (!r.hasCustomDescriptions()) {
                return "via constraint";
            }
            return "via constraint, " + description;
        }
        return description;
    }

    private static String getReasonDescription(ComponentSelectionReasonInternal reason) {
        if (!reason.hasCustomDescriptions()) {
            return reason.isExpected() ? null : ((ComponentSelectionDescriptor)Iterables.getLast((Iterable)reason.getDescriptions())).getDescription();
        }
        return DependencyInsightReporter.getLastCustomReason(reason);
    }

    private static String getLastCustomReason(ComponentSelectionReasonInternal reason) {
        String lastCustomReason = null;
        for (ComponentSelectionDescriptor descriptor : reason.getDescriptions()) {
            if (!((ComponentSelectionDescriptorInternal)descriptor).hasCustomDescription()) continue;
            lastCustomReason = descriptor.getDescription();
        }
        return lastCustomReason;
    }

    private static class SelectionReasonsSection
    extends DefaultSection {
        private boolean replacesShortDescription;

        public SelectionReasonsSection() {
            super("Selection reasons");
        }

        public void shouldDisplay() {
            this.replacesShortDescription = true;
        }
    }
}

