/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.internal.storage.file;

import java.io.IOException;
import java.io.OutputStream;
import org.eclipse.jgit.internal.JGitText;
import org.eclipse.jgit.internal.storage.file.PackIndexWriter;
import org.eclipse.jgit.transport.PackedObjectInfo;
import org.eclipse.jgit.util.NB;

class PackIndexWriterV1
extends PackIndexWriter {
    static boolean canStore(PackedObjectInfo oe) {
        return oe.getOffset() >>> 1 < Integer.MAX_VALUE;
    }

    PackIndexWriterV1(OutputStream dst) {
        super(dst);
    }

    @Override
    protected void writeImpl() throws IOException {
        this.writeFanOutTable();
        for (PackedObjectInfo oe : this.entries) {
            if (!PackIndexWriterV1.canStore(oe)) {
                throw new IOException(JGitText.get().packTooLargeForIndexVersion1);
            }
            NB.encodeInt32(this.tmp, 0, (int)oe.getOffset());
            oe.copyRawTo(this.tmp, 4);
            this.out.write(this.tmp);
        }
        this.writeChecksumFooter();
    }
}

