/*
 * Decompiled with CFR 0.152.
 */
package org.protege.editor.owl.ui.renderer;

import org.protege.editor.owl.OWLEditorKit;
import org.protege.editor.owl.ui.prefix.PrefixUtilities;
import org.protege.editor.owl.ui.renderer.AbstractOWLEntityRenderer;
import org.protege.editor.owl.ui.renderer.prefix.PrefixBasedRenderer;
import org.semanticweb.owlapi.model.IRI;
import org.semanticweb.owlapi.model.PrefixManager;
import org.semanticweb.owlapi.util.DefaultPrefixManager;
import org.semanticweb.owlapi.vocab.Namespaces;

public class OWLEntityQNameRenderer
extends AbstractOWLEntityRenderer
implements PrefixBasedRenderer {
    private final DefaultPrefixManager prefixManager = new DefaultPrefixManager();

    @Override
    public void initialise() {
        for (Namespaces ns : Namespaces.values()) {
            String prefixName = ns.getPrefixName();
            String prefixIRI = ns.getPrefixIRI();
            this.prefixManager.setPrefix(prefixName + ":", prefixIRI);
        }
        PrefixManager localPrefixes = PrefixUtilities.getPrefixOWLOntologyFormat(this.getOWLModelManager());
        for (String prefixName : localPrefixes.getPrefixNames()) {
            String prefixIRI = localPrefixes.getPrefix(prefixName);
            this.prefixManager.setPrefix(prefixName, prefixIRI);
        }
    }

    @Override
    public void ontologiesChanged() {
        this.initialise();
    }

    @Override
    public String render(IRI iri) {
        try {
            String s = this.prefixManager.getPrefixIRI(iri);
            if (s != null) {
                return s;
            }
            return iri.toQuotedString();
        }
        catch (Exception e) {
            return "<Error! " + e.getMessage() + ">";
        }
    }

    @Override
    public boolean isConfigurable() {
        return false;
    }

    @Override
    public boolean configure(OWLEditorKit eKit) {
        throw new IllegalStateException("This renderer is not configurable");
    }

    @Override
    protected void disposeRenderer() {
    }
}

