#!/bin/sh
export PATH='/usr/lib/distcc/bin:/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
echo 'name: tamarin-prover-term
version: 1.4.0
id: tamarin-prover-term-1.4.0-FWyi21WvYIH6rGc67LfTGq
key: tamarin-prover-term-1.4.0-FWyi21WvYIH6rGc67LfTGq
license: LicenseRef-GPL
copyright: Benedikt Schmidt, Simon Meier, Jannik Dreier, Ralf Sasse, ETH Zurich, 2010-2018
maintainer: Simon Meier <simon.meier@inf.ethz.ch>,
            Jannik Dreier <research@jannikdreier.net>,
            Ralf Sasse <ralf.sasse@gmail.com>
author: Benedikt Schmidt <benedikt.schmidt@inf.ethz.ch>,
        Simon Meier <simon.meier@inf.ethz.ch>,
        Jannik Dreier <research@jannikdreier.net>,
        Ralf Sasse <ralf.sasse@gmail.com>
homepage: https://tamarin-prover.github.io/
synopsis: Term manipulation library for the tamarin prover.
description:
    This is an internal library of the Tamarin prover for
    security protocol verification
    (<hackage.haskell.org/package/tamarin-prover>).
    .
    This library provides term manipulation infrastructure
    (matching, unification, narrowing, finite variants) for
    the Tamarin prover. It uses maude
    (<http://maude.cs.uiuc.edu/>) as a backend for
    normalization, equational matching, and unification.
category: Theorem Provers
abi: ae9e6248f2acc89d30c9f54331b98d48
exposed: True
exposed-modules:
    Term.Builtin.Convenience Term.Builtin.Rules Term.Builtin.Signature
    Term.LTerm Term.Maude.Parser Term.Maude.Process
    Term.Maude.Signature Term.Maude.Types Term.Narrowing.Variants
    Term.Narrowing.Variants.Check Term.Narrowing.Variants.Compute
    Term.Positions Term.Rewriting.Definitions Term.Rewriting.Norm
    Term.Substitution Term.Subsumption Term.SubtermRule
    Term.Unification Term.UnitTests Term.VTerm
hidden-modules: Term.Term Term.Term.Classes Term.Term.Raw
                Term.Term.FunctionSymbols Term.Narrowing.Narrow
                Term.Substitution.SubstVFree Term.Substitution.SubstVFresh
import-dirs: /usr/lib/ghc-8.4.3/site-local/tamarin-prover-term-1.4.0
library-dirs: /usr/lib/ghc-8.4.3/site-local/tamarin-prover-term-1.4.0
dynamic-library-dirs: /usr/lib
data-dir: /usr/share/arm-linux-ghc-8.4.3/tamarin-prover-term-1.4.0
hs-libraries: HStamarin-prover-term-1.4.0-FWyi21WvYIH6rGc67LfTGq
depends:
    HUnit-1.6.0.0-8OmbxYW4AG9PppbZs26Xx
    attoparsec-0.13.2.2-LRi8ukEwwi1GyId6oqTEFJ base-4.11.1.0
    binary-0.8.5.1 bytestring-0.10.8.2 containers-0.5.11.0
    deepseq-1.4.3.0 dlist-0.8.0.4-CrGJIvQnsM82JxkEwejrYD mtl-2.2.2
    process-1.6.3.0 safe-0.3.17-HEmZRpXGD3s2ywM3rHJ1ur
    tamarin-prover-utils-1.4.0-97YC04SUVLG5IGhfYLbjy8
abi-depends: HUnit-1.6.0.0-8OmbxYW4AG9PppbZs26Xx=6ff9610fd5e59ec310c47074d0590847
             attoparsec-0.13.2.2-LRi8ukEwwi1GyId6oqTEFJ=b8f8a17746566009aae6e9799affc625
             base-4.11.1.0=a3fb1645bafaa89172454c2eea8dfdc9
             binary-0.8.5.1=0c28e4e382bf1405fd468e0d2a2b58e5
             bytestring-0.10.8.2=9faa89cf4769cbd12751f8644ca9e618
             containers-0.5.11.0=94bb4831ae701bd40855b2dc2d65cf7c
             deepseq-1.4.3.0=34da2d42d10eacba0aad99c95b538637
             dlist-0.8.0.4-CrGJIvQnsM82JxkEwejrYD=f79b3ead594e04b4f22b6b2afc0a8656
             mtl-2.2.2=0b3b35c3b96c7607606ed10087c4aa4a
             process-1.6.3.0=b58285e21ceee9f67d7be28ddb8b2627
             safe-0.3.17-HEmZRpXGD3s2ywM3rHJ1ur=42026212d0dad8beaed25fde58365be8
             tamarin-prover-utils-1.4.0-97YC04SUVLG5IGhfYLbjy8=10d894ec1bb46e18a6d2883d458618fe
haddock-interfaces: /usr/share/doc/haskell-tamarin-prover-term/html/tamarin-prover-term.haddock
haddock-html: /usr/share/doc/haskell-tamarin-prover-term/html
' | '/usr/bin/ghc-pkg' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

