/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.analyzer;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.analyzer.ModuleContent;
import org.jetbrains.kotlin.analyzer.ModuleInfo;
import org.jetbrains.kotlin.analyzer.PackageOracle;
import org.jetbrains.kotlin.analyzer.ResolverForProjectImpl;
import org.jetbrains.kotlin.descriptors.ModuleDescriptor;
import org.jetbrains.kotlin.descriptors.PackageFragmentDescriptor;
import org.jetbrains.kotlin.descriptors.PackageFragmentProvider;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.psi.KtFile;

@Metadata(mv={1, 1, 10}, bv={1, 0, 2}, k=1, d1={"\u0000V\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u0000*\b\b\u0000\u0010\u0001*\u00020\u00022\u00020\u0003B1\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00028\u00000\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\f\u0010\b\u001a\b\u0012\u0004\u0012\u00028\u00000\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u00a2\u0006\u0002\u0010\fJ\u0010\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u000fH\u0002J\u0016\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00150\u00142\u0006\u0010\u0012\u001a\u00020\u000fH\u0016J*\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u000f0\u00172\u0006\u0010\u0012\u001a\u00020\u000f2\u0012\u0010\u0018\u001a\u000e\u0012\u0004\u0012\u00020\u001a\u0012\u0004\u0012\u00020\u00110\u0019H\u0016R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00028\u00000\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001b"}, d2={"Lorg/jetbrains/kotlin/analyzer/DelegatingPackageFragmentProvider;", "M", "Lorg/jetbrains/kotlin/analyzer/ModuleInfo;", "Lorg/jetbrains/kotlin/descriptors/PackageFragmentProvider;", "resolverForProject", "Lorg/jetbrains/kotlin/analyzer/ResolverForProjectImpl;", "module", "Lorg/jetbrains/kotlin/descriptors/ModuleDescriptor;", "moduleContent", "Lorg/jetbrains/kotlin/analyzer/ModuleContent;", "packageOracle", "Lorg/jetbrains/kotlin/analyzer/PackageOracle;", "(Lorg/jetbrains/kotlin/analyzer/ResolverForProjectImpl;Lorg/jetbrains/kotlin/descriptors/ModuleDescriptor;Lorg/jetbrains/kotlin/analyzer/ModuleContent;Lorg/jetbrains/kotlin/analyzer/PackageOracle;)V", "syntheticFilePackages", "", "Lorg/jetbrains/kotlin/name/FqName;", "certainlyDoesNotExist", "", "fqName", "getPackageFragments", "", "Lorg/jetbrains/kotlin/descriptors/PackageFragmentDescriptor;", "getSubPackagesOf", "", "nameFilter", "Lkotlin/Function1;", "Lorg/jetbrains/kotlin/name/Name;", "frontend"})
final class DelegatingPackageFragmentProvider<M extends ModuleInfo>
implements PackageFragmentProvider {
    private final Set<FqName> syntheticFilePackages;
    private final ResolverForProjectImpl<M> resolverForProject;
    private final ModuleDescriptor module;
    private final PackageOracle packageOracle;

    @Override
    @NotNull
    public List<PackageFragmentDescriptor> getPackageFragments(@NotNull FqName fqName2) {
        Intrinsics.checkParameterIsNotNull(fqName2, "fqName");
        if (this.certainlyDoesNotExist(fqName2)) {
            return CollectionsKt.emptyList();
        }
        return this.resolverForProject.resolverForModuleDescriptor(this.module).getPackageFragmentProvider().getPackageFragments(fqName2);
    }

    @Override
    @NotNull
    public Collection<FqName> getSubPackagesOf(@NotNull FqName fqName2, @NotNull Function1<? super Name, Boolean> nameFilter2) {
        Intrinsics.checkParameterIsNotNull(fqName2, "fqName");
        Intrinsics.checkParameterIsNotNull(nameFilter2, "nameFilter");
        if (this.certainlyDoesNotExist(fqName2)) {
            return CollectionsKt.emptyList();
        }
        return this.resolverForProject.resolverForModuleDescriptor(this.module).getPackageFragmentProvider().getSubPackagesOf(fqName2, nameFilter2);
    }

    private final boolean certainlyDoesNotExist(FqName fqName2) {
        if (this.resolverForProject.isResolverForModuleDescriptorComputed$frontend(this.module)) {
            return false;
        }
        return !this.packageOracle.packageExists(fqName2) && !this.syntheticFilePackages.contains(fqName2);
    }

    /*
     * WARNING - void declaration
     */
    public DelegatingPackageFragmentProvider(@NotNull ResolverForProjectImpl<M> resolverForProject, @NotNull ModuleDescriptor module2, @NotNull ModuleContent<? extends M> moduleContent, @NotNull PackageOracle packageOracle) {
        Collection<FqName> collection;
        void $receiver$iv$iv;
        void $receiver$iv;
        Intrinsics.checkParameterIsNotNull(resolverForProject, "resolverForProject");
        Intrinsics.checkParameterIsNotNull(module2, "module");
        Intrinsics.checkParameterIsNotNull(moduleContent, "moduleContent");
        Intrinsics.checkParameterIsNotNull(packageOracle, "packageOracle");
        this.resolverForProject = resolverForProject;
        this.module = module2;
        this.packageOracle = packageOracle;
        Iterable iterable = moduleContent.getSyntheticFiles();
        DelegatingPackageFragmentProvider delegatingPackageFragmentProvider = this;
        void var6_7 = $receiver$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($receiver$iv, 10));
        for (Object item$iv$iv : $receiver$iv$iv) {
            void it;
            KtFile ktFile = (KtFile)item$iv$iv;
            collection = destination$iv$iv;
            FqName fqName2 = it.getPackageFqName();
            collection.add(fqName2);
        }
        collection = (List)destination$iv$iv;
        delegatingPackageFragmentProvider.syntheticFilePackages = CollectionsKt.toSet((Iterable)collection);
    }
}

