/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.cli.common.repl;

import com.google.common.base.Throwables;
import java.io.File;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.cli.common.repl.ReplCodeLine;
import org.jetbrains.kotlin.cli.common.repl.ReplUtilKt;

@Metadata(mv={1, 1, 10}, bv={1, 0, 2}, k=2, d1={"\u00006\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0003\n\u0002\b\u0002\n\u0002\u0010 \n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u001a\u000e\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u0003\u001a\u0016\u0010\u0004\u001a\u00020\u00012\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u0001\u001a*\u0010\b\u001a\b\u0012\u0004\u0012\u0002H\n0\t\"\b\b\u0000\u0010\n*\u00020\u000b*\b\u0012\u0004\u0012\u0002H\n0\t2\u0006\u0010\f\u001a\u00020\u0001H\u0000\u001a\u0012\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000e0\t*\u00020\u000fH\u0000\u001a\u0012\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u000e0\t*\u00020\u0011H\u0000\u00a8\u0006\u0012"}, d2={"makeScriptBaseName", "", "codeLine", "Lorg/jetbrains/kotlin/cli/common/repl/ReplCodeLine;", "renderReplStackTrace", "cause", "", "startFromMethodName", "ensureNotEmpty", "", "T", "", "error", "listAllUrlsAsFiles", "Ljava/io/File;", "Ljava/lang/ClassLoader;", "listLocalUrlsAsFiles", "Ljava/net/URLClassLoader;", "cli-common"})
public final class ReplUtilKt {
    @NotNull
    public static final String makeScriptBaseName(@NotNull ReplCodeLine codeLine) {
        Intrinsics.checkParameterIsNotNull(codeLine, "codeLine");
        return "Line_" + codeLine.getNo() + (codeLine.getGeneration() > 1 ? "_gen_" + codeLine.getGeneration() : "");
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final String renderReplStackTrace(@NotNull Throwable cause, @NotNull String startFromMethodName) {
        void $receiver$iv;
        Intrinsics.checkParameterIsNotNull(cause, "cause");
        Intrinsics.checkParameterIsNotNull(startFromMethodName, "startFromMethodName");
        ArrayList<StackTraceElement> newTrace = new ArrayList<StackTraceElement>();
        boolean skip2 = true;
        StackTraceElement[] stackTraceElementArray = cause.getStackTrace();
        Intrinsics.checkExpressionValueIsNotNull(stackTraceElementArray, "cause.stackTrace");
        for (StackTraceElement element : ArraysKt.reversed(stackTraceElementArray)) {
            StringBuilder stringBuilder = new StringBuilder();
            StackTraceElement stackTraceElement = element;
            Intrinsics.checkExpressionValueIsNotNull(stackTraceElement, "element");
            if (Intrinsics.areEqual(stringBuilder.append(stackTraceElement.getClassName()).append('.').append(element.getMethodName()).toString(), startFromMethodName)) {
                skip2 = false;
            }
            if (skip2) continue;
            newTrace.add(element);
        }
        List resultingTrace = CollectionsKt.dropLast(CollectionsKt.reversed((Iterable)newTrace), 1);
        Object object = resultingTrace;
        Throwable throwable = cause;
        void v3 = $receiver$iv;
        if (v3 == null) {
            throw new TypeCastException("null cannot be cast to non-null type java.util.Collection<T>");
        }
        void thisCollection$iv = v3;
        StackTraceElement[] stackTraceElementArray2 = thisCollection$iv.toArray(new StackTraceElement[0]);
        if (stackTraceElementArray2 == null) {
            throw new TypeCastException("null cannot be cast to non-null type kotlin.Array<T>");
        }
        StackTraceElement[] stackTraceElementArray3 = stackTraceElementArray2;
        throwable.setStackTrace(stackTraceElementArray3);
        String string = Throwables.getStackTraceAsString(cause);
        Intrinsics.checkExpressionValueIsNotNull(string, "Throwables.getStackTraceAsString(cause)");
        Object object2 = object = string;
        if (object2 == null) {
            throw new TypeCastException("null cannot be cast to non-null type kotlin.CharSequence");
        }
        return ((Object)StringsKt.trimEnd((CharSequence)object2)).toString();
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final List<File> listAllUrlsAsFiles(@NotNull ClassLoader $receiver) {
        void $receiver$iv;
        List initial$iv;
        Sequence<URLClassLoader> parents2;
        Intrinsics.checkParameterIsNotNull($receiver, "$receiver");
        Sequence<URLClassLoader> sequence2 = parents2 = SequencesKt.filterIsInstance(SequencesKt.generateSequence($receiver, (Function1)listAllUrlsAsFiles.parents.1.INSTANCE), URLClassLoader.class);
        List accumulator$iv = initial$iv = CollectionsKt.emptyList();
        for (Object element$iv : $receiver$iv) {
            void loader;
            URLClassLoader uRLClassLoader = (URLClassLoader)element$iv;
            List accum = accumulator$iv;
            accumulator$iv = CollectionsKt.plus((Collection)ReplUtilKt.listLocalUrlsAsFiles((URLClassLoader)loader), (Iterable)accum);
        }
        return CollectionsKt.distinct(accumulator$iv);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final List<File> listLocalUrlsAsFiles(@NotNull URLClassLoader $receiver) {
        void var3_3;
        Object $receiver$iv$iv;
        Intrinsics.checkParameterIsNotNull($receiver, "$receiver");
        URL[] uRLArray = $receiver.getURLs();
        Intrinsics.checkExpressionValueIsNotNull(uRLArray, "this.urLs");
        Object $receiver$iv = uRLArray;
        URL[] uRLArray2 = $receiver$iv;
        Collection destination$iv$iv = new ArrayList();
        void $receiver$iv$iv$iv = $receiver$iv$iv;
        int n = ((void)$receiver$iv$iv$iv).length;
        for (int i = 0; i < n; ++i) {
            String string;
            void element$iv$iv$iv;
            void element$iv$iv;
            void it = element$iv$iv = (element$iv$iv$iv = $receiver$iv$iv$iv[i]);
            String string2 = it.toString();
            Intrinsics.checkExpressionValueIsNotNull(string2, "it.toString()");
            if (StringsKt.removePrefix(string2, (CharSequence)"file:") == null) continue;
            String it$iv$iv = string;
            destination$iv$iv.add(it$iv$iv);
        }
        $receiver$iv = (List)destination$iv$iv;
        $receiver$iv$iv = $receiver$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($receiver$iv, 10));
        Iterator iterator2 = $receiver$iv$iv.iterator();
        while (iterator2.hasNext()) {
            void p1;
            Object item$iv$iv = iterator2.next();
            String string = (String)item$iv$iv;
            Collection collection = destination$iv$iv;
            File file2 = new File((String)p1);
            collection.add(file2);
        }
        return (List)var3_3;
    }

    @NotNull
    public static final <T> List<T> ensureNotEmpty(@NotNull List<? extends T> $receiver, @NotNull String error) {
        Intrinsics.checkParameterIsNotNull($receiver, "$receiver");
        Intrinsics.checkParameterIsNotNull(error, "error");
        if ($receiver.isEmpty()) {
            throw (Throwable)new IllegalStateException(error);
        }
        return $receiver;
    }
}

