/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util;

import com.intellij.util.ArrayFactory;
import com.intellij.util.ArrayUtilRt;
import com.intellij.util.text.CharArrayCharSequence;
import gnu.trove.Equality;
import java.io.File;
import java.lang.reflect.Array;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ArrayUtil
extends ArrayUtilRt {
    public static final short[] EMPTY_SHORT_ARRAY = ArrayUtilRt.EMPTY_SHORT_ARRAY;
    public static final char[] EMPTY_CHAR_ARRAY = ArrayUtilRt.EMPTY_CHAR_ARRAY;
    public static final byte[] EMPTY_BYTE_ARRAY = ArrayUtilRt.EMPTY_BYTE_ARRAY;
    public static final int[] EMPTY_INT_ARRAY = ArrayUtilRt.EMPTY_INT_ARRAY;
    public static final boolean[] EMPTY_BOOLEAN_ARRAY = ArrayUtilRt.EMPTY_BOOLEAN_ARRAY;
    public static final Object[] EMPTY_OBJECT_ARRAY = ArrayUtilRt.EMPTY_OBJECT_ARRAY;
    public static final String[] EMPTY_STRING_ARRAY = ArrayUtilRt.EMPTY_STRING_ARRAY;
    public static final Class[] EMPTY_CLASS_ARRAY = ArrayUtilRt.EMPTY_CLASS_ARRAY;
    public static final long[] EMPTY_LONG_ARRAY = ArrayUtilRt.EMPTY_LONG_ARRAY;
    public static final Collection[] EMPTY_COLLECTION_ARRAY = ArrayUtilRt.EMPTY_COLLECTION_ARRAY;
    public static final File[] EMPTY_FILE_ARRAY = ArrayUtilRt.EMPTY_FILE_ARRAY;
    public static final Runnable[] EMPTY_RUNNABLE_ARRAY = ArrayUtilRt.EMPTY_RUNNABLE_ARRAY;
    public static final CharSequence EMPTY_CHAR_SEQUENCE = new CharArrayCharSequence(EMPTY_CHAR_ARRAY);
    public static final ArrayFactory<String> STRING_ARRAY_FACTORY = new ArrayFactory<String>(){

        @NotNull
        public String[] create(int count2) {
            String[] stringArray = ArrayUtil.newStringArray(count2);
            if (stringArray == null) {
                1.$$$reportNull$$$0(0);
            }
            return stringArray;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/ArrayUtil$1", "create"));
        }
    };
    public static final ArrayFactory<Object> OBJECT_ARRAY_FACTORY = new ArrayFactory<Object>(){

        @Override
        @NotNull
        public Object[] create(int count2) {
            Object[] objectArray = ArrayUtil.newObjectArray(count2);
            if (objectArray == null) {
                2.$$$reportNull$$$0(0);
            }
            return objectArray;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/ArrayUtil$2", "create"));
        }
    };

    private ArrayUtil() {
    }

    @NotNull
    @Contract(pure=true)
    public static boolean[] realloc(@NotNull boolean[] array, int newSize) {
        if (array == null) {
            ArrayUtil.$$$reportNull$$$0(4);
        }
        if (newSize == 0) {
            if (EMPTY_BOOLEAN_ARRAY == null) {
                ArrayUtil.$$$reportNull$$$0(5);
            }
            return EMPTY_BOOLEAN_ARRAY;
        }
        int oldSize = array.length;
        if (oldSize == newSize) {
            if (array == null) {
                ArrayUtil.$$$reportNull$$$0(6);
            }
            return array;
        }
        boolean[] result2 = new boolean[newSize];
        System.arraycopy(array, 0, result2, 0, Math.min(oldSize, newSize));
        if (result2 == null) {
            ArrayUtil.$$$reportNull$$$0(7);
        }
        return result2;
    }

    @NotNull
    @Contract(pure=true)
    public static int[] realloc(@NotNull int[] array, int newSize) {
        if (array == null) {
            ArrayUtil.$$$reportNull$$$0(12);
        }
        if (newSize == 0) {
            if (EMPTY_INT_ARRAY == null) {
                ArrayUtil.$$$reportNull$$$0(13);
            }
            return EMPTY_INT_ARRAY;
        }
        int oldSize = array.length;
        if (oldSize == newSize) {
            if (array == null) {
                ArrayUtil.$$$reportNull$$$0(14);
            }
            return array;
        }
        int[] result2 = new int[newSize];
        System.arraycopy(array, 0, result2, 0, Math.min(oldSize, newSize));
        if (result2 == null) {
            ArrayUtil.$$$reportNull$$$0(15);
        }
        return result2;
    }

    @NotNull
    @Contract(pure=true)
    public static <T> T[] realloc(@NotNull T[] array, int newSize, @NotNull ArrayFactory<T> factory2) {
        int oldSize;
        if (array == null) {
            ArrayUtil.$$$reportNull$$$0(16);
        }
        if (factory2 == null) {
            ArrayUtil.$$$reportNull$$$0(17);
        }
        if ((oldSize = array.length) == newSize) {
            if (array == null) {
                ArrayUtil.$$$reportNull$$$0(18);
            }
            return array;
        }
        T[] result2 = factory2.create(newSize);
        if (newSize == 0) {
            if (result2 == null) {
                ArrayUtil.$$$reportNull$$$0(19);
            }
            return result2;
        }
        System.arraycopy(array, 0, result2, 0, Math.min(oldSize, newSize));
        if (result2 == null) {
            ArrayUtil.$$$reportNull$$$0(20);
        }
        return result2;
    }

    @NotNull
    @Contract(pure=true)
    public static int[] append(@NotNull int[] array, int value) {
        if (array == null) {
            ArrayUtil.$$$reportNull$$$0(23);
        }
        array = ArrayUtil.realloc(array, array.length + 1);
        array[array.length - 1] = value;
        if (array == null) {
            ArrayUtil.$$$reportNull$$$0(24);
        }
        return array;
    }

    @NotNull
    @Contract(pure=true)
    public static <T> T[] insert(@NotNull T[] array, int index2, T value) {
        if (array == null) {
            ArrayUtil.$$$reportNull$$$0(25);
        }
        T[] result2 = ArrayUtil.createArray(array.getClass().getComponentType(), array.length + 1);
        System.arraycopy(array, 0, result2, 0, index2);
        result2[index2] = value;
        System.arraycopy(array, index2, result2, index2 + 1, array.length - index2);
        if (result2 == null) {
            ArrayUtil.$$$reportNull$$$0(26);
        }
        return result2;
    }

    @NotNull
    @Contract(pure=true)
    public static int[] insert(@NotNull int[] array, int index2, int value) {
        if (array == null) {
            ArrayUtil.$$$reportNull$$$0(27);
        }
        int[] result2 = new int[array.length + 1];
        System.arraycopy(array, 0, result2, 0, index2);
        result2[index2] = value;
        System.arraycopy(array, index2, result2, index2 + 1, array.length - index2);
        if (result2 == null) {
            ArrayUtil.$$$reportNull$$$0(28);
        }
        return result2;
    }

    @NotNull
    @Contract(pure=true)
    public static <T> T[] toObjectArray(@NotNull Collection<? extends T> collection, @NotNull Class<T> aClass2) {
        if (collection == null) {
            ArrayUtil.$$$reportNull$$$0(37);
        }
        if (aClass2 == null) {
            ArrayUtil.$$$reportNull$$$0(38);
        }
        T[] array = ArrayUtil.createArray(aClass2, collection.size());
        T[] TArray = collection.toArray(array);
        if (TArray == null) {
            ArrayUtil.$$$reportNull$$$0(39);
        }
        return TArray;
    }

    @NotNull
    @Contract(pure=true)
    public static Object[] toObjectArray(@NotNull Collection<?> collection) {
        if (collection == null) {
            ArrayUtil.$$$reportNull$$$0(43);
        }
        Object[] objectArray = collection.toArray(EMPTY_OBJECT_ARRAY);
        if (objectArray == null) {
            ArrayUtil.$$$reportNull$$$0(44);
        }
        return objectArray;
    }

    @NotNull
    @Contract(pure=true)
    public static <T> T[] mergeArrays(@NotNull T[] a1, @NotNull T[] a2) {
        Class<?> class2;
        if (a1 == null) {
            ArrayUtil.$$$reportNull$$$0(47);
        }
        if (a2 == null) {
            ArrayUtil.$$$reportNull$$$0(48);
        }
        if (a1.length == 0) {
            if (a2 == null) {
                ArrayUtil.$$$reportNull$$$0(49);
            }
            return a2;
        }
        if (a2.length == 0) {
            if (a1 == null) {
                ArrayUtil.$$$reportNull$$$0(50);
            }
            return a1;
        }
        Class<?> class1 = a1.getClass().getComponentType();
        Class<?> aClass2 = class1.isAssignableFrom(class2 = a2.getClass().getComponentType()) ? class1 : class2;
        T[] result2 = ArrayUtil.createArray(aClass2, a1.length + a2.length);
        System.arraycopy(a1, 0, result2, 0, a1.length);
        System.arraycopy(a2, 0, result2, a1.length, a2.length);
        if (result2 == null) {
            ArrayUtil.$$$reportNull$$$0(51);
        }
        return result2;
    }

    @NotNull
    @Contract(pure=true)
    public static <T> T[] mergeCollections(@NotNull Collection<? extends T> c1, @NotNull Collection<? extends T> c2, @NotNull ArrayFactory<T> factory2) {
        if (c1 == null) {
            ArrayUtil.$$$reportNull$$$0(52);
        }
        if (c2 == null) {
            ArrayUtil.$$$reportNull$$$0(53);
        }
        if (factory2 == null) {
            ArrayUtil.$$$reportNull$$$0(54);
        }
        T[] res2 = factory2.create(c1.size() + c2.size());
        int i = 0;
        for (T t : c1) {
            res2[i++] = t;
        }
        for (T t : c2) {
            res2[i++] = t;
        }
        if (res2 == null) {
            ArrayUtil.$$$reportNull$$$0(55);
        }
        return res2;
    }

    @NotNull
    @Contract(pure=true)
    public static <T> T[] mergeArrayAndCollection(@NotNull T[] array, @NotNull Collection<T> collection, @NotNull ArrayFactory<T> factory2) {
        T[] array2;
        if (array == null) {
            ArrayUtil.$$$reportNull$$$0(75);
        }
        if (collection == null) {
            ArrayUtil.$$$reportNull$$$0(76);
        }
        if (factory2 == null) {
            ArrayUtil.$$$reportNull$$$0(77);
        }
        if (collection.isEmpty()) {
            if (array == null) {
                ArrayUtil.$$$reportNull$$$0(78);
            }
            return array;
        }
        try {
            array2 = collection.toArray(factory2.create(collection.size()));
        }
        catch (ArrayStoreException e) {
            throw new RuntimeException("Bad elements in collection: " + collection, e);
        }
        if (array.length == 0) {
            if (array2 == null) {
                ArrayUtil.$$$reportNull$$$0(79);
            }
            return array2;
        }
        T[] result2 = factory2.create(array.length + collection.size());
        System.arraycopy(array, 0, result2, 0, array.length);
        System.arraycopy(array2, 0, result2, array.length, array2.length);
        if (result2 == null) {
            ArrayUtil.$$$reportNull$$$0(80);
        }
        return result2;
    }

    @NotNull
    @Contract(pure=true)
    public static <T> T[] append(@NotNull T[] src, @Nullable T element) {
        if (src == null) {
            ArrayUtil.$$$reportNull$$$0(81);
        }
        T[] TArray = ArrayUtil.append(src, element, src.getClass().getComponentType());
        if (TArray == null) {
            ArrayUtil.$$$reportNull$$$0(82);
        }
        return TArray;
    }

    @NotNull
    @Contract(pure=true)
    public static <T> T[] prepend(T element, @NotNull T[] array) {
        if (array == null) {
            ArrayUtil.$$$reportNull$$$0(83);
        }
        T[] TArray = ArrayUtil.prepend(element, array, array.getClass().getComponentType());
        if (TArray == null) {
            ArrayUtil.$$$reportNull$$$0(84);
        }
        return TArray;
    }

    @NotNull
    @Contract(pure=true)
    public static <T> T[] prepend(T element, @NotNull T[] array, @NotNull Class<T> type2) {
        if (array == null) {
            ArrayUtil.$$$reportNull$$$0(85);
        }
        if (type2 == null) {
            ArrayUtil.$$$reportNull$$$0(86);
        }
        int length = array.length;
        T[] result2 = ArrayUtil.createArray(type2, length + 1);
        System.arraycopy(array, 0, result2, 1, length);
        result2[0] = element;
        if (result2 == null) {
            ArrayUtil.$$$reportNull$$$0(87);
        }
        return result2;
    }

    @NotNull
    @Contract(pure=true)
    public static <T> T[] append(@NotNull T[] src, T element, @NotNull ArrayFactory<T> factory2) {
        if (src == null) {
            ArrayUtil.$$$reportNull$$$0(93);
        }
        if (factory2 == null) {
            ArrayUtil.$$$reportNull$$$0(94);
        }
        int length = src.length;
        T[] result2 = factory2.create(length + 1);
        System.arraycopy(src, 0, result2, 0, length);
        result2[length] = element;
        if (result2 == null) {
            ArrayUtil.$$$reportNull$$$0(95);
        }
        return result2;
    }

    @NotNull
    @Contract(pure=true)
    public static <T> T[] append(@NotNull T[] src, @Nullable T element, @NotNull Class<T> componentType) {
        if (src == null) {
            ArrayUtil.$$$reportNull$$$0(96);
        }
        if (componentType == null) {
            ArrayUtil.$$$reportNull$$$0(97);
        }
        int length = src.length;
        T[] result2 = ArrayUtil.createArray(componentType, length + 1);
        System.arraycopy(src, 0, result2, 0, length);
        result2[length] = element;
        if (result2 == null) {
            ArrayUtil.$$$reportNull$$$0(98);
        }
        return result2;
    }

    @NotNull
    private static <T> T[] createArray(@NotNull Class<?> type2, int length) {
        if (type2 == null) {
            ArrayUtil.$$$reportNull$$$0(101);
        }
        Object[] objectArray = (Object[])Array.newInstance(type2, length);
        if (objectArray == null) {
            ArrayUtil.$$$reportNull$$$0(102);
        }
        return objectArray;
    }

    @NotNull
    @Contract(pure=true)
    public static <T> T[] remove(@NotNull T[] src, int idx, @NotNull ArrayFactory<T> factory2) {
        if (src == null) {
            ArrayUtil.$$$reportNull$$$0(103);
        }
        if (factory2 == null) {
            ArrayUtil.$$$reportNull$$$0(104);
        }
        int length = src.length;
        if (idx < 0 || idx >= length) {
            throw new IllegalArgumentException("invalid index: " + idx);
        }
        T[] result2 = factory2.create(length - 1);
        System.arraycopy(src, 0, result2, 0, idx);
        System.arraycopy(src, idx + 1, result2, idx, length - idx - 1);
        if (result2 == null) {
            ArrayUtil.$$$reportNull$$$0(105);
        }
        return result2;
    }

    @NotNull
    @Contract(pure=true)
    public static <T> T[] remove(@NotNull T[] src, T element, @NotNull ArrayFactory<T> factory2) {
        int idx;
        if (src == null) {
            ArrayUtil.$$$reportNull$$$0(109);
        }
        if (factory2 == null) {
            ArrayUtil.$$$reportNull$$$0(110);
        }
        if ((idx = ArrayUtil.find(src, element)) == -1) {
            if (src == null) {
                ArrayUtil.$$$reportNull$$$0(111);
            }
            return src;
        }
        int[] nArray = ArrayUtil.remove(src, idx, factory2);
        if (nArray == null) {
            ArrayUtil.$$$reportNull$$$0(112);
        }
        return nArray;
    }

    @NotNull
    @Contract(pure=true)
    public static int[] remove(@NotNull int[] src, int idx) {
        if (src == null) {
            ArrayUtil.$$$reportNull$$$0(113);
        }
        int length = src.length;
        if (idx < 0 || idx >= length) {
            throw new IllegalArgumentException("invalid index: " + idx);
        }
        int[] result2 = ArrayUtil.newIntArray(src.length - 1);
        System.arraycopy(src, 0, result2, 0, idx);
        System.arraycopy(src, idx + 1, result2, idx, length - idx - 1);
        if (result2 == null) {
            ArrayUtil.$$$reportNull$$$0(114);
        }
        return result2;
    }

    @Contract(pure=true)
    public static <T> int find(@NotNull T[] src, T obj) {
        if (src == null) {
            ArrayUtil.$$$reportNull$$$0(118);
        }
        return ArrayUtilRt.find(src, obj);
    }

    @Contract(pure=true)
    public static boolean startsWith(@NotNull byte[] array, @NotNull byte[] prefix) {
        if (array == null) {
            ArrayUtil.$$$reportNull$$$0(119);
        }
        if (prefix == null) {
            ArrayUtil.$$$reportNull$$$0(120);
        }
        if (array == prefix) {
            return true;
        }
        int length = prefix.length;
        if (array.length < length) {
            return false;
        }
        for (int i = 0; i < length; ++i) {
            if (array[i] == prefix[i]) continue;
            return false;
        }
        return true;
    }

    @Contract(pure=true)
    public static int indexOf(@NotNull Object[] objects, @Nullable Object object) {
        if (objects == null) {
            ArrayUtil.$$$reportNull$$$0(145);
        }
        return ArrayUtil.indexOf(objects, object, 0, objects.length);
    }

    @Contract(pure=true)
    public static int indexOf(@NotNull Object[] objects, Object object, int start, int end) {
        if (objects == null) {
            ArrayUtil.$$$reportNull$$$0(146);
        }
        if (object == null) {
            for (int i = start; i < end; ++i) {
                if (objects[i] != null) continue;
                return i;
            }
        } else {
            for (int i = start; i < end; ++i) {
                if (!object.equals(objects[i])) continue;
                return i;
            }
        }
        return -1;
    }

    @Contract(pure=true)
    public static <T> int indexOf(@NotNull List<T> objects, T object, @NotNull Equality<T> comparator) {
        if (objects == null) {
            ArrayUtil.$$$reportNull$$$0(147);
        }
        if (comparator == null) {
            ArrayUtil.$$$reportNull$$$0(148);
        }
        for (int i = 0; i < objects.size(); ++i) {
            if (!comparator.equals(objects.get(i), object)) continue;
            return i;
        }
        return -1;
    }

    @Contract(pure=true)
    public static int indexOf(@NotNull int[] ints, int value) {
        if (ints == null) {
            ArrayUtil.$$$reportNull$$$0(154);
        }
        for (int i = 0; i < ints.length; ++i) {
            if (ints[i] != value) continue;
            return i;
        }
        return -1;
    }

    @Contract(pure=true)
    public static int indexOf(@NotNull byte[] ints, byte value, int start, int end) {
        if (ints == null) {
            ArrayUtil.$$$reportNull$$$0(156);
        }
        for (int i = start; i < end; ++i) {
            if (ints[i] != value) continue;
            return i;
        }
        return -1;
    }

    @Contract(pure=true)
    public static <T> int lastIndexOf(@NotNull List<T> src, T obj, @NotNull Equality<? super T> comparator) {
        if (src == null) {
            ArrayUtil.$$$reportNull$$$0(161);
        }
        if (comparator == null) {
            ArrayUtil.$$$reportNull$$$0(162);
        }
        for (int i = src.size() - 1; i >= 0; --i) {
            T o = src.get(i);
            if (!comparator.equals(obj, o)) continue;
            return i;
        }
        return -1;
    }

    @Contract(pure=true)
    public static <T> boolean contains(@Nullable T o, T ... objects) {
        if (objects == null) {
            ArrayUtil.$$$reportNull$$$0(163);
        }
        return ArrayUtil.indexOf(objects, o) >= 0;
    }

    @Contract(pure=true)
    public static boolean contains(@Nullable String s, String ... strings) {
        if (strings == null) {
            ArrayUtil.$$$reportNull$$$0(164);
        }
        if (s == null) {
            for (String str : strings) {
                if (str != null) continue;
                return true;
            }
        } else {
            for (String str : strings) {
                if (!s.equals(str)) continue;
                return true;
            }
        }
        return false;
    }

    @NotNull
    @Contract(pure=true)
    public static int[] newIntArray(int count2) {
        int[] nArray = count2 == 0 ? EMPTY_INT_ARRAY : new int[count2];
        if (nArray == null) {
            ArrayUtil.$$$reportNull$$$0(165);
        }
        return nArray;
    }

    @NotNull
    @Contract(pure=true)
    public static String[] newStringArray(int count2) {
        String[] stringArray = count2 == 0 ? EMPTY_STRING_ARRAY : new String[count2];
        if (stringArray == null) {
            ArrayUtil.$$$reportNull$$$0(167);
        }
        return stringArray;
    }

    @NotNull
    @Contract(pure=true)
    public static Object[] newObjectArray(int count2) {
        Object[] objectArray = count2 == 0 ? EMPTY_OBJECT_ARRAY : new Object[count2];
        if (objectArray == null) {
            ArrayUtil.$$$reportNull$$$0(168);
        }
        return objectArray;
    }

    @NotNull
    @Contract(pure=true)
    public static <E> E[] ensureExactSize(int count2, @NotNull E[] sample) {
        if (sample == null) {
            ArrayUtil.$$$reportNull$$$0(169);
        }
        if (count2 == sample.length) {
            if (sample == null) {
                ArrayUtil.$$$reportNull$$$0(170);
            }
            return sample;
        }
        T[] array = ArrayUtil.createArray(sample.getClass().getComponentType(), count2);
        if (array == null) {
            ArrayUtil.$$$reportNull$$$0(171);
        }
        return array;
    }

    @Nullable
    @Contract(value="null -> null", pure=true)
    public static <T> T getLastElement(@Nullable T[] array) {
        return array != null && array.length > 0 ? (T)array[array.length - 1] : null;
    }

    @NotNull
    @Contract(pure=true)
    public static String[] toStringArray(@Nullable Collection<String> collection) {
        String[] stringArray = ArrayUtilRt.toStringArray(collection);
        if (stringArray == null) {
            ArrayUtil.$$$reportNull$$$0(172);
        }
        return stringArray;
    }

    @Nullable
    @Contract(value="null -> null; !null -> !null")
    public static <T> T[] copyOf(@Nullable T[] original) {
        if (original == null) {
            return null;
        }
        return Arrays.copyOf(original, original.length);
    }

    @Nullable
    @Contract(value="null -> null; !null -> !null")
    public static boolean[] copyOf(@Nullable boolean[] original) {
        if (original == null) {
            return null;
        }
        return Arrays.copyOf(original, original.length);
    }

    @Nullable
    @Contract(value="null -> null; !null -> !null")
    public static int[] copyOf(@Nullable int[] original) {
        if (original == null) {
            return null;
        }
        return Arrays.copyOf(original, original.length);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 5: 
            case 6: 
            case 7: 
            case 9: 
            case 10: 
            case 11: 
            case 13: 
            case 14: 
            case 15: 
            case 18: 
            case 19: 
            case 20: 
            case 22: 
            case 24: 
            case 26: 
            case 28: 
            case 30: 
            case 32: 
            case 34: 
            case 35: 
            case 36: 
            case 39: 
            case 42: 
            case 44: 
            case 46: 
            case 49: 
            case 50: 
            case 51: 
            case 55: 
            case 59: 
            case 60: 
            case 61: 
            case 64: 
            case 67: 
            case 68: 
            case 69: 
            case 72: 
            case 73: 
            case 74: 
            case 78: 
            case 79: 
            case 80: 
            case 82: 
            case 84: 
            case 87: 
            case 90: 
            case 92: 
            case 95: 
            case 98: 
            case 100: 
            case 102: 
            case 105: 
            case 107: 
            case 108: 
            case 111: 
            case 112: 
            case 114: 
            case 116: 
            case 132: 
            case 134: 
            case 165: 
            case 166: 
            case 167: 
            case 168: 
            case 170: 
            case 171: 
            case 172: 
            case 176: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 5: 
            case 6: 
            case 7: 
            case 9: 
            case 10: 
            case 11: 
            case 13: 
            case 14: 
            case 15: 
            case 18: 
            case 19: 
            case 20: 
            case 22: 
            case 24: 
            case 26: 
            case 28: 
            case 30: 
            case 32: 
            case 34: 
            case 35: 
            case 36: 
            case 39: 
            case 42: 
            case 44: 
            case 46: 
            case 49: 
            case 50: 
            case 51: 
            case 55: 
            case 59: 
            case 60: 
            case 61: 
            case 64: 
            case 67: 
            case 68: 
            case 69: 
            case 72: 
            case 73: 
            case 74: 
            case 78: 
            case 79: 
            case 80: 
            case 82: 
            case 84: 
            case 87: 
            case 90: 
            case 92: 
            case 95: 
            case 98: 
            case 100: 
            case 102: 
            case 105: 
            case 107: 
            case 108: 
            case 111: 
            case 112: 
            case 114: 
            case 116: 
            case 132: 
            case 134: 
            case 165: 
            case 166: 
            case 167: 
            case 168: 
            case 170: 
            case 171: 
            case 172: 
            case 176: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "array";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 5: 
            case 6: 
            case 7: 
            case 9: 
            case 10: 
            case 11: 
            case 13: 
            case 14: 
            case 15: 
            case 18: 
            case 19: 
            case 20: 
            case 22: 
            case 24: 
            case 26: 
            case 28: 
            case 30: 
            case 32: 
            case 34: 
            case 35: 
            case 36: 
            case 39: 
            case 42: 
            case 44: 
            case 46: 
            case 49: 
            case 50: 
            case 51: 
            case 55: 
            case 59: 
            case 60: 
            case 61: 
            case 64: 
            case 67: 
            case 68: 
            case 69: 
            case 72: 
            case 73: 
            case 74: 
            case 78: 
            case 79: 
            case 80: 
            case 82: 
            case 84: 
            case 87: 
            case 90: 
            case 92: 
            case 95: 
            case 98: 
            case 100: 
            case 102: 
            case 105: 
            case 107: 
            case 108: 
            case 111: 
            case 112: 
            case 114: 
            case 116: 
            case 132: 
            case 134: 
            case 165: 
            case 166: 
            case 167: 
            case 168: 
            case 170: 
            case 171: 
            case 172: 
            case 176: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/util/ArrayUtil";
                break;
            }
            case 17: 
            case 54: 
            case 58: 
            case 77: 
            case 89: 
            case 94: 
            case 104: 
            case 110: {
                objectArray2 = objectArray3;
                objectArray3[0] = "factory";
                break;
            }
            case 37: 
            case 43: 
            case 76: {
                objectArray2 = objectArray3;
                objectArray3[0] = "collection";
                break;
            }
            case 38: 
            case 40: {
                objectArray2 = objectArray3;
                objectArray3[0] = "aClass";
                break;
            }
            case 41: {
                objectArray2 = objectArray3;
                objectArray3[0] = "source";
                break;
            }
            case 45: {
                objectArray2 = objectArray3;
                objectArray3[0] = "list";
                break;
            }
            case 47: 
            case 56: 
            case 62: 
            case 65: 
            case 70: 
            case 125: 
            case 128: {
                objectArray2 = objectArray3;
                objectArray3[0] = "a1";
                break;
            }
            case 48: 
            case 57: 
            case 63: 
            case 66: 
            case 71: 
            case 126: 
            case 129: {
                objectArray2 = objectArray3;
                objectArray3[0] = "a2";
                break;
            }
            case 52: {
                objectArray2 = objectArray3;
                objectArray3[0] = "c1";
                break;
            }
            case 53: {
                objectArray2 = objectArray3;
                objectArray3[0] = "c2";
                break;
            }
            case 81: 
            case 88: 
            case 93: 
            case 96: 
            case 99: 
            case 103: 
            case 106: 
            case 109: 
            case 113: 
            case 115: 
            case 117: 
            case 118: 
            case 157: 
            case 158: 
            case 159: 
            case 161: 
            case 173: {
                objectArray2 = objectArray3;
                objectArray3[0] = "src";
                break;
            }
            case 86: 
            case 101: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 97: {
                objectArray2 = objectArray3;
                objectArray3[0] = "componentType";
                break;
            }
            case 120: {
                objectArray2 = objectArray3;
                objectArray3[0] = "prefix";
                break;
            }
            case 122: 
            case 124: {
                objectArray2 = objectArray3;
                objectArray3[0] = "subArray";
                break;
            }
            case 127: 
            case 130: 
            case 148: 
            case 150: 
            case 152: 
            case 160: 
            case 162: {
                objectArray2 = objectArray3;
                objectArray3[0] = "comparator";
                break;
            }
            case 135: 
            case 137: {
                objectArray2 = objectArray3;
                objectArray3[0] = "obj1";
                break;
            }
            case 136: 
            case 138: {
                objectArray2 = objectArray3;
                objectArray3[0] = "obj2";
                break;
            }
            case 145: 
            case 146: 
            case 147: 
            case 149: 
            case 151: 
            case 163: {
                objectArray2 = objectArray3;
                objectArray3[0] = "objects";
                break;
            }
            case 153: 
            case 154: 
            case 155: 
            case 156: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ints";
                break;
            }
            case 164: {
                objectArray2 = objectArray3;
                objectArray3[0] = "strings";
                break;
            }
            case 169: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sample";
                break;
            }
            case 174: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dst";
                break;
            }
            case 178: 
            case 179: {
                objectArray2 = objectArray3;
                objectArray3[0] = "time";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/util/ArrayUtil";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 5: 
            case 6: 
            case 7: 
            case 9: 
            case 10: 
            case 11: 
            case 13: 
            case 14: 
            case 15: 
            case 18: 
            case 19: 
            case 20: 
            case 34: 
            case 35: 
            case 36: {
                objectArray = objectArray2;
                objectArray2[1] = "realloc";
                break;
            }
            case 22: 
            case 24: 
            case 30: 
            case 32: 
            case 82: 
            case 95: 
            case 98: {
                objectArray = objectArray2;
                objectArray2[1] = "append";
                break;
            }
            case 26: 
            case 28: {
                objectArray = objectArray2;
                objectArray2[1] = "insert";
                break;
            }
            case 39: 
            case 42: 
            case 44: {
                objectArray = objectArray2;
                objectArray2[1] = "toObjectArray";
                break;
            }
            case 46: {
                objectArray = objectArray2;
                objectArray2[1] = "toIntArray";
                break;
            }
            case 49: 
            case 50: 
            case 51: 
            case 59: 
            case 60: 
            case 61: 
            case 64: 
            case 67: 
            case 68: 
            case 69: 
            case 72: 
            case 73: 
            case 74: {
                objectArray = objectArray2;
                objectArray2[1] = "mergeArrays";
                break;
            }
            case 55: {
                objectArray = objectArray2;
                objectArray2[1] = "mergeCollections";
                break;
            }
            case 78: 
            case 79: 
            case 80: {
                objectArray = objectArray2;
                objectArray2[1] = "mergeArrayAndCollection";
                break;
            }
            case 84: 
            case 87: 
            case 90: 
            case 92: {
                objectArray = objectArray2;
                objectArray2[1] = "prepend";
                break;
            }
            case 100: 
            case 105: 
            case 107: 
            case 108: 
            case 111: 
            case 112: 
            case 114: 
            case 116: {
                objectArray = objectArray2;
                objectArray2[1] = "remove";
                break;
            }
            case 102: {
                objectArray = objectArray2;
                objectArray2[1] = "createArray";
                break;
            }
            case 132: 
            case 134: {
                objectArray = objectArray2;
                objectArray2[1] = "reverseArray";
                break;
            }
            case 165: {
                objectArray = objectArray2;
                objectArray2[1] = "newIntArray";
                break;
            }
            case 166: {
                objectArray = objectArray2;
                objectArray2[1] = "newLongArray";
                break;
            }
            case 167: {
                objectArray = objectArray2;
                objectArray2[1] = "newStringArray";
                break;
            }
            case 168: {
                objectArray = objectArray2;
                objectArray2[1] = "newObjectArray";
                break;
            }
            case 170: 
            case 171: {
                objectArray = objectArray2;
                objectArray2[1] = "ensureExactSize";
                break;
            }
            case 172: {
                objectArray = objectArray2;
                objectArray2[1] = "toStringArray";
                break;
            }
            case 176: {
                objectArray = objectArray2;
                objectArray2[1] = "stripTrailingNulls";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "realloc";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 5: 
            case 6: 
            case 7: 
            case 9: 
            case 10: 
            case 11: 
            case 13: 
            case 14: 
            case 15: 
            case 18: 
            case 19: 
            case 20: 
            case 22: 
            case 24: 
            case 26: 
            case 28: 
            case 30: 
            case 32: 
            case 34: 
            case 35: 
            case 36: 
            case 39: 
            case 42: 
            case 44: 
            case 46: 
            case 49: 
            case 50: 
            case 51: 
            case 55: 
            case 59: 
            case 60: 
            case 61: 
            case 64: 
            case 67: 
            case 68: 
            case 69: 
            case 72: 
            case 73: 
            case 74: 
            case 78: 
            case 79: 
            case 80: 
            case 82: 
            case 84: 
            case 87: 
            case 90: 
            case 92: 
            case 95: 
            case 98: 
            case 100: 
            case 102: 
            case 105: 
            case 107: 
            case 108: 
            case 111: 
            case 112: 
            case 114: 
            case 116: 
            case 132: 
            case 134: 
            case 165: 
            case 166: 
            case 167: 
            case 168: 
            case 170: 
            case 171: 
            case 172: 
            case 176: {
                break;
            }
            case 21: 
            case 23: 
            case 29: 
            case 31: 
            case 81: 
            case 93: 
            case 94: 
            case 96: 
            case 97: {
                objectArray = objectArray;
                objectArray[2] = "append";
                break;
            }
            case 25: 
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "insert";
                break;
            }
            case 37: 
            case 38: 
            case 40: 
            case 41: 
            case 43: {
                objectArray = objectArray;
                objectArray[2] = "toObjectArray";
                break;
            }
            case 45: {
                objectArray = objectArray;
                objectArray[2] = "toIntArray";
                break;
            }
            case 47: 
            case 48: 
            case 56: 
            case 57: 
            case 58: 
            case 62: 
            case 63: 
            case 65: 
            case 66: 
            case 70: 
            case 71: {
                objectArray = objectArray;
                objectArray[2] = "mergeArrays";
                break;
            }
            case 52: 
            case 53: 
            case 54: {
                objectArray = objectArray;
                objectArray[2] = "mergeCollections";
                break;
            }
            case 75: 
            case 76: 
            case 77: {
                objectArray = objectArray;
                objectArray[2] = "mergeArrayAndCollection";
                break;
            }
            case 83: 
            case 85: 
            case 86: 
            case 88: 
            case 89: 
            case 91: {
                objectArray = objectArray;
                objectArray[2] = "prepend";
                break;
            }
            case 99: 
            case 103: 
            case 104: 
            case 106: 
            case 109: 
            case 110: 
            case 113: 
            case 115: {
                objectArray = objectArray;
                objectArray[2] = "remove";
                break;
            }
            case 101: {
                objectArray = objectArray;
                objectArray[2] = "createArray";
                break;
            }
            case 117: 
            case 118: {
                objectArray = objectArray;
                objectArray[2] = "find";
                break;
            }
            case 119: 
            case 120: 
            case 121: 
            case 122: 
            case 123: 
            case 124: {
                objectArray = objectArray;
                objectArray[2] = "startsWith";
                break;
            }
            case 125: 
            case 126: 
            case 127: 
            case 128: 
            case 129: 
            case 130: {
                objectArray = objectArray;
                objectArray[2] = "equals";
                break;
            }
            case 131: 
            case 133: {
                objectArray = objectArray;
                objectArray[2] = "reverseArray";
                break;
            }
            case 135: 
            case 136: 
            case 137: 
            case 138: {
                objectArray = objectArray;
                objectArray[2] = "lexicographicCompare";
                break;
            }
            case 139: 
            case 140: 
            case 141: 
            case 142: {
                objectArray = objectArray;
                objectArray[2] = "swap";
                break;
            }
            case 143: {
                objectArray = objectArray;
                objectArray[2] = "rotateLeft";
                break;
            }
            case 144: {
                objectArray = objectArray;
                objectArray[2] = "rotateRight";
                break;
            }
            case 145: 
            case 146: 
            case 147: 
            case 148: 
            case 149: 
            case 150: 
            case 151: 
            case 152: 
            case 153: 
            case 154: 
            case 155: 
            case 156: {
                objectArray = objectArray;
                objectArray[2] = "indexOf";
                break;
            }
            case 157: 
            case 158: 
            case 159: 
            case 160: 
            case 161: 
            case 162: {
                objectArray = objectArray;
                objectArray[2] = "lastIndexOf";
                break;
            }
            case 163: 
            case 164: {
                objectArray = objectArray;
                objectArray[2] = "contains";
                break;
            }
            case 169: {
                objectArray = objectArray;
                objectArray[2] = "ensureExactSize";
                break;
            }
            case 173: 
            case 174: {
                objectArray = objectArray;
                objectArray[2] = "copy";
                break;
            }
            case 175: {
                objectArray = objectArray;
                objectArray[2] = "stripTrailingNulls";
                break;
            }
            case 177: {
                objectArray = objectArray;
                objectArray[2] = "trailingNullsIndex";
                break;
            }
            case 178: 
            case 179: {
                objectArray = objectArray;
                objectArray[2] = "averageAmongMedians";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 5: 
            case 6: 
            case 7: 
            case 9: 
            case 10: 
            case 11: 
            case 13: 
            case 14: 
            case 15: 
            case 18: 
            case 19: 
            case 20: 
            case 22: 
            case 24: 
            case 26: 
            case 28: 
            case 30: 
            case 32: 
            case 34: 
            case 35: 
            case 36: 
            case 39: 
            case 42: 
            case 44: 
            case 46: 
            case 49: 
            case 50: 
            case 51: 
            case 55: 
            case 59: 
            case 60: 
            case 61: 
            case 64: 
            case 67: 
            case 68: 
            case 69: 
            case 72: 
            case 73: 
            case 74: 
            case 78: 
            case 79: 
            case 80: 
            case 82: 
            case 84: 
            case 87: 
            case 90: 
            case 92: 
            case 95: 
            case 98: 
            case 100: 
            case 102: 
            case 105: 
            case 107: 
            case 108: 
            case 111: 
            case 112: 
            case 114: 
            case 116: 
            case 132: 
            case 134: 
            case 165: 
            case 166: 
            case 167: 
            case 168: 
            case 170: 
            case 171: 
            case 172: 
            case 176: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

