/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.descriptors;

import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.ClassifierDescriptor;
import org.jetbrains.kotlin.descriptors.FindClassInModuleKt;
import org.jetbrains.kotlin.descriptors.ModuleDescriptor;
import org.jetbrains.kotlin.descriptors.NotFoundClasses;
import org.jetbrains.kotlin.descriptors.PackageViewDescriptor;
import org.jetbrains.kotlin.descriptors.TypeAliasDescriptor;
import org.jetbrains.kotlin.incremental.components.NoLookupLocation;
import org.jetbrains.kotlin.name.ClassId;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.resolve.scopes.MemberScope;

@Metadata(mv={1, 1, 10}, bv={1, 0, 2}, k=2, d1={"\u0000 \n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u001a\u0014\u0010\u0000\u001a\u0004\u0018\u00010\u0001*\u00020\u00022\u0006\u0010\u0003\u001a\u00020\u0004\u001a\u001a\u0010\u0005\u001a\u00020\u0001*\u00020\u00022\u0006\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0006\u001a\u00020\u0007\u001a\u0014\u0010\b\u001a\u0004\u0018\u00010\t*\u00020\u00022\u0006\u0010\u0003\u001a\u00020\u0004\u00a8\u0006\n"}, d2={"findClassAcrossModuleDependencies", "Lorg/jetbrains/kotlin/descriptors/ClassDescriptor;", "Lorg/jetbrains/kotlin/descriptors/ModuleDescriptor;", "classId", "Lorg/jetbrains/kotlin/name/ClassId;", "findNonGenericClassAcrossDependencies", "notFoundClasses", "Lorg/jetbrains/kotlin/descriptors/NotFoundClasses;", "findTypeAliasAcrossModuleDependencies", "Lorg/jetbrains/kotlin/descriptors/TypeAliasDescriptor;", "descriptors"})
public final class FindClassInModuleKt {
    @Nullable
    public static final ClassDescriptor findClassAcrossModuleDependencies(@NotNull ModuleDescriptor $receiver, @NotNull ClassId classId) {
        ClassDescriptor topLevelClass;
        Intrinsics.checkParameterIsNotNull($receiver, "$receiver");
        Intrinsics.checkParameterIsNotNull(classId, "classId");
        FqName fqName2 = classId.getPackageFqName();
        Intrinsics.checkExpressionValueIsNotNull(fqName2, "classId.packageFqName");
        PackageViewDescriptor packageViewDescriptor = $receiver.getPackage(fqName2);
        List<Name> segments = classId.getRelativeClassName().pathSegments();
        MemberScope memberScope2 = packageViewDescriptor.getMemberScope();
        List<Name> list2 = segments;
        Intrinsics.checkExpressionValueIsNotNull(list2, "segments");
        Name name = CollectionsKt.first(list2);
        Intrinsics.checkExpressionValueIsNotNull(name, "segments.first()");
        ClassifierDescriptor classifierDescriptor = memberScope2.getContributedClassifier(name, NoLookupLocation.FROM_DESERIALIZATION);
        if (!(classifierDescriptor instanceof ClassDescriptor)) {
            classifierDescriptor = null;
        }
        ClassDescriptor classDescriptor = (ClassDescriptor)classifierDescriptor;
        if (classDescriptor == null) {
            return null;
        }
        ClassDescriptor result2 = topLevelClass = classDescriptor;
        for (Name name2 : segments.subList(1, segments.size())) {
            MemberScope memberScope3 = result2.getUnsubstitutedInnerClassesScope();
            Name name3 = name2;
            Intrinsics.checkExpressionValueIsNotNull(name3, "name");
            ClassifierDescriptor classifierDescriptor2 = memberScope3.getContributedClassifier(name3, NoLookupLocation.FROM_DESERIALIZATION);
            if (!(classifierDescriptor2 instanceof ClassDescriptor)) {
                classifierDescriptor2 = null;
            }
            if ((ClassDescriptor)classifierDescriptor2 != null) continue;
            return null;
        }
        return result2;
    }

    @NotNull
    public static final ClassDescriptor findNonGenericClassAcrossDependencies(@NotNull ModuleDescriptor $receiver, @NotNull ClassId classId, @NotNull NotFoundClasses notFoundClasses) {
        Intrinsics.checkParameterIsNotNull($receiver, "$receiver");
        Intrinsics.checkParameterIsNotNull(classId, "classId");
        Intrinsics.checkParameterIsNotNull(notFoundClasses, "notFoundClasses");
        ClassDescriptor existingClass = FindClassInModuleKt.findClassAcrossModuleDependencies($receiver, classId);
        if (existingClass != null) {
            return existingClass;
        }
        List<Integer> typeParametersCount2 = SequencesKt.toList(SequencesKt.map(SequencesKt.generateSequence(classId, (Function1)findNonGenericClassAcrossDependencies.typeParametersCount.1.INSTANCE), findNonGenericClassAcrossDependencies.typeParametersCount.2.INSTANCE));
        return notFoundClasses.getClass(classId, typeParametersCount2);
    }

    @Nullable
    public static final TypeAliasDescriptor findTypeAliasAcrossModuleDependencies(@NotNull ModuleDescriptor $receiver, @NotNull ClassId classId) {
        Intrinsics.checkParameterIsNotNull($receiver, "$receiver");
        Intrinsics.checkParameterIsNotNull(classId, "classId");
        FqName fqName2 = classId.getPackageFqName();
        Intrinsics.checkExpressionValueIsNotNull(fqName2, "classId.packageFqName");
        PackageViewDescriptor packageViewDescriptor = $receiver.getPackage(fqName2);
        List<Name> segments = classId.getRelativeClassName().pathSegments();
        int lastNameIndex = segments.size() - 1;
        MemberScope memberScope2 = packageViewDescriptor.getMemberScope();
        List<Name> list2 = segments;
        Intrinsics.checkExpressionValueIsNotNull(list2, "segments");
        Name name = CollectionsKt.first(list2);
        Intrinsics.checkExpressionValueIsNotNull(name, "segments.first()");
        ClassifierDescriptor topLevelClassifier = memberScope2.getContributedClassifier(name, NoLookupLocation.FROM_DESERIALIZATION);
        if (lastNameIndex == 0) {
            ClassifierDescriptor classifierDescriptor = topLevelClassifier;
            if (!(classifierDescriptor instanceof TypeAliasDescriptor)) {
                classifierDescriptor = null;
            }
            return (TypeAliasDescriptor)classifierDescriptor;
        }
        ClassifierDescriptor classifierDescriptor = topLevelClassifier;
        if (!(classifierDescriptor instanceof ClassDescriptor)) {
            classifierDescriptor = null;
        }
        ClassDescriptor classDescriptor = (ClassDescriptor)classifierDescriptor;
        if (classDescriptor == null) {
            return null;
        }
        ClassDescriptor currentClass = classDescriptor;
        for (Name name2 : segments.subList(1, lastNameIndex)) {
            MemberScope memberScope3 = currentClass.getUnsubstitutedInnerClassesScope();
            Name name3 = name2;
            Intrinsics.checkExpressionValueIsNotNull(name3, "name");
            ClassifierDescriptor classifierDescriptor2 = memberScope3.getContributedClassifier(name3, NoLookupLocation.FROM_DESERIALIZATION);
            if (!(classifierDescriptor2 instanceof ClassDescriptor)) {
                classifierDescriptor2 = null;
            }
            if ((ClassDescriptor)classifierDescriptor2 != null) continue;
            return null;
        }
        Name lastName = segments.get(lastNameIndex);
        MemberScope memberScope4 = currentClass.getUnsubstitutedMemberScope();
        Name name4 = lastName;
        Intrinsics.checkExpressionValueIsNotNull(name4, "lastName");
        ClassifierDescriptor classifierDescriptor3 = memberScope4.getContributedClassifier(name4, NoLookupLocation.FROM_DESERIALIZATION);
        if (!(classifierDescriptor3 instanceof TypeAliasDescriptor)) {
            classifierDescriptor3 = null;
        }
        return (TypeAliasDescriptor)classifierDescriptor3;
    }
}

