"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
var rs = require("./parser/jsyaml/resourceRegistry");
var hlimpl = require("./parser/highLevelImpl");
var defs = require("raml-definition-system");
var jsyaml = require("./parser/jsyaml/jsyaml2lowLevel");
var expander = require("./parser/ast.core/expander");
var linter = require("./parser/ast.core/linter");
var builder = require("./parser/ast.core/builder");
var universes = require("./parser/tools/universe");
function hasAsyncRequests() {
    return rs.hasAsyncRequests();
}
exports.hasAsyncRequests = hasAsyncRequests;
function addLoadCallback(x) {
    rs.addLoadCallback(x);
}
exports.addLoadCallback = addLoadCallback;
function getTransformerNames() {
    return expander.getTransformNames();
}
exports.getTransformerNames = getTransformerNames;
exports.updateType = function (node) {
    var type = builder.doDescrimination(node);
    if (type == null && node.property()) {
        type = node.property().range();
    }
    if (type) {
        node.patchType(type);
    }
};
function getFragmentDefenitionName(node) {
    return hlimpl.getFragmentDefenitionName(node);
}
exports.getFragmentDefenitionName = getFragmentDefenitionName;
function genStructuredValue(name, parent, pr) {
    if (defs.ReferenceType.isInstance(pr.range())) {
        var t = pr.range();
        var mockNode = jsyaml.createNode(name);
        return new hlimpl.StructuredValue(mockNode, parent, pr);
    }
    else
        return name;
}
exports.genStructuredValue = genStructuredValue;
function parseUrl(u) {
    return new linter.UrlParameterNameValidator().parseUrl(u);
}
exports.parseUrl = parseUrl;
var UnitLink = /** @class */ (function () {
    function UnitLink(node, targetUnitRoot) {
        this.node = node;
        this.targetUnitRoot = targetUnitRoot;
    }
    return UnitLink;
}());
exports.UnitLink = UnitLink;
var PointOfViewValidationAcceptorImpl = /** @class */ (function () {
    function PointOfViewValidationAcceptorImpl(errors, primaryUnitRoot) {
        this.errors = errors;
        this.primaryUnitRoot = primaryUnitRoot;
    }
    PointOfViewValidationAcceptorImpl.prototype.accept = function (originalIssue) {
        this.transformIssue(originalIssue);
        this.errors.push(originalIssue);
    };
    PointOfViewValidationAcceptorImpl.prototype.transformIssue = function (originalIssue) {
        var _this = this;
        var tailIssueUnit = null;
        var tailIssue = this.findIssueTail(originalIssue);
        if (tailIssue.node) {
            tailIssueUnit = tailIssue.node.lowLevel().unit();
        }
        var primaryUnit = this.primaryUnitRoot.lowLevel().unit();
        if (tailIssueUnit && primaryUnit && tailIssueUnit != primaryUnit) {
            var path = this.findPathToNodeUnit(this.primaryUnitRoot, tailIssue.node);
            if (path && path.length > 0) {
                var errorStack = path.map(function (connectingNode) {
                    return _this.convertConnectingNodeToError(connectingNode, originalIssue);
                });
                if (errorStack && errorStack.length > 0) {
                    var parentIssue = tailIssue;
                    for (var i = errorStack.length - 1; i >= 0; i--) {
                        var currentError = errorStack[i];
                        parentIssue.extras = [];
                        parentIssue.extras.push(currentError);
                        parentIssue = currentError;
                    }
                }
            }
        }
    };
    PointOfViewValidationAcceptorImpl.prototype.begin = function () {
    };
    PointOfViewValidationAcceptorImpl.prototype.end = function () {
    };
    PointOfViewValidationAcceptorImpl.prototype.acceptUnique = function (issue) {
        for (var _i = 0, _a = this.errors; _i < _a.length; _i++) {
            var e = _a[_i];
            if (e.start == issue.start && e.message == issue.message) {
                return;
            }
        }
        this.accept(issue);
    };
    PointOfViewValidationAcceptorImpl.prototype.findPathToNodeUnit = function (primaryUnitRoot, nodeToFindPathTo) {
        if (!nodeToFindPathTo.lowLevel() || !nodeToFindPathTo.lowLevel().unit()) {
            return [];
        }
        return this.findPathToNodeUnitRecursively(primaryUnitRoot, nodeToFindPathTo.lowLevel().unit());
    };
    PointOfViewValidationAcceptorImpl.prototype.findPathToNodeUnitRecursively = function (unitRoot, unitToFindPathTo) {
        var links = this.findUnitLinks(unitRoot);
        for (var i = 0; i < links.length; i++) {
            var currentLink = links[i];
            if (currentLink.targetUnitRoot
                && currentLink.targetUnitRoot.lowLevel()
                && currentLink.targetUnitRoot.lowLevel().unit() == unitToFindPathTo) {
                return [currentLink.node];
            }
            var subLinkResult = this.findPathToNodeUnitRecursively(currentLink.targetUnitRoot, unitToFindPathTo);
            if (subLinkResult) {
                subLinkResult.unshift(currentLink.node);
                return subLinkResult;
            }
        }
        return null;
    };
    PointOfViewValidationAcceptorImpl.prototype.findUnitLinks = function (unitRoot) {
        var result = [];
        result = result.concat(this.findMasterLinks(unitRoot));
        //TODO add more kinds of unit links if we decide to expand this mechanism
        //to automatically build traces for other kinds of dependencies instead of
        //the current mechanisms. In example, for fragments and uses.
        return result;
    };
    PointOfViewValidationAcceptorImpl.prototype.findMasterLinks = function (unitRoot) {
        if (!unitRoot.getMaster)
            return [];
        var master = unitRoot.getMaster();
        if (!master)
            return [];
        var extendsAttr = unitRoot.asElement().attr(universes.Universe10.Extension.properties.extends.name);
        if (!extendsAttr)
            return [];
        if (!extendsAttr.value())
            return [];
        return [new UnitLink(extendsAttr, master)];
    };
    PointOfViewValidationAcceptorImpl.prototype.convertConnectingNodeToError = function (connectingNode, originalIssue) {
        if (!connectingNode)
            return null;
        var llNode = connectingNode.lowLevel();
        var st = llNode.start();
        var et = llNode.end();
        var message = this.generateLinkMessageByNode(connectingNode, originalIssue);
        return {
            code: originalIssue.code,
            isWarning: originalIssue.isWarning,
            message: message,
            node: connectingNode,
            start: st,
            end: et,
            path: llNode.unit() ? llNode.unit().path() : "",
            extras: [],
            unit: llNode.unit()
        };
    };
    PointOfViewValidationAcceptorImpl.prototype.generateLinkMessageByNode = function (connectingNode, originalIssue) {
        if (connectingNode.property().nameId()
            == universes.Universe10.Extension.properties.extends.name) {
            return "Error in the master file: " + originalIssue.message;
        }
        return originalIssue.message;
    };
    PointOfViewValidationAcceptorImpl.prototype.findIssueTail = function (issue) {
        if (!issue.extras || issue.extras.length == 0) {
            return issue;
        }
        return this.findIssueTail(issue.extras[0]);
    };
    return PointOfViewValidationAcceptorImpl;
}());
exports.PointOfViewValidationAcceptorImpl = PointOfViewValidationAcceptorImpl;
//# sourceMappingURL=utils.js.map