/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.aggregations.bucket.composite;

import java.io.IOException;
import org.elasticsearch.common.ParseField;
import org.elasticsearch.common.ParsingException;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.xcontent.AbstractObjectParser;
import org.elasticsearch.common.xcontent.ObjectParser;
import org.elasticsearch.common.xcontent.XContentParser;
import org.elasticsearch.common.xcontent.XContentParserUtils;
import org.elasticsearch.script.Script;
import org.elasticsearch.search.aggregations.bucket.composite.CompositeValuesSourceBuilder;
import org.elasticsearch.search.aggregations.bucket.composite.DateHistogramValuesSourceBuilder;
import org.elasticsearch.search.aggregations.bucket.composite.HistogramValuesSourceBuilder;
import org.elasticsearch.search.aggregations.bucket.composite.TermsValuesSourceBuilder;
import org.elasticsearch.search.aggregations.support.ValueType;

class CompositeValuesSourceParserHelper {
    CompositeValuesSourceParserHelper() {
    }

    static <VB extends CompositeValuesSourceBuilder<VB>, T> void declareValuesSourceFields(AbstractObjectParser<VB, T> objectParser, ValueType targetValueType) {
        objectParser.declareField(CompositeValuesSourceBuilder::field, XContentParser::text, new ParseField("field", new String[0]), ObjectParser.ValueType.STRING);
        objectParser.declareField(CompositeValuesSourceBuilder::missing, XContentParser::objectText, new ParseField("missing", new String[0]), ObjectParser.ValueType.VALUE);
        objectParser.declareBoolean(CompositeValuesSourceBuilder::missingBucket, new ParseField("missing_bucket", new String[0]));
        objectParser.declareField(CompositeValuesSourceBuilder::valueType, p -> {
            ValueType valueType = ValueType.resolveForScript(p.text());
            if (targetValueType != null && valueType.isNotA(targetValueType)) {
                throw new ParsingException(p.getTokenLocation(), "Aggregation [" + objectParser.getName() + "] was configured with an incompatible value type [" + valueType + "]. It can only work on value of type [" + targetValueType + "]", new Object[0]);
            }
            return valueType;
        }, new ParseField("value_type", new String[0]), ObjectParser.ValueType.STRING);
        objectParser.declareField(CompositeValuesSourceBuilder::script, (parser, context) -> Script.parse(parser), Script.SCRIPT_PARSE_FIELD, ObjectParser.ValueType.OBJECT_OR_STRING);
        objectParser.declareField(CompositeValuesSourceBuilder::order, XContentParser::text, new ParseField("order", new String[0]), ObjectParser.ValueType.STRING);
    }

    static void writeTo(CompositeValuesSourceBuilder<?> builder, StreamOutput out) throws IOException {
        int code;
        if (builder.getClass() == TermsValuesSourceBuilder.class) {
            code = 0;
        } else if (builder.getClass() == DateHistogramValuesSourceBuilder.class) {
            code = 1;
        } else if (builder.getClass() == HistogramValuesSourceBuilder.class) {
            code = 2;
        } else {
            throw new IOException("invalid builder type: " + builder.getClass().getSimpleName());
        }
        out.writeByte((byte)code);
        builder.writeTo(out);
    }

    static CompositeValuesSourceBuilder<?> readFrom(StreamInput in) throws IOException {
        byte code = in.readByte();
        switch (code) {
            case 0: {
                return new TermsValuesSourceBuilder(in);
            }
            case 1: {
                return new DateHistogramValuesSourceBuilder(in);
            }
            case 2: {
                return new HistogramValuesSourceBuilder(in);
            }
        }
        throw new IOException("Invalid code " + code);
    }

    static CompositeValuesSourceBuilder<?> fromXContent(XContentParser parser) throws IOException {
        CompositeValuesSourceBuilder builder;
        XContentParser.Token token = parser.currentToken();
        XContentParserUtils.ensureExpectedToken(XContentParser.Token.START_OBJECT, token, parser::getTokenLocation);
        token = parser.nextToken();
        XContentParserUtils.ensureExpectedToken(XContentParser.Token.FIELD_NAME, token, parser::getTokenLocation);
        String name = parser.currentName();
        token = parser.nextToken();
        XContentParserUtils.ensureExpectedToken(XContentParser.Token.START_OBJECT, token, parser::getTokenLocation);
        token = parser.nextToken();
        XContentParserUtils.ensureExpectedToken(XContentParser.Token.FIELD_NAME, token, parser::getTokenLocation);
        String type = parser.currentName();
        token = parser.nextToken();
        XContentParserUtils.ensureExpectedToken(XContentParser.Token.START_OBJECT, token, parser::getTokenLocation);
        switch (type) {
            case "terms": {
                builder = TermsValuesSourceBuilder.parse(name, parser);
                break;
            }
            case "date_histogram": {
                builder = DateHistogramValuesSourceBuilder.parse(name, parser);
                break;
            }
            case "histogram": {
                builder = HistogramValuesSourceBuilder.parse(name, parser);
                break;
            }
            default: {
                throw new ParsingException(parser.getTokenLocation(), "invalid source type: " + type, new Object[0]);
            }
        }
        parser.nextToken();
        parser.nextToken();
        return builder;
    }
}

