/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.util;

import com.unboundid.util.ValuePatternComponent;
import java.text.DecimalFormat;
import java.util.concurrent.atomic.AtomicLong;

final class SequentialValuePatternComponent
extends ValuePatternComponent {
    private static final long serialVersionUID = -3553865579642557953L;
    private final AtomicLong nextValue;
    private final long increment;
    private final long lowerBound;
    private final long upperBound;
    private final String formatString;
    private final ThreadLocal<DecimalFormat> decimalFormat;

    SequentialValuePatternComponent(long lowerBound, long upperBound, long increment, String formatString) {
        if (lowerBound == upperBound) {
            this.lowerBound = lowerBound;
            this.upperBound = upperBound;
            this.increment = 0L;
        } else if (lowerBound > upperBound) {
            this.lowerBound = upperBound;
            this.upperBound = lowerBound;
            this.increment = Math.abs(increment) > lowerBound - upperBound ? 0L : -1L * increment;
        } else {
            this.lowerBound = lowerBound;
            this.upperBound = upperBound;
            this.increment = Math.abs(increment) > upperBound - lowerBound ? 0L : increment;
        }
        this.formatString = formatString;
        this.decimalFormat = new ThreadLocal();
        this.nextValue = new AtomicLong(lowerBound);
    }

    void append(StringBuilder buffer) {
        long v;
        long value = this.nextValue.getAndAdd(this.increment);
        if (value > this.upperBound) {
            if (this.nextValue.compareAndSet(value + this.increment, this.lowerBound)) {
                value = this.nextValue.getAndAdd(this.increment);
            } else {
                while ((v = this.nextValue.get()) >= this.upperBound && !this.nextValue.compareAndSet(v, this.lowerBound)) {
                }
                value = this.nextValue.getAndAdd(this.increment);
            }
        } else if (value < this.lowerBound) {
            if (this.nextValue.compareAndSet(value + this.increment, this.upperBound)) {
                value = this.nextValue.getAndAdd(this.increment);
            } else {
                while ((v = this.nextValue.get()) <= this.lowerBound && !this.nextValue.compareAndSet(v, this.upperBound)) {
                }
                value = this.nextValue.getAndAdd(this.increment);
            }
        }
        if (this.formatString == null) {
            buffer.append(value);
        } else {
            DecimalFormat f = this.decimalFormat.get();
            if (f == null) {
                f = new DecimalFormat(this.formatString);
                this.decimalFormat.set(f);
            }
            buffer.append(f.format(value));
        }
    }

    boolean supportsBackReference() {
        return true;
    }
}

