/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.ml.action;

import java.util.ArrayList;
import java.util.Set;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.support.ActionFilters;
import org.elasticsearch.action.support.master.TransportMasterNodeReadAction;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.block.ClusterBlockException;
import org.elasticsearch.cluster.block.ClusterBlockLevel;
import org.elasticsearch.cluster.metadata.IndexNameExpressionResolver;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.TransportService;
import org.elasticsearch.xpack.core.ml.MlMetadata;
import org.elasticsearch.xpack.core.ml.action.GetDatafeedsAction;
import org.elasticsearch.xpack.core.ml.action.util.QueryPage;
import org.elasticsearch.xpack.core.ml.datafeed.DatafeedConfig;

public class TransportGetDatafeedsAction
extends TransportMasterNodeReadAction<GetDatafeedsAction.Request, GetDatafeedsAction.Response> {
    @Inject
    public TransportGetDatafeedsAction(Settings settings, TransportService transportService, ClusterService clusterService, ThreadPool threadPool, ActionFilters actionFilters, IndexNameExpressionResolver indexNameExpressionResolver) {
        super(settings, "cluster:monitor/xpack/ml/datafeeds/get", transportService, clusterService, threadPool, actionFilters, indexNameExpressionResolver, GetDatafeedsAction.Request::new);
    }

    protected String executor() {
        return "same";
    }

    protected GetDatafeedsAction.Response newResponse() {
        return new GetDatafeedsAction.Response();
    }

    protected void masterOperation(GetDatafeedsAction.Request request, ClusterState state, ActionListener<GetDatafeedsAction.Response> listener) throws Exception {
        this.logger.debug("Get datafeed '{}'", (Object)request.getDatafeedId());
        MlMetadata mlMetadata = MlMetadata.getMlMetadata((ClusterState)state);
        Set expandedDatafeedIds = mlMetadata.expandDatafeedIds(request.getDatafeedId(), request.allowNoDatafeeds());
        ArrayList<DatafeedConfig> datafeedConfigs = new ArrayList<DatafeedConfig>();
        for (String expandedDatafeedId : expandedDatafeedIds) {
            datafeedConfigs.add(mlMetadata.getDatafeed(expandedDatafeedId));
        }
        listener.onResponse((Object)new GetDatafeedsAction.Response(new QueryPage(datafeedConfigs, (long)datafeedConfigs.size(), DatafeedConfig.RESULTS_FIELD)));
    }

    protected ClusterBlockException checkBlock(GetDatafeedsAction.Request request, ClusterState state) {
        return state.blocks().globalBlockedException(ClusterBlockLevel.METADATA_READ);
    }
}

