/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.painless.node;

import java.util.List;
import java.util.Objects;
import java.util.Set;
import org.elasticsearch.painless.Globals;
import org.elasticsearch.painless.Locals;
import org.elasticsearch.painless.Location;
import org.elasticsearch.painless.MethodWriter;
import org.elasticsearch.painless.lookup.PainlessClass;
import org.elasticsearch.painless.lookup.PainlessLookupUtility;
import org.elasticsearch.painless.lookup.PainlessMethod;
import org.elasticsearch.painless.node.AExpression;
import org.objectweb.asm.Type;

public final class ENewObj
extends AExpression {
    private final String type;
    private final List<AExpression> arguments;
    private PainlessMethod constructor;

    public ENewObj(Location location, String type, List<AExpression> arguments) {
        super(location);
        this.type = Objects.requireNonNull(type);
        this.arguments = Objects.requireNonNull(arguments);
    }

    @Override
    void extractVariables(Set<String> variables) {
        for (AExpression argument : this.arguments) {
            argument.extractVariables(variables);
        }
    }

    @Override
    void analyze(Locals locals) {
        try {
            this.actual = locals.getPainlessLookup().getJavaClassFromPainlessType(this.type);
        }
        catch (IllegalArgumentException exception) {
            throw this.createError(new IllegalArgumentException("Not a type [" + this.type + "]."));
        }
        PainlessClass struct = locals.getPainlessLookup().getPainlessStructFromJavaClass(this.actual);
        this.constructor = struct.constructors.get(PainlessLookupUtility.buildPainlessMethodKey("<init>", this.arguments.size()));
        if (this.constructor != null) {
            Class[] types = new Class[this.constructor.arguments.size()];
            this.constructor.arguments.toArray(types);
            if (this.constructor.arguments.size() != this.arguments.size()) {
                throw this.createError(new IllegalArgumentException("When calling constructor on type [" + struct.name + "] expected [" + this.constructor.arguments.size() + "] arguments, but found [" + this.arguments.size() + "]."));
            }
            for (int argument = 0; argument < this.arguments.size(); ++argument) {
                AExpression expression = this.arguments.get(argument);
                expression.expected = types[argument];
                expression.internal = true;
                expression.analyze(locals);
                this.arguments.set(argument, expression.cast(locals));
            }
        } else {
            throw this.createError(new IllegalArgumentException("Unknown new call on type [" + struct.name + "]."));
        }
        this.statement = true;
    }

    @Override
    void write(MethodWriter writer, Globals globals) {
        writer.writeDebugInfo(this.location);
        writer.newInstance(MethodWriter.getType(this.actual));
        if (this.read) {
            writer.dup();
        }
        for (AExpression argument : this.arguments) {
            argument.write(writer, globals);
        }
        writer.invokeConstructor(Type.getType(this.constructor.target), this.constructor.method);
    }

    @Override
    public String toString() {
        return this.singleLineToStringWithOptionalArgs(this.arguments, this.type);
    }
}

