/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core.security.action.user;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.elasticsearch.Version;
import org.elasticsearch.action.ActionResponse;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;

public class HasPrivilegesResponse
extends ActionResponse {
    private boolean completeMatch;
    private Map<String, Boolean> cluster;
    private List<ResourcePrivileges> index;
    private Map<String, List<ResourcePrivileges>> application;

    public HasPrivilegesResponse() {
        this(true, Collections.emptyMap(), Collections.emptyList(), Collections.emptyMap());
    }

    public HasPrivilegesResponse(boolean completeMatch, Map<String, Boolean> cluster, Collection<ResourcePrivileges> index, Map<String, Collection<ResourcePrivileges>> application) {
        this.completeMatch = completeMatch;
        this.cluster = new HashMap<String, Boolean>(cluster);
        this.index = new ArrayList<ResourcePrivileges>(index);
        this.application = new HashMap<String, List<ResourcePrivileges>>();
        application.forEach((key, val) -> this.application.put((String)key, Collections.unmodifiableList(new ArrayList(val))));
    }

    public boolean isCompleteMatch() {
        return this.completeMatch;
    }

    public Map<String, Boolean> getClusterPrivileges() {
        return Collections.unmodifiableMap(this.cluster);
    }

    public List<ResourcePrivileges> getIndexPrivileges() {
        return Collections.unmodifiableList(this.index);
    }

    public Map<String, List<ResourcePrivileges>> getApplicationPrivileges() {
        return Collections.unmodifiableMap(this.application);
    }

    public void readFrom(StreamInput in) throws IOException {
        super.readFrom(in);
        this.completeMatch = in.readBoolean();
        this.index = HasPrivilegesResponse.readResourcePrivileges(in);
        if (in.getVersion().onOrAfter(Version.V_6_4_0)) {
            this.application = in.readMap(StreamInput::readString, HasPrivilegesResponse::readResourcePrivileges);
        }
    }

    private static List<ResourcePrivileges> readResourcePrivileges(StreamInput in) throws IOException {
        int count = in.readVInt();
        ArrayList<ResourcePrivileges> list = new ArrayList<ResourcePrivileges>(count);
        for (int i = 0; i < count; ++i) {
            String index = in.readString();
            Map privileges = in.readMap(StreamInput::readString, StreamInput::readBoolean);
            list.add(new ResourcePrivileges(index, privileges));
        }
        return list;
    }

    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        out.writeBoolean(this.completeMatch);
        HasPrivilegesResponse.writeResourcePrivileges(out, this.index);
        if (out.getVersion().onOrAfter(Version.V_6_4_0)) {
            out.writeMap(this.application, StreamOutput::writeString, HasPrivilegesResponse::writeResourcePrivileges);
        }
    }

    private static void writeResourcePrivileges(StreamOutput out, List<ResourcePrivileges> privileges) throws IOException {
        out.writeVInt(privileges.size());
        for (ResourcePrivileges priv : privileges) {
            out.writeString(priv.resource);
            out.writeMap(priv.privileges, StreamOutput::writeString, StreamOutput::writeBoolean);
        }
    }

    public static class ResourcePrivileges {
        private final String resource;
        private final Map<String, Boolean> privileges;

        public ResourcePrivileges(String resource, Map<String, Boolean> privileges) {
            this.resource = Objects.requireNonNull(resource);
            this.privileges = Collections.unmodifiableMap(privileges);
        }

        public String getResource() {
            return this.resource;
        }

        public Map<String, Boolean> getPrivileges() {
            return this.privileges;
        }

        public String toString() {
            return this.getClass().getSimpleName() + "{resource='" + this.resource + '\'' + ", privileges=" + this.privileges + '}';
        }

        public int hashCode() {
            int result = this.resource.hashCode();
            result = 31 * result + this.privileges.hashCode();
            return result;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            ResourcePrivileges other = (ResourcePrivileges)o;
            return this.resource.equals(other.resource) && this.privileges.equals(other.privileges);
        }
    }
}

