/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.sql.expression.function.scalar.math;

import java.util.Locale;
import java.util.Objects;
import java.util.function.BiFunction;
import org.elasticsearch.xpack.sql.expression.Expression;
import org.elasticsearch.xpack.sql.expression.function.scalar.BinaryScalarFunction;
import org.elasticsearch.xpack.sql.expression.function.scalar.script.ParamsBuilder;
import org.elasticsearch.xpack.sql.expression.function.scalar.script.ScriptTemplate;
import org.elasticsearch.xpack.sql.tree.Location;
import org.elasticsearch.xpack.sql.type.DataType;

public abstract class BinaryNumericFunction
extends BinaryScalarFunction {
    protected BinaryNumericFunction(Location location, Expression left, Expression right) {
        super(location, left, right);
    }

    protected abstract BiFunction<Number, Number, Number> operation();

    @Override
    public DataType dataType() {
        return DataType.DOUBLE;
    }

    @Override
    protected Expression.TypeResolution resolveType() {
        if (!this.childrenResolved()) {
            return new Expression.TypeResolution("Unresolved children", new Object[0]);
        }
        Expression.TypeResolution resolution = this.resolveInputType(this.left().dataType());
        if (resolution == Expression.TypeResolution.TYPE_RESOLVED) {
            return this.resolveInputType(this.right().dataType());
        }
        return resolution;
    }

    protected Expression.TypeResolution resolveInputType(DataType inputType) {
        return inputType.isNumeric() ? Expression.TypeResolution.TYPE_RESOLVED : new Expression.TypeResolution("'%s' requires a numeric type, received %s", this.mathFunction(), inputType.esType);
    }

    @Override
    public Object fold() {
        return this.operation().apply((Number)this.left().fold(), (Number)this.right().fold());
    }

    @Override
    protected ScriptTemplate asScriptFrom(ScriptTemplate leftScript, ScriptTemplate rightScript) {
        return new ScriptTemplate(String.format(Locale.ROOT, "Math.%s(%s,%s)", this.mathFunction(), leftScript.template(), rightScript.template()), ParamsBuilder.paramsBuilder().script(leftScript.params()).script(rightScript.params()).build(), this.dataType());
    }

    protected String mathFunction() {
        return this.getClass().getSimpleName().toLowerCase(Locale.ROOT);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.left(), this.right(), this.operation());
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == null || obj.getClass() != this.getClass()) {
            return false;
        }
        BinaryNumericFunction other = (BinaryNumericFunction)obj;
        return Objects.equals(other.left(), this.left()) && Objects.equals(other.right(), this.right()) && Objects.equals(other.operation(), this.operation());
    }
}

