/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.sql.plan.physical;

import java.util.List;
import java.util.Objects;
import org.elasticsearch.xpack.sql.expression.Attribute;
import org.elasticsearch.xpack.sql.expression.Expression;
import org.elasticsearch.xpack.sql.plan.physical.AggregateExec;
import org.elasticsearch.xpack.sql.plan.physical.PhysicalPlan;
import org.elasticsearch.xpack.sql.plan.physical.UnaryExec;
import org.elasticsearch.xpack.sql.plan.physical.Unexecutable;
import org.elasticsearch.xpack.sql.tree.Location;
import org.elasticsearch.xpack.sql.tree.NodeInfo;

public class FilterExec
extends UnaryExec
implements Unexecutable {
    private final Expression condition;
    private final boolean isHaving;

    public FilterExec(Location location, PhysicalPlan child, Expression condition) {
        this(location, child, condition, child instanceof AggregateExec);
    }

    public FilterExec(Location location, PhysicalPlan child, Expression condition, boolean isHaving) {
        super(location, child);
        this.condition = condition;
        this.isHaving = isHaving;
    }

    @Override
    protected NodeInfo<FilterExec> info() {
        return NodeInfo.create(this, FilterExec::new, this.child(), this.condition, this.isHaving);
    }

    @Override
    protected FilterExec replaceChild(PhysicalPlan newChild) {
        return new FilterExec(this.location(), newChild, this.condition, this.isHaving);
    }

    public Expression condition() {
        return this.condition;
    }

    public boolean isHaving() {
        return this.isHaving;
    }

    @Override
    public List<Attribute> output() {
        return this.child().output();
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.condition, this.isHaving, this.child());
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        FilterExec other = (FilterExec)obj;
        return Objects.equals(this.condition, other.condition) && Objects.equals(this.child(), other.child());
    }
}

