/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.jsse.provider;

import java.net.Socket;
import java.security.GeneralSecurityException;
import java.security.InvalidAlgorithmParameterException;
import java.security.Provider;
import java.security.cert.CertPathBuilder;
import java.security.cert.CertSelector;
import java.security.cert.CertStore;
import java.security.cert.CertStoreParameters;
import java.security.cert.CertificateException;
import java.security.cert.CollectionCertStoreParameters;
import java.security.cert.PKIXBuilderParameters;
import java.security.cert.PKIXCertPathValidatorResult;
import java.security.cert.PKIXParameters;
import java.security.cert.TrustAnchor;
import java.security.cert.X509CertSelector;
import java.security.cert.X509Certificate;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import javax.net.ssl.SSLEngine;
import org.bouncycastle.jsse.provider.ProvX509TrustManager;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class ProvX509TrustManagerImpl
implements ProvX509TrustManager {
    private final Provider pkixProvider;
    private final Set<X509Certificate> trustedCerts;
    private final PKIXParameters baseParameters;

    private Set<X509Certificate> getTrustedCerts(Set<TrustAnchor> set) {
        HashSet<X509Certificate> hashSet = new HashSet<X509Certificate>(set.size());
        for (TrustAnchor trustAnchor : set) {
            X509Certificate x509Certificate;
            if (trustAnchor == null || (x509Certificate = trustAnchor.getTrustedCert()) == null) continue;
            hashSet.add(x509Certificate);
        }
        return hashSet;
    }

    ProvX509TrustManagerImpl(Provider provider, Set<TrustAnchor> set) throws InvalidAlgorithmParameterException {
        this.pkixProvider = provider;
        this.trustedCerts = this.getTrustedCerts(set);
        this.baseParameters = new PKIXBuilderParameters(set, (CertSelector)new X509CertSelector());
        this.baseParameters.setRevocationEnabled(false);
    }

    ProvX509TrustManagerImpl(Provider provider, PKIXParameters pKIXParameters) throws InvalidAlgorithmParameterException {
        this.pkixProvider = provider;
        this.trustedCerts = this.getTrustedCerts(pKIXParameters.getTrustAnchors());
        if (pKIXParameters instanceof PKIXBuilderParameters) {
            this.baseParameters = pKIXParameters;
        } else {
            this.baseParameters = new PKIXBuilderParameters(pKIXParameters.getTrustAnchors(), pKIXParameters.getTargetCertConstraints());
            this.baseParameters.setCertStores(pKIXParameters.getCertStores());
            this.baseParameters.setRevocationEnabled(pKIXParameters.isRevocationEnabled());
            this.baseParameters.setCertPathCheckers(pKIXParameters.getCertPathCheckers());
            this.baseParameters.setDate(pKIXParameters.getDate());
            this.baseParameters.setAnyPolicyInhibited(pKIXParameters.isAnyPolicyInhibited());
            this.baseParameters.setPolicyMappingInhibited(pKIXParameters.isPolicyMappingInhibited());
            this.baseParameters.setExplicitPolicyRequired(pKIXParameters.isExplicitPolicyRequired());
        }
    }

    @Override
    public void checkClientTrusted(X509Certificate[] x509CertificateArray, String string) throws CertificateException {
        this.validatePath(x509CertificateArray);
    }

    @Override
    public void checkServerTrusted(X509Certificate[] x509CertificateArray, String string) throws CertificateException {
        this.validatePath(x509CertificateArray);
    }

    @Override
    public void checkClientTrusted(X509Certificate[] x509CertificateArray, String string, Socket socket) throws CertificateException {
        this.validatePath(x509CertificateArray);
    }

    @Override
    public void checkServerTrusted(X509Certificate[] x509CertificateArray, String string, Socket socket) throws CertificateException {
        this.validatePath(x509CertificateArray);
    }

    @Override
    public void checkClientTrusted(X509Certificate[] x509CertificateArray, String string, SSLEngine sSLEngine) throws CertificateException {
        this.validatePath(x509CertificateArray);
    }

    @Override
    public void checkServerTrusted(X509Certificate[] x509CertificateArray, String string, SSLEngine sSLEngine) throws CertificateException {
        this.validatePath(x509CertificateArray);
    }

    @Override
    public X509Certificate[] getAcceptedIssuers() {
        return this.trustedCerts.toArray(new X509Certificate[this.trustedCerts.size()]);
    }

    protected void validatePath(X509Certificate[] x509CertificateArray) throws CertificateException {
        if (x509CertificateArray == null || x509CertificateArray.length < 1) {
            throw new IllegalArgumentException("'x509Certificates' must be a chain of at least one certificate");
        }
        X509Certificate x509Certificate = x509CertificateArray[0];
        if (this.trustedCerts.contains(x509Certificate)) {
            return;
        }
        try {
            CertStore certStore = CertStore.getInstance("Collection", (CertStoreParameters)new CollectionCertStoreParameters(Arrays.asList(x509CertificateArray)), this.pkixProvider);
            CertPathBuilder certPathBuilder = CertPathBuilder.getInstance("PKIX", this.pkixProvider);
            X509CertSelector x509CertSelector = (X509CertSelector)this.baseParameters.getTargetCertConstraints().clone();
            x509CertSelector.setCertificate(x509Certificate);
            PKIXBuilderParameters pKIXBuilderParameters = (PKIXBuilderParameters)this.baseParameters.clone();
            pKIXBuilderParameters.addCertStore(certStore);
            pKIXBuilderParameters.setTargetCertConstraints(x509CertSelector);
            PKIXCertPathValidatorResult pKIXCertPathValidatorResult = (PKIXCertPathValidatorResult)((Object)certPathBuilder.build(pKIXBuilderParameters));
        }
        catch (GeneralSecurityException generalSecurityException) {
            throw new CertificateException("unable to process certificates: " + generalSecurityException.getMessage(), generalSecurityException);
        }
    }
}

