/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.icu.impl.number.formatters;

import com.ibm.icu.impl.StandardPlural;
import com.ibm.icu.impl.number.AffixPatternUtils;
import com.ibm.icu.impl.number.PNAffixGenerator;
import com.ibm.icu.impl.number.PatternString;
import com.ibm.icu.impl.number.Properties;
import com.ibm.icu.impl.number.Rounder;
import com.ibm.icu.impl.number.formatters.PositiveNegativeAffixFormat;
import com.ibm.icu.impl.number.formatters.RoundingFormat;
import com.ibm.icu.impl.number.modifiers.GeneralPluralModifier;
import com.ibm.icu.impl.number.rounders.IncrementRounder;
import com.ibm.icu.impl.number.rounders.MagnitudeRounder;
import com.ibm.icu.impl.number.rounders.SignificantDigitsRounder;
import com.ibm.icu.text.CurrencyPluralInfo;
import com.ibm.icu.text.DecimalFormatSymbols;
import com.ibm.icu.util.Currency;
import java.math.BigDecimal;

public class CurrencyFormat {
    private static final Currency DEFAULT_CURRENCY = Currency.getInstance("XXX");
    private static final ThreadLocal<Properties> threadLocalProperties = new ThreadLocal<Properties>(){

        @Override
        protected Properties initialValue() {
            return new Properties();
        }
    };

    public static boolean useCurrency(IProperties properties) {
        return properties.getCurrency() != null || properties.getCurrencyPluralInfo() != null || properties.getCurrencyUsage() != null || AffixPatternUtils.hasCurrencySymbols(properties.getPositivePrefixPattern()) || AffixPatternUtils.hasCurrencySymbols(properties.getPositiveSuffixPattern()) || AffixPatternUtils.hasCurrencySymbols(properties.getNegativePrefixPattern()) || AffixPatternUtils.hasCurrencySymbols(properties.getNegativeSuffixPattern());
    }

    public static String getCurrencySymbol(DecimalFormatSymbols symbols, ICurrencyProperties properties) {
        CurrencyStyle style = properties.getCurrencyStyle();
        if (style == CurrencyStyle.ISO_CODE) {
            return CurrencyFormat.getCurrencyIsoCode(symbols, properties);
        }
        Currency currency = properties.getCurrency();
        if (currency == null) {
            return symbols.getCurrencySymbol();
        }
        if (currency.equals(symbols.getCurrency())) {
            return symbols.getCurrencySymbol();
        }
        return currency.getName(symbols.getULocale(), 0, null);
    }

    public static String getCurrencyIsoCode(DecimalFormatSymbols symbols, ICurrencyProperties properties) {
        Currency currency = properties.getCurrency();
        if (currency == null) {
            return symbols.getInternationalCurrencySymbol();
        }
        if (currency.equals(symbols.getCurrency())) {
            return symbols.getInternationalCurrencySymbol();
        }
        return currency.getCurrencyCode();
    }

    public static String getCurrencyLongName(DecimalFormatSymbols symbols, ICurrencyProperties properties, StandardPlural plural) {
        Currency currency = properties.getCurrency();
        if (currency == null) {
            currency = symbols.getCurrency();
        }
        if (currency == null) {
            return CurrencyFormat.getCurrencySymbol(symbols, properties);
        }
        return currency.getName(symbols.getULocale(), 2, plural.getKeyword(), null);
    }

    public static GeneralPluralModifier getCurrencyModifier(DecimalFormatSymbols symbols, IProperties properties) {
        PNAffixGenerator pnag = PNAffixGenerator.getThreadLocalInstance();
        String sym = CurrencyFormat.getCurrencySymbol(symbols, properties);
        String iso = CurrencyFormat.getCurrencyIsoCode(symbols, properties);
        CurrencyPluralInfo info = properties.getCurrencyPluralInfo();
        GeneralPluralModifier mod = new GeneralPluralModifier();
        Properties temp = new Properties();
        for (StandardPlural plural : StandardPlural.VALUES) {
            PNAffixGenerator.Result result;
            String longName = CurrencyFormat.getCurrencyLongName(symbols, properties, plural);
            if (info == null) {
                result = pnag.getModifiers(symbols, sym, iso, longName, properties);
            } else {
                String pluralPattern = info.getCurrencyPluralPattern(plural.getKeyword());
                PatternString.parseToExistingProperties(pluralPattern, temp, true);
                result = pnag.getModifiers(symbols, sym, iso, longName, temp);
            }
            mod.put(plural, result.positive, result.negative);
        }
        return mod;
    }

    public static void populateCurrencyRounderProperties(Properties destination, DecimalFormatSymbols symbols, IProperties properties) {
        Currency currency = properties.getCurrency();
        if (currency == null) {
            currency = symbols.getCurrency();
        }
        if (currency == null) {
            currency = DEFAULT_CURRENCY;
        }
        Currency.CurrencyUsage _currencyUsage = properties.getCurrencyUsage();
        int _minFrac = properties.getMinimumFractionDigits();
        int _maxFrac = properties.getMaximumFractionDigits();
        Currency.CurrencyUsage effectiveCurrencyUsage = _currencyUsage != null ? _currencyUsage : Currency.CurrencyUsage.STANDARD;
        double incrementDouble = currency.getRoundingIncrement(effectiveCurrencyUsage);
        int fractionDigits = currency.getDefaultFractionDigits(effectiveCurrencyUsage);
        destination.setRoundingMode(properties.getRoundingMode());
        destination.setMinimumIntegerDigits(properties.getMinimumIntegerDigits());
        destination.setMaximumIntegerDigits(properties.getMaximumIntegerDigits());
        if (_currencyUsage == null && (_minFrac >= 0 || _maxFrac >= 0)) {
            if (_minFrac < 0) {
                destination.setMinimumFractionDigits(fractionDigits < _maxFrac ? fractionDigits : _maxFrac);
                destination.setMaximumFractionDigits(_maxFrac);
            } else if (_maxFrac < 0) {
                destination.setMinimumFractionDigits(_minFrac);
                destination.setMaximumFractionDigits(fractionDigits > _minFrac ? fractionDigits : _minFrac);
            } else {
                destination.setMinimumFractionDigits(_minFrac);
                destination.setMaximumFractionDigits(_maxFrac);
            }
        } else {
            destination.setMinimumFractionDigits(fractionDigits);
            destination.setMaximumFractionDigits(fractionDigits);
        }
        if (incrementDouble > 0.0) {
            BigDecimal _roundingIncrement = properties.getRoundingIncrement();
            BigDecimal incrementBigDecimal = _roundingIncrement != null ? _roundingIncrement : BigDecimal.valueOf(incrementDouble);
            destination.setRoundingIncrement(incrementBigDecimal);
        }
    }

    public static Rounder getCurrencyRounder(DecimalFormatSymbols symbols, IProperties properties) {
        if (SignificantDigitsRounder.useSignificantDigits(properties)) {
            return SignificantDigitsRounder.getInstance(properties);
        }
        Properties cprops = threadLocalProperties.get().clear();
        CurrencyFormat.populateCurrencyRounderProperties(cprops, symbols, properties);
        if (cprops.getRoundingIncrement() != null) {
            return IncrementRounder.getInstance(cprops);
        }
        return MagnitudeRounder.getInstance(cprops);
    }

    public static interface IProperties
    extends ICurrencyProperties,
    RoundingFormat.IProperties,
    PositiveNegativeAffixFormat.IProperties {
    }

    public static interface ICurrencyProperties {
        public static final Currency DEFAULT_CURRENCY = null;
        public static final CurrencyStyle DEFAULT_CURRENCY_STYLE = null;
        public static final Currency.CurrencyUsage DEFAULT_CURRENCY_USAGE = null;
        public static final CurrencyPluralInfo DEFAULT_CURRENCY_PLURAL_INFO = null;

        public Currency getCurrency();

        public IProperties setCurrency(Currency var1);

        public CurrencyStyle getCurrencyStyle();

        public IProperties setCurrencyStyle(CurrencyStyle var1);

        public Currency.CurrencyUsage getCurrencyUsage();

        public IProperties setCurrencyUsage(Currency.CurrencyUsage var1);

        @Deprecated
        public CurrencyPluralInfo getCurrencyPluralInfo();

        @Deprecated
        public IProperties setCurrencyPluralInfo(CurrencyPluralInfo var1);
    }

    public static enum CurrencyStyle {
        SYMBOL,
        ISO_CODE;

    }
}

