/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.js.inline.clean;

import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.js.backend.ast.JsBlock;
import org.jetbrains.kotlin.js.backend.ast.JsBooleanLiteral;
import org.jetbrains.kotlin.js.backend.ast.JsBreak;
import org.jetbrains.kotlin.js.backend.ast.JsContext;
import org.jetbrains.kotlin.js.backend.ast.JsContinue;
import org.jetbrains.kotlin.js.backend.ast.JsDoWhile;
import org.jetbrains.kotlin.js.backend.ast.JsFor;
import org.jetbrains.kotlin.js.backend.ast.JsForIn;
import org.jetbrains.kotlin.js.backend.ast.JsGlobalBlock;
import org.jetbrains.kotlin.js.backend.ast.JsLabel;
import org.jetbrains.kotlin.js.backend.ast.JsName;
import org.jetbrains.kotlin.js.backend.ast.JsNameRef;
import org.jetbrains.kotlin.js.backend.ast.JsNode;
import org.jetbrains.kotlin.js.backend.ast.JsProgramFragment;
import org.jetbrains.kotlin.js.backend.ast.JsScope;
import org.jetbrains.kotlin.js.backend.ast.JsStatement;
import org.jetbrains.kotlin.js.backend.ast.JsVisitorWithContextImpl;
import org.jetbrains.kotlin.js.backend.ast.JsWhile;
import org.jetbrains.kotlin.utils.CollectionsKt;

@Metadata(mv={1, 1, 10}, bv={1, 0, 2}, k=1, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0014\u0010\u0003\u001a\u00020\u00042\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006J\u000e\u0010\u0003\u001a\u00020\u00042\u0006\u0010\b\u001a\u00020\tJ&\u0010\n\u001a\u00020\u00042\u0006\u0010\u000b\u001a\u00020\f2\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000e2\u0006\u0010\u0010\u001a\u00020\u0011H\u0002J\n\u0010\u0012\u001a\u00020\u0013*\u00020\f\u00a8\u0006\u0014"}, d2={"Lorg/jetbrains/kotlin/js/inline/clean/LabeledBlockToDoWhileTransformation;", "", "()V", "apply", "", "fragments", "", "Lorg/jetbrains/kotlin/js/backend/ast/JsProgramFragment;", "root", "Lorg/jetbrains/kotlin/js/backend/ast/JsNode;", "labelLoopBreaksAndContinues", "loop", "Lorg/jetbrains/kotlin/js/backend/ast/JsStatement;", "fakeLoops", "", "Lorg/jetbrains/kotlin/js/backend/ast/JsDoWhile;", "label", "Lorg/jetbrains/kotlin/js/backend/ast/JsNameRef;", "isLoop", "", "js.translator"})
public final class LabeledBlockToDoWhileTransformation {
    public static final LabeledBlockToDoWhileTransformation INSTANCE;

    public final void apply(@NotNull List<? extends JsProgramFragment> fragments2) {
        Intrinsics.checkParameterIsNotNull(fragments2, "fragments");
        for (JsProgramFragment jsProgramFragment : fragments2) {
            JsGlobalBlock jsGlobalBlock = jsProgramFragment.getDeclarationBlock();
            Intrinsics.checkExpressionValueIsNotNull(jsGlobalBlock, "fragment.declarationBlock");
            this.apply(jsGlobalBlock);
            JsGlobalBlock jsGlobalBlock2 = jsProgramFragment.getInitializerBlock();
            Intrinsics.checkExpressionValueIsNotNull(jsGlobalBlock2, "fragment.initializerBlock");
            this.apply(jsGlobalBlock2);
        }
    }

    public final boolean isLoop(@NotNull JsStatement $receiver) {
        Intrinsics.checkParameterIsNotNull($receiver, "$receiver");
        JsStatement jsStatement = $receiver;
        return jsStatement instanceof JsWhile || jsStatement instanceof JsDoWhile || jsStatement instanceof JsFor || jsStatement instanceof JsForIn;
    }

    public final void apply(@NotNull JsNode root2) {
        Intrinsics.checkParameterIsNotNull(root2, "root");
        new JsVisitorWithContextImpl(){
            @NotNull
            private final Stack<JsStatement> loopStack;
            @NotNull
            private final HashSet<JsDoWhile> newFakeLoops;
            @NotNull
            private final HashMap<JsStatement, JsLabel> loopLabels;
            @NotNull
            private final HashSet<JsStatement> loopsToLabel;

            @NotNull
            public final Stack<JsStatement> getLoopStack() {
                return this.loopStack;
            }

            @NotNull
            public final HashSet<JsDoWhile> getNewFakeLoops() {
                return this.newFakeLoops;
            }

            @NotNull
            public final HashMap<JsStatement, JsLabel> getLoopLabels() {
                return this.loopLabels;
            }

            @NotNull
            public final HashSet<JsStatement> getLoopsToLabel() {
                return this.loopsToLabel;
            }

            public void endVisit(@NotNull JsLabel x, @NotNull JsContext<JsNode> ctx) {
                Intrinsics.checkParameterIsNotNull(x, "x");
                Intrinsics.checkParameterIsNotNull(ctx, "ctx");
                if (x.getStatement() instanceof JsBlock) {
                    CollectionsKt.addIfNotNull((Collection)this.loopsToLabel, kotlin.collections.CollectionsKt.lastOrNull((List)this.loopStack));
                    JsDoWhile fakeLoop = new JsDoWhile(new JsBooleanLiteral(false), x.getStatement());
                    this.newFakeLoops.add(fakeLoop);
                    x.setStatement(fakeLoop);
                }
                super.endVisit(x, ctx);
            }

            public boolean visit(@NotNull JsLabel x, @NotNull JsContext<JsNode> ctx) {
                Intrinsics.checkParameterIsNotNull(x, "x");
                Intrinsics.checkParameterIsNotNull(ctx, "ctx");
                JsStatement jsStatement = x.getStatement();
                Intrinsics.checkExpressionValueIsNotNull(jsStatement, "x.statement");
                if (LabeledBlockToDoWhileTransformation.INSTANCE.isLoop(jsStatement)) {
                    Map map2 = this.loopLabels;
                    JsStatement jsStatement2 = x.getStatement();
                    Intrinsics.checkExpressionValueIsNotNull(jsStatement2, "x.statement");
                    JsStatement jsStatement3 = jsStatement2;
                    JsLabel jsLabel = x;
                    map2.put(jsStatement3, jsLabel);
                }
                return true;
            }

            public boolean visit(@NotNull JsWhile x, @NotNull JsContext<JsNode> ctx) {
                Intrinsics.checkParameterIsNotNull(x, "x");
                Intrinsics.checkParameterIsNotNull(ctx, "ctx");
                return this.visitLoop(x);
            }

            public boolean visit(@NotNull JsDoWhile x, @NotNull JsContext<JsNode> ctx) {
                Intrinsics.checkParameterIsNotNull(x, "x");
                Intrinsics.checkParameterIsNotNull(ctx, "ctx");
                return this.visitLoop(x);
            }

            public boolean visit(@NotNull JsFor x, @NotNull JsContext<JsNode> ctx) {
                Intrinsics.checkParameterIsNotNull(x, "x");
                Intrinsics.checkParameterIsNotNull(ctx, "ctx");
                return this.visitLoop(x);
            }

            public boolean visit(@NotNull JsForIn x, @NotNull JsContext<JsNode> ctx) {
                Intrinsics.checkParameterIsNotNull(x, "x");
                Intrinsics.checkParameterIsNotNull(ctx, "ctx");
                return this.visitLoop(x);
            }

            public void endVisit(@NotNull JsWhile x, @NotNull JsContext<JsNode> ctx) {
                Intrinsics.checkParameterIsNotNull(x, "x");
                Intrinsics.checkParameterIsNotNull(ctx, "ctx");
                this.endVisitLoop(x, ctx);
            }

            public void endVisit(@NotNull JsDoWhile x, @NotNull JsContext<JsNode> ctx) {
                Intrinsics.checkParameterIsNotNull(x, "x");
                Intrinsics.checkParameterIsNotNull(ctx, "ctx");
                this.endVisitLoop(x, ctx);
            }

            public void endVisit(@NotNull JsFor x, @NotNull JsContext<JsNode> ctx) {
                Intrinsics.checkParameterIsNotNull(x, "x");
                Intrinsics.checkParameterIsNotNull(ctx, "ctx");
                this.endVisitLoop(x, ctx);
            }

            public void endVisit(@NotNull JsForIn x, @NotNull JsContext<JsNode> ctx) {
                Intrinsics.checkParameterIsNotNull(x, "x");
                Intrinsics.checkParameterIsNotNull(ctx, "ctx");
                this.endVisitLoop(x, ctx);
            }

            private final boolean visitLoop(JsStatement x) {
                this.loopStack.push(x);
                return true;
            }

            private final void endVisitLoop(JsStatement x, JsContext<JsNode> ctx) {
                this.loopStack.pop();
                if (this.loopsToLabel.contains(x)) {
                    JsLabel label = this.loopLabels.get(x);
                    if (label == null) {
                        JsName labelName = JsScope.declareTemporaryName("loop_label");
                        label = new JsLabel(labelName, x);
                        Map map2 = this.loopLabels;
                        JsLabel jsLabel = label;
                        map2.put(x, jsLabel);
                        ctx.replaceMe((JsNode)label);
                    }
                    Set set = this.newFakeLoops;
                    JsNameRef jsNameRef = label.getName().makeRef();
                    Intrinsics.checkExpressionValueIsNotNull(jsNameRef, "label.name.makeRef()");
                    LabeledBlockToDoWhileTransformation.access$labelLoopBreaksAndContinues(LabeledBlockToDoWhileTransformation.INSTANCE, x, set, jsNameRef);
                }
            }
            {
                this.loopStack = new Stack<E>();
                this.newFakeLoops = new HashSet<E>();
                this.loopLabels = new HashMap<K, V>();
                this.loopsToLabel = new HashSet<E>();
            }
        }.accept(root2);
    }

    private final void labelLoopBreaksAndContinues(JsStatement loop2, Set<? extends JsDoWhile> fakeLoops, JsNameRef label) {
        new JsVisitorWithContextImpl(loop2, fakeLoops, label){
            final /* synthetic */ JsStatement $loop;
            final /* synthetic */ Set $fakeLoops;
            final /* synthetic */ JsNameRef $label;

            public boolean visit(@NotNull JsWhile x, @NotNull JsContext<JsNode> ctx) {
                Intrinsics.checkParameterIsNotNull(x, "x");
                Intrinsics.checkParameterIsNotNull(ctx, "ctx");
                return this.visitLoop(x);
            }

            public boolean visit(@NotNull JsDoWhile x, @NotNull JsContext<JsNode> ctx) {
                Intrinsics.checkParameterIsNotNull(x, "x");
                Intrinsics.checkParameterIsNotNull(ctx, "ctx");
                return this.visitLoop(x);
            }

            public boolean visit(@NotNull JsFor x, @NotNull JsContext<JsNode> ctx) {
                Intrinsics.checkParameterIsNotNull(x, "x");
                Intrinsics.checkParameterIsNotNull(ctx, "ctx");
                return this.visitLoop(x);
            }

            public boolean visit(@NotNull JsForIn x, @NotNull JsContext<JsNode> ctx) {
                Intrinsics.checkParameterIsNotNull(x, "x");
                Intrinsics.checkParameterIsNotNull(ctx, "ctx");
                return this.visitLoop(x);
            }

            private final boolean visitLoop(JsStatement x) {
                return kotlin.collections.CollectionsKt.contains(this.$fakeLoops, x) || x == this.$loop;
            }

            public void endVisit(@NotNull JsBreak x, @NotNull JsContext<JsNode> ctx) {
                Intrinsics.checkParameterIsNotNull(x, "x");
                Intrinsics.checkParameterIsNotNull(ctx, "ctx");
                if (x.getLabel() == null) {
                    ctx.replaceMe((JsNode)new JsBreak(this.$label));
                }
                super.endVisit(x, ctx);
            }

            public void endVisit(@NotNull JsContinue x, @NotNull JsContext<JsNode> ctx) {
                Intrinsics.checkParameterIsNotNull(x, "x");
                Intrinsics.checkParameterIsNotNull(ctx, "ctx");
                if (x.getLabel() == null) {
                    ctx.replaceMe((JsNode)new JsContinue(this.$label));
                }
                super.endVisit(x, ctx);
            }
            {
                this.$loop = $captured_local_variable$0;
                this.$fakeLoops = $captured_local_variable$1;
                this.$label = $captured_local_variable$2;
            }
        }.accept((JsNode)loop2);
    }

    private LabeledBlockToDoWhileTransformation() {
    }

    static {
        LabeledBlockToDoWhileTransformation labeledBlockToDoWhileTransformation;
        INSTANCE = labeledBlockToDoWhileTransformation = new LabeledBlockToDoWhileTransformation();
    }

    public static final /* synthetic */ void access$labelLoopBreaksAndContinues(LabeledBlockToDoWhileTransformation $this, @NotNull JsStatement loop2, @NotNull Set fakeLoops, @NotNull JsNameRef label) {
        $this.labelLoopBreaksAndContinues(loop2, fakeLoops, label);
    }
}

