/*
 * Decompiled with CFR 0.152.
 */
package org.ice4j.ice.harvest;

import java.net.InetAddress;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.logging.Logger;
import org.bitlet.weupnp.GatewayDevice;
import org.bitlet.weupnp.GatewayDiscover;
import org.bitlet.weupnp.PortMappingEntry;
import org.ice4j.Transport;
import org.ice4j.TransportAddress;
import org.ice4j.ice.Component;
import org.ice4j.ice.HostCandidate;
import org.ice4j.ice.LocalCandidate;
import org.ice4j.ice.UPNPCandidate;
import org.ice4j.ice.harvest.CandidateHarvester;
import org.ice4j.socket.IceSocketWrapper;
import org.ice4j.socket.IceUdpSocketWrapper;
import org.ice4j.socket.MultiplexingDatagramSocket;

public class UPNPHarvester
extends CandidateHarvester {
    private static final Logger logger = Logger.getLogger(UPNPHarvester.class.getName());
    private static final int MAX_RETRIES = 5;
    private static final String stIP = "urn:schemas-upnp-org:service:WANIPConnection:1";
    private static final String stPPP = "urn:schemas-upnp-org:service:WANPPPConnection:1";
    private final Object rootSync = new Object();
    private GatewayDevice device = null;
    private int finishThreads = 0;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized Collection<LocalCandidate> harvest(Component component) {
        HashSet<LocalCandidate> candidates = new HashSet<LocalCandidate>();
        int retries = 0;
        logger.fine("Begin UPnP harvesting");
        try {
            if (this.device == null) {
                if (this.finishThreads == 0) {
                    try {
                        UPNPThread wanIPThread = new UPNPThread(stIP);
                        UPNPThread wanPPPThread = new UPNPThread(stPPP);
                        wanIPThread.start();
                        wanPPPThread.start();
                        Object object = this.rootSync;
                        synchronized (object) {
                            while (this.finishThreads != 2) {
                                this.rootSync.wait();
                            }
                        }
                        if (wanIPThread.getDevice() != null) {
                            this.device = wanIPThread.getDevice();
                        } else if (wanPPPThread.getDevice() != null) {
                            this.device = wanPPPThread.getDevice();
                        }
                    }
                    catch (Throwable e) {
                        logger.info("UPnP discovery failed: " + e);
                    }
                }
                if (this.device == null) {
                    return candidates;
                }
            }
            InetAddress localAddress = this.device.getLocalAddress();
            String externalIPAddress = this.device.getExternalIPAddress();
            PortMappingEntry portMapping = new PortMappingEntry();
            IceUdpSocketWrapper socket = new IceUdpSocketWrapper(new MultiplexingDatagramSocket(0, localAddress));
            int port = ((IceSocketWrapper)socket).getLocalPort();
            int externalPort = ((IceSocketWrapper)socket).getLocalPort();
            while (retries < 5) {
                if (!this.device.getSpecificPortMappingEntry(port, "UDP", portMapping)) {
                    if (this.device.addPortMapping(externalPort, port, localAddress.getHostAddress(), "UDP", "ice4j.org: " + port)) {
                        List<LocalCandidate> cands = this.createUPNPCandidate(socket, externalIPAddress, externalPort, component, this.device);
                        logger.info("Add UPnP port mapping: " + externalIPAddress + " " + externalPort);
                        for (LocalCandidate cand : cands) {
                            if (!component.addLocalCandidate(cand)) continue;
                            candidates.add(cand);
                        }
                        break;
                    }
                    ++port;
                } else {
                    ++port;
                }
                ++retries;
            }
        }
        catch (Throwable e) {
            logger.info("Exception while gathering UPnP candidates: " + e);
        }
        return candidates;
    }

    public List<LocalCandidate> createUPNPCandidate(IceSocketWrapper socket, String externalIP, int port, Component cmp, GatewayDevice device) throws Exception {
        ArrayList<LocalCandidate> ret = new ArrayList<LocalCandidate>();
        TransportAddress addr = new TransportAddress(externalIP, port, Transport.UDP);
        HostCandidate base = new HostCandidate(socket, cmp);
        UPNPCandidate candidate = new UPNPCandidate(addr, base, cmp, device);
        IceSocketWrapper stunSocket = candidate.getStunSocket(null);
        candidate.getStunStack().addSocket(stunSocket);
        ret.add(candidate);
        ret.add(base);
        return ret;
    }

    public String toString() {
        return this.getClass().getSimpleName();
    }

    private class UPNPThread
    extends Thread {
        private GatewayDevice device = null;
        private final String st;

        public UPNPThread(String st) {
            this.st = st;
        }

        public GatewayDevice getDevice() {
            return this.device;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            Object gd;
            try {
                gd = new GatewayDiscover(this.st);
                gd.discover();
                if (gd.getValidGateway() != null) {
                    this.device = gd.getValidGateway();
                }
            }
            catch (Throwable e) {
                logger.info("Failed to harvest UPnP: " + e);
                if (e instanceof ThreadDeath) {
                    throw (ThreadDeath)e;
                }
            }
            finally {
                gd = UPNPHarvester.this.rootSync;
                synchronized (gd) {
                    UPNPHarvester.this.finishThreads++;
                    UPNPHarvester.this.rootSync.notify();
                }
            }
        }
    }
}

