/*
 * Decompiled with CFR 0.152.
 */
package com.sun.prism.es2;

import com.sun.prism.RenderTarget;
import com.sun.prism.Texture;
import com.sun.prism.es2.ES2Context;
import com.sun.prism.es2.GLContext;
import com.sun.prism.impl.ps.BaseShaderGraphics;
import com.sun.prism.paint.Color;
import com.sun.prism.paint.Paint;

public class ES2Graphics
extends BaseShaderGraphics {
    private final ES2Context context;

    private ES2Graphics(ES2Context eS2Context, RenderTarget renderTarget) {
        super(eS2Context, renderTarget);
        this.context = eS2Context;
    }

    static ES2Graphics create(ES2Context eS2Context, RenderTarget renderTarget) {
        if (renderTarget == null) {
            return null;
        }
        return new ES2Graphics(eS2Context, renderTarget);
    }

    static void clearBuffers(ES2Context eS2Context, Color color, boolean bl, boolean bl2, boolean bl3) {
        eS2Context.getGLContext().clearBuffers(color, bl, bl2, bl3);
    }

    public void copyTexture(Texture texture, float f, float f2, float f3, float f4, float f5, float f6, float f7, float f8) {
        GLContext gLContext = this.context.getGLContext();
        gLContext.blendFunc(1, 0);
        this.drawTexture(texture, f, f2, f3, f4, f5, f6, f7, f8);
        this.context.flushVertexBuffer();
        gLContext.blendFunc(1, 7);
    }

    @Override
    public void clearQuad(float f, float f2, float f3, float f4) {
        this.context.setRenderTarget(this);
        this.context.flushVertexBuffer();
        GLContext gLContext = this.context.getGLContext();
        gLContext.blendFunc(0, 0);
        Paint paint = this.getPaint();
        this.setPaint(Color.BLACK);
        this.fillQuad(f, f2, f3, f4);
        this.context.flushVertexBuffer();
        this.setPaint(paint);
        gLContext.blendFunc(1, 7);
    }

    @Override
    public void clear(Color color) {
        this.context.validateClearOp(this);
        this.getRenderTarget().setOpaque(color.isOpaque());
        ES2Graphics.clearBuffers(this.context, color, true, this.isDepthBuffer(), false);
    }

    @Override
    public void sync() {
        this.context.flushVertexBuffer();
        this.context.getGLContext().finish();
    }

    @Override
    public void reset() {
        this.forceRenderTarget();
    }

    void forceRenderTarget() {
        this.context.forceRenderTarget(this);
    }
}

