/*
 * Decompiled with CFR 0.152.
 */
package javafx.animation;

import com.sun.javafx.animation.TickCalculation;
import com.sun.javafx.collections.TrackableObservableList;
import javafx.animation.Animation;
import javafx.animation.Interpolator;
import javafx.animation.Transition;
import javafx.beans.InvalidationListener;
import javafx.beans.Observable;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.collections.ListChangeListener;
import javafx.collections.ObservableList;
import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.scene.Node;
import javafx.util.Duration;

public final class ParallelTransition
extends Transition {
    private static final Animation[] EMPTY_ANIMATION_ARRAY = new Animation[0];
    private static final double EPSILON = 1.0E-12;
    private Animation[] cachedChildren = EMPTY_ANIMATION_ARRAY;
    private long[] durations;
    private long[] delays;
    private double[] rates;
    private long[] offsetTicks;
    private boolean[] forceChildSync;
    private long oldTicks;
    private boolean childrenChanged = true;
    private final InvalidationListener childrenListener = new InvalidationListener(){

        @Override
        public void invalidated(Observable observable) {
            ParallelTransition.this.childrenChanged = true;
            if (ParallelTransition.this.getStatus() == Animation.Status.STOPPED) {
                ParallelTransition.this.setCycleDuration(ParallelTransition.this.computeCycleDuration());
            }
        }
    };
    private ObjectProperty<Node> node;
    private static final Node DEFAULT_NODE = null;
    private final ObservableList<Animation> children = new TrackableObservableList<Animation>(){

        @Override
        protected void onChanged(ListChangeListener.Change<Animation> change) {
            while (change.next()) {
                for (Animation animation : change.getRemoved()) {
                    if (animation instanceof Transition) {
                        Transition transition = (Transition)animation;
                        if (transition.parent == ParallelTransition.this) {
                            transition.parent = null;
                        }
                    }
                    animation.rateProperty().removeListener(ParallelTransition.this.childrenListener);
                    animation.totalDurationProperty().removeListener(ParallelTransition.this.childrenListener);
                    animation.delayProperty().removeListener(ParallelTransition.this.childrenListener);
                }
                for (Animation animation : change.getAddedSubList()) {
                    if (animation instanceof Transition) {
                        ((Transition)animation).parent = ParallelTransition.this;
                    }
                    animation.rateProperty().addListener(ParallelTransition.this.childrenListener);
                    animation.totalDurationProperty().addListener(ParallelTransition.this.childrenListener);
                    animation.delayProperty().addListener(ParallelTransition.this.childrenListener);
                }
            }
            ParallelTransition.this.childrenListener.invalidated(ParallelTransition.this.children);
        }
    };

    public final void setNode(Node node) {
        if (this.node != null || node != null) {
            this.nodeProperty().set(node);
        }
    }

    public final Node getNode() {
        return this.node == null ? DEFAULT_NODE : (Node)this.node.get();
    }

    public final ObjectProperty<Node> nodeProperty() {
        if (this.node == null) {
            this.node = new SimpleObjectProperty<Node>(this, "node", DEFAULT_NODE);
        }
        return this.node;
    }

    public final ObservableList<Animation> getChildren() {
        return this.children;
    }

    public ParallelTransition(Node node, Animation ... animationArray) {
        this.setInterpolator(Interpolator.LINEAR);
        this.setNode(node);
        this.getChildren().setAll((Animation[])animationArray);
    }

    public ParallelTransition(Animation ... animationArray) {
        this((Node)null, animationArray);
    }

    public ParallelTransition(Node node) {
        this.setInterpolator(Interpolator.LINEAR);
        this.setNode(node);
    }

    public ParallelTransition() {
        this((Node)null);
    }

    @Override
    protected Node getParentTargetNode() {
        Node node = this.getNode();
        return node != null ? node : (this.parent != null ? this.parent.getParentTargetNode() : null);
    }

    private Duration computeCycleDuration() {
        Duration duration = Duration.ZERO;
        for (Animation animation : this.getChildren()) {
            double d = Math.abs(animation.getRate());
            Duration duration2 = d < 1.0E-12 ? animation.getTotalDuration() : animation.getTotalDuration().divide(d);
            Duration duration3 = duration2.add(animation.getDelay());
            if (duration3.isIndefinite()) {
                return Duration.INDEFINITE;
            }
            if (!duration3.greaterThan(duration)) continue;
            duration = duration3;
        }
        return duration;
    }

    private double calculateFraction(long l, long l2) {
        double d = (double)l / (double)l2;
        return d <= 0.0 ? 0.0 : (d >= 1.0 ? 1.0 : d);
    }

    private boolean startChild(Animation animation, int n) {
        boolean bl = this.forceChildSync[n];
        if (animation.impl_startable(bl)) {
            animation.setRate(this.rates[n] * Math.signum(this.getCurrentRate()));
            animation.impl_start(bl);
            this.forceChildSync[n] = false;
            return true;
        }
        return false;
    }

    @Override
    void impl_sync(boolean bl) {
        super.impl_sync(bl);
        if (bl && this.childrenChanged || this.durations == null) {
            this.cachedChildren = this.getChildren().toArray(EMPTY_ANIMATION_ARRAY);
            int n = this.cachedChildren.length;
            this.durations = new long[n];
            this.delays = new long[n];
            this.rates = new double[n];
            this.offsetTicks = new long[n];
            this.forceChildSync = new boolean[n];
            int n2 = 0;
            for (Animation animation : this.cachedChildren) {
                this.rates[n2] = animation.getRate();
                if (this.rates[n2] < 1.0E-12) {
                    this.rates[n2] = 1.0;
                }
                this.durations[n2] = TickCalculation.fromDuration(animation.getTotalDuration(), this.rates[n2]);
                this.delays[n2] = TickCalculation.fromDuration(animation.getDelay());
                this.forceChildSync[n2] = true;
                ++n2;
            }
            this.childrenChanged = false;
        } else if (bl) {
            int n = this.forceChildSync.length;
            for (int i = 0; i < n; ++i) {
                this.forceChildSync[i] = true;
            }
        }
    }

    @Override
    void impl_pause() {
        super.impl_pause();
        for (Animation animation : this.cachedChildren) {
            if (animation.getStatus() != Animation.Status.RUNNING) continue;
            animation.impl_pause();
        }
    }

    @Override
    void impl_resume() {
        super.impl_resume();
        for (Animation animation : this.cachedChildren) {
            if (animation.getStatus() != Animation.Status.PAUSED) continue;
            animation.impl_resume();
        }
    }

    @Override
    void impl_stop() {
        super.impl_stop();
        for (Animation animation : this.cachedChildren) {
            if (animation.getStatus() == Animation.Status.STOPPED) continue;
            animation.impl_stop();
        }
        if (this.childrenChanged) {
            this.setCycleDuration(this.computeCycleDuration());
        }
    }

    @Override
    @Deprecated
    public void impl_playTo(long l, long l2) {
        this.impl_setCurrentTicks(l);
        double d = this.calculateFraction(l, l2);
        long l3 = Math.max(0L, Math.min(this.getCachedInterpolator().interpolate(0L, l2, d), l2));
        if (this.getCurrentRate() > 0.0) {
            int n = 0;
            for (Animation animation : this.cachedChildren) {
                if (l3 >= this.delays[n] && (this.oldTicks <= this.delays[n] || this.oldTicks < TickCalculation.add(this.delays[n], this.durations[n]) && animation.getStatus() == Animation.Status.STOPPED)) {
                    boolean bl;
                    boolean bl2 = bl = this.oldTicks <= this.delays[n];
                    if (bl) {
                        animation.jumpTo(Duration.ZERO);
                    }
                    if (!this.startChild(animation, n)) {
                        EventHandler<ActionEvent> eventHandler;
                        if (!bl || (eventHandler = animation.getOnFinished()) == null) continue;
                        eventHandler.handle(new ActionEvent(this, null));
                        continue;
                    }
                }
                if (l3 >= TickCalculation.add(this.durations[n], this.delays[n])) {
                    if (animation.getStatus() == Animation.Status.RUNNING) {
                        animation.impl_timePulse(this.calcTimePulse(this.durations[n], n));
                        this.offsetTicks[n] = 0L;
                    }
                } else if (l3 > this.delays[n]) {
                    animation.impl_timePulse(this.calcTimePulse(TickCalculation.sub(l3, this.delays[n]), n));
                }
                ++n;
            }
        } else {
            int n = 0;
            for (Animation animation : this.cachedChildren) {
                if (l3 < TickCalculation.add(this.durations[n], this.delays[n])) {
                    if (this.oldTicks >= TickCalculation.add(this.durations[n], this.delays[n]) || this.oldTicks >= this.delays[n] && animation.getStatus() == Animation.Status.STOPPED) {
                        boolean bl;
                        boolean bl3 = bl = this.oldTicks >= TickCalculation.add(this.durations[n], this.delays[n]);
                        if (bl) {
                            animation.jumpTo(TickCalculation.toDuration(this.durations[n], this.rates[n]));
                        }
                        if (!this.startChild(animation, n)) {
                            EventHandler<ActionEvent> eventHandler;
                            if (!bl || (eventHandler = animation.getOnFinished()) == null) continue;
                            eventHandler.handle(new ActionEvent(this, null));
                            continue;
                        }
                    }
                    if (l3 <= this.delays[n]) {
                        if (animation.getStatus() == Animation.Status.RUNNING) {
                            animation.impl_timePulse(this.calcTimePulse(this.durations[n], n));
                            this.offsetTicks[n] = 0L;
                        }
                    } else {
                        animation.impl_timePulse(this.calcTimePulse(TickCalculation.sub(TickCalculation.add(this.durations[n], this.delays[n]), l3), n));
                    }
                }
                ++n;
            }
        }
        this.oldTicks = l3;
    }

    @Override
    @Deprecated
    public void impl_jumpTo(long l, long l2) {
        this.impl_sync(false);
        double d = this.calculateFraction(l, l2);
        long l3 = Math.max(0L, Math.min(this.getCachedInterpolator().interpolate(0L, l2, d), l2));
        int n = 0;
        for (Animation animation : this.cachedChildren) {
            if (l3 <= this.delays[n]) {
                this.offsetTicks[n] = 0L;
                animation.jumpTo(Duration.ZERO);
                if (animation.getStatus() != Animation.Status.STOPPED && this.getCurrentRate() < 0.0) {
                    animation.impl_finished();
                }
            } else if (l3 >= TickCalculation.add(this.durations[n], this.delays[n])) {
                this.offsetTicks[n] = 0L;
                animation.jumpTo(TickCalculation.toDuration(this.durations[n], this.rates[n]));
                if (animation.getStatus() != Animation.Status.STOPPED && this.getCurrentRate() > 0.0) {
                    animation.impl_finished();
                }
            } else {
                this.offsetTicks[n] = this.getCurrentRate() < 0.0 ? TickCalculation.sub(TickCalculation.add(this.durations[n], this.delays[n]), l3) : TickCalculation.sub(l3, this.delays[n]);
                animation.jumpTo(TickCalculation.toDuration(TickCalculation.sub(l3, this.delays[n]), this.rates[n]));
            }
            ++n;
        }
        this.oldTicks = l3;
    }

    @Override
    protected void interpolate(double d) {
    }

    private long calcTimePulse(long l, int n) {
        return TickCalculation.sub(Math.round((double)l * Math.abs(this.rates[n])), this.offsetTicks[n]);
    }
}

