/*
 * Decompiled with CFR 0.152.
 */
package javafx.scene.control;

import com.sun.javafx.collections.TrackableObservableList;
import com.sun.javafx.css.StyleableProperty;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.collections.ListChangeListener;
import javafx.collections.ObservableList;
import javafx.scene.control.Control;
import javafx.scene.control.TitledPane;

public class Accordion
extends Control {
    private final ObservableList<TitledPane> panes = new TrackableObservableList<TitledPane>(){

        @Override
        protected void onChanged(ListChangeListener.Change<TitledPane> change) {
            block0: while (change.next()) {
                if (!change.wasRemoved() || Accordion.this.expandedPane.isBound()) continue;
                for (TitledPane titledPane : change.getRemoved()) {
                    if (change.getAddedSubList().contains(titledPane) || Accordion.this.getExpandedPane() != titledPane) continue;
                    Accordion.this.setExpandedPane(null);
                    continue block0;
                }
            }
        }
    };
    private ObjectProperty<TitledPane> expandedPane = new SimpleObjectProperty<TitledPane>((Object)this, "expandedPane"){

        @Override
        public void set(TitledPane titledPane) {
            if (this.isBound()) {
                throw new RuntimeException("A bound value cannot be set.");
            }
            if (titledPane != null) {
                titledPane.setExpanded(true);
            } else {
                TitledPane titledPane2 = (TitledPane)this.get();
                if (titledPane2 != null) {
                    titledPane2.setExpanded(false);
                }
            }
            super.set(titledPane);
        }
    };
    private static final String DEFAULT_STYLE_CLASS = "accordion";

    public Accordion() {
        this.getStyleClass().setAll((String[])new String[]{DEFAULT_STYLE_CLASS});
        StyleableProperty styleableProperty = StyleableProperty.getStyleableProperty(this.focusTraversableProperty());
        styleableProperty.set(this, Boolean.FALSE);
    }

    public final void setExpandedPane(TitledPane titledPane) {
        this.expandedPaneProperty().set(titledPane);
    }

    public final TitledPane getExpandedPane() {
        return (TitledPane)this.expandedPane.get();
    }

    public final ObjectProperty<TitledPane> expandedPaneProperty() {
        return this.expandedPane;
    }

    public final ObservableList<TitledPane> getPanes() {
        return this.panes;
    }

    @Override
    @Deprecated
    protected Boolean impl_cssGetFocusTraversableInitialValue() {
        return Boolean.FALSE;
    }
}

