"use strict";
var __extends = (this && this.__extends) || (function () {
    var extendStatics = Object.setPrototypeOf ||
        ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
        function (d, b) { for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p]; };
    return function (d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
Object.defineProperty(exports, "__esModule", { value: true });
var date = require('date-and-time');
var ts = require("./typesystem");
var messageRegistry = ts.messageRegistry;
function checkDate(dateStr) {
    return checkDateOnlyString(dateStr, "YYYY-MM-DD");
}
var DateOnlyR = /** @class */ (function (_super) {
    __extends(DateOnlyR, _super);
    function DateOnlyR() {
        return _super !== null && _super.apply(this, arguments) || this;
    }
    DateOnlyR.prototype.check = function (value) {
        if (typeof value == "string") {
            if (!checkDate(value)) {
                return ts.error(messageRegistry.INVALID_DATEONLY, this);
            }
            return ts.ok();
        }
        return ts.error(messageRegistry.INVALID_DATEONLY, this);
    };
    DateOnlyR.prototype.requiredType = function () {
        return ts.STRING;
    };
    DateOnlyR.prototype.value = function () {
        return true;
    };
    DateOnlyR.prototype.facetName = function () {
        return "should be date-only";
    };
    return DateOnlyR;
}(ts.GenericTypeOf));
exports.DateOnlyR = DateOnlyR;
function checkTime(time) {
    var dateStr = "11 " + time.trim();
    var dateFormat = "YY HH:mm:ss";
    if (!date.isValid(dateStr, dateFormat)) {
        return false;
    }
    var parsedDate = date.parse(dateStr, dateFormat, false);
    var serializedDate = date.format(parsedDate, dateFormat, false);
    return serializedDate.trim() == dateStr.trim();
}
var TimeOnlyR = /** @class */ (function (_super) {
    __extends(TimeOnlyR, _super);
    function TimeOnlyR() {
        return _super !== null && _super.apply(this, arguments) || this;
    }
    TimeOnlyR.prototype.check = function (value) {
        if (typeof value == "string") {
            var regexp = /^([0-9][0-9]:[0-9][0-9]:[0-9][0-9])(.[0-9]+)?$/;
            var matches = value.match(regexp);
            if (!matches) {
                return ts.error(messageRegistry.INVALID_TIMEONLY, this);
            }
            var hhmmssTime = matches[1];
            if (!checkTime(hhmmssTime)) {
                return ts.error(messageRegistry.INVALID_TIMEONLY, this);
            }
            return ts.ok();
        }
        return ts.error(messageRegistry.INVALID_TIMEONLY, this);
    };
    TimeOnlyR.prototype.requiredType = function () {
        return ts.STRING;
    };
    TimeOnlyR.prototype.value = function () {
        return true;
    };
    TimeOnlyR.prototype.facetName = function () {
        return "should be time-only";
    };
    return TimeOnlyR;
}(ts.GenericTypeOf));
exports.TimeOnlyR = TimeOnlyR;
var DateTimeOnlyR = /** @class */ (function (_super) {
    __extends(DateTimeOnlyR, _super);
    function DateTimeOnlyR() {
        return _super !== null && _super.apply(this, arguments) || this;
    }
    DateTimeOnlyR.prototype.check = function (value) {
        if (typeof value == "string") {
            var regexp = /^(\d{4}-\d{2}-\d{2})T([0-9][0-9]:[0-9][0-9]:[0-9][0-9])(.[0-9]+)?$/;
            var matches = value.match(regexp);
            if (!matches || matches.length < 3) {
                return ts.error(messageRegistry.INVALID_DATETIMEONLY, this);
            }
            var date = matches[1];
            var time = matches[2];
            if (!checkDate(date) || !checkTime(time)) {
                return ts.error(messageRegistry.INVALID_DATETIMEONLY, this);
            }
            return ts.ok();
        }
        return ts.error(messageRegistry.INVALID_DATETIMEONLY, this);
    };
    DateTimeOnlyR.prototype.requiredType = function () {
        return ts.STRING;
    };
    DateTimeOnlyR.prototype.value = function () {
        return true;
    };
    DateTimeOnlyR.prototype.facetName = function () {
        return "should be datetime-only";
    };
    return DateTimeOnlyR;
}(ts.GenericTypeOf));
exports.DateTimeOnlyR = DateTimeOnlyR;
var r1 = /(Mon|Tue|Wed|Thu|Fri|Sat|Sun)\,[ ]+\d{2}[ ]+(Jan|Feb|Mar|Apr|May|Jun|Jul|Aug|Sep|Oct|Nov|Dec)[ ]+\d{4}[ ]+\d{2}:\d{2}:\d{2}[ ]+GMT/;
var r2 = /(Monday|Tuesday|Wednesday|Thursday|Friday|Saturday|Sunday)\,[ ]+\d{2}-(Jan|Feb|Mar|Apr|May|Jun|Jul|Aug|Sep|Oct|Nov|Dec)-\d{2}[ ]+\d{2}:\d{2}:\d{2}[ ]+GMT/;
var r3 = /(Mon|Tue|Wed|Thu|Fri|Sat|Sun)\,[ ]+(Jan|Feb|Mar|Apr|May|Jun|Jul|Aug|Sep|Oct|Nov|Dec)[ ]+\d{1,2}[ ]+\d{2}:\d{2}:\d{2}[ ]+GMT/;
var r0 = /^(\d{4}-\d{2}-\d{2})T(\d{2}:\d{2}:\d{2})(?:\.\d+)?((?:[\+\-]\d{2}:\d{2})|Z)$/;
var DateTimeR = /** @class */ (function (_super) {
    __extends(DateTimeR, _super);
    function DateTimeR() {
        return _super !== null && _super.apply(this, arguments) || this;
    }
    DateTimeR.prototype.check = function (value) {
        var c = ts.VALIDATED_TYPE;
        var rfc2616 = false;
        c.allFacets().forEach(function (x) {
            if (x.facetName() == "format") {
                if (x.value() === "rfc2616") {
                    rfc2616 = true;
                }
            }
        });
        if (typeof value == "string") {
            if (!rfc2616) {
                var rfc3339Matches = value.match(r0);
                if (!rfc3339Matches || rfc3339Matches.length < 3) {
                    return ts.error(messageRegistry.INVALID_RFC3339, this);
                }
                else {
                    var date = rfc3339Matches[1];
                    var time = rfc3339Matches[2];
                    if (!checkDate(date) || !checkTime(time)) {
                        return ts.error(messageRegistry.INVALID_RFC3339, this);
                    }
                }
                return ts.ok();
            }
            else {
                if (!(value.match(r1) || value.match(r2) || value.match(r3))) {
                    return ts.error(messageRegistry.INVALID_RFC2616, this);
                }
            }
            return ts.ok();
        }
        return ts.error(messageRegistry.INVALID_DATTIME, this);
    };
    DateTimeR.prototype.requiredType = function () {
        return ts.STRING;
    };
    DateTimeR.prototype.value = function () {
        return true;
    };
    DateTimeR.prototype.facetName = function () {
        return "should be datetime-only";
    };
    return DateTimeR;
}(ts.GenericTypeOf));
exports.DateTimeR = DateTimeR;
function checkDateOnlyString(dateStr, dateFormat) {
    var regexp = /^(\d{4})-\d{2}-\d{2}$/;
    var matches = dateStr.match(regexp);
    if (!matches || matches.length != 2) {
        return false;
    }
    var parsedYear = parseInt(matches[1]);
    if ((parsedYear < 70 || parsedYear > 99) && !date.isValid(dateStr, dateFormat)) {
        return false;
    }
    return true;
}
//# sourceMappingURL=datetime.js.map