/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core.ml;

import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.elasticsearch.ResourceAlreadyExistsException;
import org.elasticsearch.ResourceNotFoundException;
import org.elasticsearch.Version;
import org.elasticsearch.cluster.AbstractDiffable;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.Diff;
import org.elasticsearch.cluster.DiffableUtils;
import org.elasticsearch.cluster.NamedDiff;
import org.elasticsearch.cluster.metadata.MetaData;
import org.elasticsearch.common.Nullable;
import org.elasticsearch.common.ParseField;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Writeable;
import org.elasticsearch.common.xcontent.ObjectParser;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.persistent.PersistentTasksCustomMetaData;
import org.elasticsearch.xpack.core.ClientHelper;
import org.elasticsearch.xpack.core.XPackPlugin;
import org.elasticsearch.xpack.core.ml.MlTasks;
import org.elasticsearch.xpack.core.ml.datafeed.DatafeedConfig;
import org.elasticsearch.xpack.core.ml.datafeed.DatafeedJobValidator;
import org.elasticsearch.xpack.core.ml.datafeed.DatafeedState;
import org.elasticsearch.xpack.core.ml.datafeed.DatafeedUpdate;
import org.elasticsearch.xpack.core.ml.job.config.Job;
import org.elasticsearch.xpack.core.ml.job.config.JobState;
import org.elasticsearch.xpack.core.ml.job.config.JobTaskState;
import org.elasticsearch.xpack.core.ml.job.groups.GroupOrJobLookup;
import org.elasticsearch.xpack.core.ml.job.messages.Messages;
import org.elasticsearch.xpack.core.ml.utils.ExceptionsHelper;
import org.elasticsearch.xpack.core.ml.utils.NameResolver;

public class MlMetadata
implements XPackPlugin.XPackMetaDataCustom {
    public static final String TYPE = "ml";
    private static final ParseField JOBS_FIELD = new ParseField("jobs", new String[0]);
    private static final ParseField DATAFEEDS_FIELD = new ParseField("datafeeds", new String[0]);
    public static final MlMetadata EMPTY_METADATA = new MlMetadata(Collections.emptySortedMap(), Collections.emptySortedMap());
    public static final ObjectParser<Builder, Void> METADATA_PARSER = new ObjectParser("ml_metadata", true, Builder::new);
    private final SortedMap<String, Job> jobs;
    private final SortedMap<String, DatafeedConfig> datafeeds;
    private final GroupOrJobLookup groupOrJobLookup;

    private MlMetadata(SortedMap<String, Job> jobs, SortedMap<String, DatafeedConfig> datafeeds) {
        this.jobs = Collections.unmodifiableSortedMap(jobs);
        this.datafeeds = Collections.unmodifiableSortedMap(datafeeds);
        this.groupOrJobLookup = new GroupOrJobLookup(jobs.values());
    }

    public Map<String, Job> getJobs() {
        return this.jobs;
    }

    public boolean isGroupOrJob(String id) {
        return this.groupOrJobLookup.isGroupOrJob(id);
    }

    public Set<String> expandJobIds(String expression, boolean allowNoJobs) {
        return this.groupOrJobLookup.expandJobIds(expression, allowNoJobs);
    }

    public boolean isJobDeleted(String jobId) {
        Job job = (Job)((Object)this.jobs.get(jobId));
        return job == null || job.isDeleted();
    }

    public SortedMap<String, DatafeedConfig> getDatafeeds() {
        return this.datafeeds;
    }

    public DatafeedConfig getDatafeed(String datafeedId) {
        return (DatafeedConfig)((Object)this.datafeeds.get(datafeedId));
    }

    public Optional<DatafeedConfig> getDatafeedByJobId(String jobId) {
        return this.datafeeds.values().stream().filter(s -> s.getJobId().equals(jobId)).findFirst();
    }

    public Set<String> expandDatafeedIds(String expression, boolean allowNoDatafeeds) {
        return NameResolver.newUnaliased(this.datafeeds.keySet(), ExceptionsHelper::missingDatafeedException).expand(expression, allowNoDatafeeds);
    }

    public Version getMinimalSupportedVersion() {
        return Version.V_5_4_0;
    }

    public String getWriteableName() {
        return TYPE;
    }

    public EnumSet<MetaData.XContentContext> context() {
        return MetaData.ALL_CONTEXTS;
    }

    public Diff<MetaData.Custom> diff(MetaData.Custom previousState) {
        return new MlMetadataDiff((MlMetadata)previousState, this);
    }

    public MlMetadata(StreamInput in) throws IOException {
        int size = in.readVInt();
        TreeMap<String, Job> jobs = new TreeMap<String, Job>();
        for (int i = 0; i < size; ++i) {
            jobs.put(in.readString(), new Job(in));
        }
        this.jobs = jobs;
        size = in.readVInt();
        TreeMap<String, DatafeedConfig> datafeeds = new TreeMap<String, DatafeedConfig>();
        for (int i = 0; i < size; ++i) {
            datafeeds.put(in.readString(), new DatafeedConfig(in));
        }
        this.datafeeds = datafeeds;
        this.groupOrJobLookup = new GroupOrJobLookup(jobs.values());
    }

    public void writeTo(StreamOutput out) throws IOException {
        MlMetadata.writeMap(this.jobs, out);
        MlMetadata.writeMap(this.datafeeds, out);
    }

    private static <T extends Writeable> void writeMap(Map<String, T> map, StreamOutput out) throws IOException {
        out.writeVInt(map.size());
        for (Map.Entry<String, T> entry : map.entrySet()) {
            out.writeString(entry.getKey());
            ((Writeable)entry.getValue()).writeTo(out);
        }
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        ToXContent.DelegatingMapParams extendedParams = new ToXContent.DelegatingMapParams(Collections.singletonMap("for_cluster_state", "true"), params);
        MlMetadata.mapValuesToXContent(JOBS_FIELD, this.jobs, builder, (ToXContent.Params)extendedParams);
        MlMetadata.mapValuesToXContent(DATAFEEDS_FIELD, this.datafeeds, builder, (ToXContent.Params)extendedParams);
        return builder;
    }

    private static <T extends ToXContent> void mapValuesToXContent(ParseField field, Map<String, T> map, XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startArray(field.getPreferredName());
        for (Map.Entry<String, T> entry : map.entrySet()) {
            ((ToXContent)entry.getValue()).toXContent(builder, params);
        }
        builder.endArray();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MlMetadata that = (MlMetadata)o;
        return Objects.equals(this.jobs, that.jobs) && Objects.equals(this.datafeeds, that.datafeeds);
    }

    public final String toString() {
        return Strings.toString((ToXContent)this);
    }

    public int hashCode() {
        return Objects.hash(this.jobs, this.datafeeds);
    }

    public static MlMetadata getMlMetadata(ClusterState state) {
        MlMetadata mlMetadata;
        MlMetadata mlMetadata2 = mlMetadata = state == null ? null : (MlMetadata)state.getMetaData().custom(TYPE);
        if (mlMetadata == null) {
            return EMPTY_METADATA;
        }
        return mlMetadata;
    }

    static {
        METADATA_PARSER.declareObjectArray((rec$, x$0) -> ((Builder)rec$).putJobs(x$0), (p, c) -> ((Job.Builder)Job.METADATA_PARSER.apply(p, c)).build(), JOBS_FIELD);
        METADATA_PARSER.declareObjectArray((rec$, x$0) -> ((Builder)rec$).putDatafeeds(x$0), (p, c) -> ((DatafeedConfig.Builder)DatafeedConfig.METADATA_PARSER.apply(p, c)).build(), DATAFEEDS_FIELD);
    }

    public static class JobAlreadyMarkedAsDeletedException
    extends RuntimeException {
    }

    public static class Builder {
        private TreeMap<String, Job> jobs;
        private TreeMap<String, DatafeedConfig> datafeeds;

        public Builder() {
            this.jobs = new TreeMap();
            this.datafeeds = new TreeMap();
        }

        public Builder(@Nullable MlMetadata previous) {
            if (previous == null) {
                this.jobs = new TreeMap();
                this.datafeeds = new TreeMap();
            } else {
                this.jobs = new TreeMap(previous.jobs);
                this.datafeeds = new TreeMap(previous.datafeeds);
            }
        }

        public Builder putJob(Job job, boolean overwrite) {
            if (this.jobs.containsKey(job.getId()) && !overwrite) {
                throw ExceptionsHelper.jobAlreadyExists(job.getId());
            }
            this.jobs.put(job.getId(), job);
            return this;
        }

        public Builder deleteJob(String jobId, PersistentTasksCustomMetaData tasks) {
            this.checkJobHasNoDatafeed(jobId);
            JobState jobState = MlTasks.getJobState(jobId, tasks);
            if (!jobState.isAnyOf(JobState.CLOSED, JobState.FAILED)) {
                throw ExceptionsHelper.conflictStatusException("Unexpected job state [" + (Object)((Object)jobState) + "], expected [" + (Object)((Object)JobState.CLOSED) + " or " + (Object)((Object)JobState.FAILED) + "]", new Object[0]);
            }
            Job job = this.jobs.remove(jobId);
            if (job == null) {
                throw new ResourceNotFoundException("job [" + jobId + "] does not exist", new Object[0]);
            }
            if (!job.isDeleted()) {
                throw ExceptionsHelper.conflictStatusException("Cannot delete job [" + jobId + "] because it hasn't marked as deleted", new Object[0]);
            }
            return this;
        }

        public Builder putDatafeed(DatafeedConfig datafeedConfig, Map<String, String> headers) {
            if (this.datafeeds.containsKey(datafeedConfig.getId())) {
                throw new ResourceAlreadyExistsException("A datafeed with id [" + datafeedConfig.getId() + "] already exists", new Object[0]);
            }
            String jobId = datafeedConfig.getJobId();
            this.checkJobIsAvailableForDatafeed(jobId);
            Job job = this.jobs.get(jobId);
            DatafeedJobValidator.validate(datafeedConfig, job);
            if (!headers.isEmpty()) {
                DatafeedConfig.Builder builder = new DatafeedConfig.Builder(datafeedConfig);
                Map<String, String> securityHeaders = headers.entrySet().stream().filter(e -> ClientHelper.SECURITY_HEADER_FILTERS.contains(e.getKey())).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
                builder.setHeaders(securityHeaders);
                datafeedConfig = builder.build();
            }
            this.datafeeds.put(datafeedConfig.getId(), datafeedConfig);
            return this;
        }

        private void checkJobIsAvailableForDatafeed(String jobId) {
            Job job = this.jobs.get(jobId);
            if (job == null || job.isDeleted()) {
                throw ExceptionsHelper.missingJobException(jobId);
            }
            Optional<DatafeedConfig> existingDatafeed = this.getDatafeedByJobId(jobId);
            if (existingDatafeed.isPresent()) {
                throw ExceptionsHelper.conflictStatusException("A datafeed [" + existingDatafeed.get().getId() + "] already exists for job [" + jobId + "]", new Object[0]);
            }
        }

        public Builder updateDatafeed(DatafeedUpdate update, PersistentTasksCustomMetaData persistentTasks, Map<String, String> headers) {
            String datafeedId = update.getId();
            DatafeedConfig oldDatafeedConfig = this.datafeeds.get(datafeedId);
            if (oldDatafeedConfig == null) {
                throw ExceptionsHelper.missingDatafeedException(datafeedId);
            }
            this.checkDatafeedIsStopped(() -> Messages.getMessage("Cannot update datafeed [{0}] while its status is {1}", new Object[]{datafeedId, DatafeedState.STARTED}), datafeedId, persistentTasks);
            DatafeedConfig newDatafeedConfig = update.apply(oldDatafeedConfig, headers);
            if (!newDatafeedConfig.getJobId().equals(oldDatafeedConfig.getJobId())) {
                this.checkJobIsAvailableForDatafeed(newDatafeedConfig.getJobId());
            }
            Job job = this.jobs.get(newDatafeedConfig.getJobId());
            DatafeedJobValidator.validate(newDatafeedConfig, job);
            this.datafeeds.put(datafeedId, newDatafeedConfig);
            return this;
        }

        public Builder removeDatafeed(String datafeedId, PersistentTasksCustomMetaData persistentTasks) {
            DatafeedConfig datafeed = this.datafeeds.get(datafeedId);
            if (datafeed == null) {
                throw ExceptionsHelper.missingDatafeedException(datafeedId);
            }
            this.checkDatafeedIsStopped(() -> Messages.getMessage("Cannot delete datafeed [{0}] while its status is {1}", new Object[]{datafeedId, DatafeedState.STARTED}), datafeedId, persistentTasks);
            this.datafeeds.remove(datafeedId);
            return this;
        }

        private Optional<DatafeedConfig> getDatafeedByJobId(String jobId) {
            return this.datafeeds.values().stream().filter(s -> s.getJobId().equals(jobId)).findFirst();
        }

        private void checkDatafeedIsStopped(Supplier<String> msg, String datafeedId, PersistentTasksCustomMetaData persistentTasks) {
            if (persistentTasks != null && persistentTasks.getTask(MlTasks.datafeedTaskId(datafeedId)) != null) {
                throw ExceptionsHelper.conflictStatusException(msg.get(), new Object[0]);
            }
        }

        private Builder putJobs(Collection<Job> jobs) {
            for (Job job : jobs) {
                this.putJob(job, true);
            }
            return this;
        }

        private Builder putDatafeeds(Collection<DatafeedConfig> datafeeds) {
            for (DatafeedConfig datafeed : datafeeds) {
                this.datafeeds.put(datafeed.getId(), datafeed);
            }
            return this;
        }

        public MlMetadata build() {
            return new MlMetadata(this.jobs, this.datafeeds);
        }

        public void markJobAsDeleted(String jobId, PersistentTasksCustomMetaData tasks, boolean allowDeleteOpenJob) {
            PersistentTasksCustomMetaData.PersistentTask<?> jobTask;
            Job job = this.jobs.get(jobId);
            if (job == null) {
                throw ExceptionsHelper.missingJobException(jobId);
            }
            if (job.isDeleted()) {
                throw new JobAlreadyMarkedAsDeletedException();
            }
            this.checkJobHasNoDatafeed(jobId);
            if (!allowDeleteOpenJob && (jobTask = MlTasks.getJobTask(jobId, tasks)) != null) {
                JobTaskState jobTaskState = (JobTaskState)jobTask.getState();
                throw ExceptionsHelper.conflictStatusException("Cannot delete job [" + jobId + "] because the job is " + (Object)((Object)(jobTaskState == null ? JobState.OPENING : jobTaskState.getState())), new Object[0]);
            }
            Job.Builder jobBuilder = new Job.Builder(job);
            jobBuilder.setDeleted(true);
            this.putJob(jobBuilder.build(), true);
        }

        void checkJobHasNoDatafeed(String jobId) {
            Optional<DatafeedConfig> datafeed = this.getDatafeedByJobId(jobId);
            if (datafeed.isPresent()) {
                throw ExceptionsHelper.conflictStatusException("Cannot delete job [" + jobId + "] because datafeed [" + datafeed.get().getId() + "] refers to it", new Object[0]);
            }
        }
    }

    public static class MlMetadataDiff
    implements NamedDiff<MetaData.Custom> {
        final Diff<Map<String, Job>> jobs;
        final Diff<Map<String, DatafeedConfig>> datafeeds;

        MlMetadataDiff(MlMetadata before, MlMetadata after) {
            this.jobs = DiffableUtils.diff((Map)before.jobs, (Map)after.jobs, (DiffableUtils.KeySerializer)DiffableUtils.getStringKeySerializer());
            this.datafeeds = DiffableUtils.diff((Map)before.datafeeds, (Map)after.datafeeds, (DiffableUtils.KeySerializer)DiffableUtils.getStringKeySerializer());
        }

        public MlMetadataDiff(StreamInput in) throws IOException {
            this.jobs = DiffableUtils.readJdkMapDiff((StreamInput)in, (DiffableUtils.KeySerializer)DiffableUtils.getStringKeySerializer(), Job::new, MlMetadataDiff::readJobDiffFrom);
            this.datafeeds = DiffableUtils.readJdkMapDiff((StreamInput)in, (DiffableUtils.KeySerializer)DiffableUtils.getStringKeySerializer(), DatafeedConfig::new, MlMetadataDiff::readSchedulerDiffFrom);
        }

        public MetaData.Custom apply(MetaData.Custom part) {
            TreeMap newJobs = new TreeMap((Map)this.jobs.apply((Object)((MlMetadata)part).jobs));
            TreeMap newDatafeeds = new TreeMap((Map)this.datafeeds.apply((Object)((MlMetadata)part).datafeeds));
            return new MlMetadata(newJobs, newDatafeeds);
        }

        public void writeTo(StreamOutput out) throws IOException {
            this.jobs.writeTo(out);
            this.datafeeds.writeTo(out);
        }

        public String getWriteableName() {
            return MlMetadata.TYPE;
        }

        static Diff<Job> readJobDiffFrom(StreamInput in) throws IOException {
            return AbstractDiffable.readDiffFrom(Job::new, (StreamInput)in);
        }

        static Diff<DatafeedConfig> readSchedulerDiffFrom(StreamInput in) throws IOException {
            return AbstractDiffable.readDiffFrom(DatafeedConfig::new, (StreamInput)in);
        }
    }
}

