/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.watcher.history;

import java.io.IOException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.apache.logging.log4j.message.ParameterizedMessage;
import org.elasticsearch.action.DocWriteRequest;
import org.elasticsearch.action.index.IndexRequest;
import org.elasticsearch.client.Client;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.metadata.IndexMetaData;
import org.elasticsearch.common.component.AbstractComponent;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.util.concurrent.ThreadContext;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentFactory;
import org.elasticsearch.index.engine.VersionConflictEngineException;
import org.elasticsearch.xpack.core.ClientHelper;
import org.elasticsearch.xpack.core.watcher.execution.ExecutionState;
import org.elasticsearch.xpack.core.watcher.history.HistoryStoreField;
import org.elasticsearch.xpack.core.watcher.history.WatchRecord;
import org.elasticsearch.xpack.core.watcher.support.Exceptions;
import org.elasticsearch.xpack.core.watcher.support.xcontent.WatcherParams;
import org.elasticsearch.xpack.watcher.watch.WatchStoreUtils;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;

public class HistoryStore
extends AbstractComponent
implements AutoCloseable {
    private final Client client;
    private final ReadWriteLock readWriteLock = new ReentrantReadWriteLock();
    private final Lock putUpdateLock = this.readWriteLock.readLock();
    private final Lock stopLock = this.readWriteLock.writeLock();

    public HistoryStore(Settings settings, Client client) {
        super(settings);
        this.client = client;
    }

    @Override
    public void close() {
        this.stopLock.lock();
        this.stopLock.unlock();
    }

    public void put(WatchRecord watchRecord) throws Exception {
        String index = HistoryStoreField.getHistoryIndexNameForTime((DateTime)watchRecord.triggerEvent().triggeredTime());
        this.putUpdateLock.lock();
        try (XContentBuilder builder = XContentFactory.jsonBuilder();
             ThreadContext.StoredContext ignore = ClientHelper.stashWithOrigin((ThreadContext)this.client.threadPool().getThreadContext(), (String)"watcher");){
            watchRecord.toXContent(builder, (ToXContent.Params)WatcherParams.HIDE_SECRETS);
            IndexRequest request = new IndexRequest(index, "doc", watchRecord.id().value()).source(builder).opType(DocWriteRequest.OpType.CREATE);
            this.client.index(request).actionGet(30L, TimeUnit.SECONDS);
            this.logger.debug("indexed watch history record [{}]", (Object)watchRecord.id().value());
        }
        catch (IOException ioe) {
            throw Exceptions.ioException((String)"failed to persist watch record [{}]", (Throwable)ioe, (Object[])new Object[]{watchRecord});
        }
        finally {
            this.putUpdateLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void forcePut(WatchRecord watchRecord) {
        String index = HistoryStoreField.getHistoryIndexNameForTime((DateTime)watchRecord.triggerEvent().triggeredTime());
        this.putUpdateLock.lock();
        try {
            try (XContentBuilder builder = XContentFactory.jsonBuilder();
                 ThreadContext.StoredContext ignore = ClientHelper.stashWithOrigin((ThreadContext)this.client.threadPool().getThreadContext(), (String)"watcher");){
                watchRecord.toXContent(builder, (ToXContent.Params)WatcherParams.HIDE_SECRETS);
                IndexRequest request = new IndexRequest(index, "doc", watchRecord.id().value()).source(builder).opType(DocWriteRequest.OpType.CREATE);
                this.client.index(request).get(30L, TimeUnit.SECONDS);
                this.logger.debug("indexed watch history record [{}]", (Object)watchRecord.id().value());
            }
            catch (VersionConflictEngineException vcee) {
                watchRecord = new WatchRecord.MessageWatchRecord(watchRecord, ExecutionState.EXECUTED_MULTIPLE_TIMES, "watch record [{ " + watchRecord.id() + " }] has been stored before, previous state [" + watchRecord.state() + "]");
                try (XContentBuilder xContentBuilder = XContentFactory.jsonBuilder();
                     ThreadContext.StoredContext ignore2 = ClientHelper.stashWithOrigin((ThreadContext)this.client.threadPool().getThreadContext(), (String)"watcher");){
                    IndexRequest request = new IndexRequest(index, "doc", watchRecord.id().value()).source(xContentBuilder.value((Object)watchRecord));
                    this.client.index(request).get(30L, TimeUnit.SECONDS);
                }
                this.logger.debug("overwrote watch history record [{}]", (Object)watchRecord.id().value());
            }
        }
        catch (IOException | InterruptedException | ExecutionException | TimeoutException ioe) {
            WatchRecord wr = watchRecord;
            this.logger.error(() -> new ParameterizedMessage("failed to persist watch record [{}]", (Object)wr), (Throwable)ioe);
        }
        finally {
            this.putUpdateLock.unlock();
        }
    }

    public static boolean validate(ClusterState state) {
        String currentIndex = HistoryStoreField.getHistoryIndexNameForTime((DateTime)DateTime.now((DateTimeZone)DateTimeZone.UTC));
        IndexMetaData indexMetaData = WatchStoreUtils.getConcreteIndex(currentIndex, state.metaData());
        return indexMetaData == null || indexMetaData.getState() == IndexMetaData.State.OPEN && state.routingTable().index(indexMetaData.getIndex()).allPrimaryShardsActive();
    }
}

