/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.sql.tree;

import java.util.Objects;

public final class Location {
    private final int line;
    private final int charPositionInLine;
    public static final Location EMPTY = new Location(-1, -2);

    public Location(int line, int charPositionInLine) {
        this.line = line;
        this.charPositionInLine = charPositionInLine;
    }

    public int getLineNumber() {
        return this.line;
    }

    public int getColumnNumber() {
        return this.charPositionInLine + 1;
    }

    public String toString() {
        return "@" + this.getLineNumber() + ":" + this.getColumnNumber();
    }

    public int hashCode() {
        return Objects.hash(this.line, this.charPositionInLine);
    }

    public boolean equals(Object obj) {
        if (obj == null || obj.getClass() != this.getClass()) {
            return false;
        }
        Location other = (Location)obj;
        return this.line == other.line && this.charPositionInLine == other.charPositionInLine;
    }
}

